/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.repository;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.Collection;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.resource.AbstractExmlResourceProvider;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

public class RemoteAccessResourceProvider
extends AbstractExmlResourceProvider {
    private final String revisionOrBranch;
    private final ICmsDriver driver;
    private final Path wcPath;

    public RemoteAccessResourceProvider(ICmsDriver driver, String revisionOrBranch, Path wcPath) {
        this.driver = driver;
        this.revisionOrBranch = revisionOrBranch;
        this.wcPath = wcPath;
    }

    public void buildIndexes(IModelioProgress monitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public void commit() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Collection<IExmlResourceProvider.ExmlResource> getAllResources(IModelioProgress aMonitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Collection<IExmlResourceProvider.ExmlResource> getAllBlobs(IModelioProgress aMonitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    public File getIndexAccessPath() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return String.valueOf(this.driver.getRepositoryUri()) + "@" + this.revisionOrBranch;
    }

    public String getStamp() throws IOException {
        return "";
    }

    public URI getURI() {
        return this.driver.getRepositoryUri();
    }

    public boolean isWriteable() {
        return false;
    }

    public boolean isBrowsable() {
        return false;
    }

    public void writeStamp() throws IOException {
    }

    public boolean exists() throws IOException {
        return true;
    }

    public IExmlResourceProvider.ExmlResource getRelativePathResource(String relativePath) {
        return new RemoteResource(this.wcPath.resolve(relativePath).toFile());
    }

    protected void doCreateRepository(MMetamodel metamodel) throws IOException {
        throw new UnsupportedOperationException();
    }

    ICmsDriver getDriver() {
        return this.driver;
    }

    String getRevisionOrBranch() {
        return this.revisionOrBranch;
    }

    protected class RemoteResource
    implements IExmlResourceProvider.ExmlResource {
        private final File filePath;

        public RemoteResource(File filePath) {
            this.filePath = filePath;
        }

        public InputStream read() throws IOException {
            try {
                ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
                RemoteAccessResourceProvider.this.getDriver().getFileContent(this.filePath, outBuf, RemoteAccessResourceProvider.this.getRevisionOrBranch());
                return new ByteArrayInputStream(outBuf.toByteArray());
            }
            catch (CmsDriverException e) {
                throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
        }

        public OutputStream write() throws IOException {
            throw new AccessDeniedException(this.getPublicLocation());
        }

        public void delete() throws IOException {
            throw new AccessDeniedException(this.getPublicLocation());
        }

        public String getPublicLocation() {
            return String.valueOf(RemoteAccessResourceProvider.this.getDriver().getRepositoryUri()) + "/" + String.valueOf(this.filePath) + "@" + RemoteAccessResourceProvider.this.getRevisionOrBranch();
        }
    }
}

