/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.repository;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsLock;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.cms.repository.CmsVersionedExmlStorageHandler;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.modelio.vbasic.debug.ThreadDumper;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.session.impl.storage.IModelRefresher;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.StatusState;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.versioned.IVersionStatusInitializer;

class StatusInitializer
implements IVersionStatusInitializer {
    private static final long FLAGS_TO_RESET = 21955872818176L;
    private static final int STATUS_TIMEOUT = 2;
    private static final boolean TRACE = StatusInitializer.class.desiredAssertionStatus();
    private int loggedTimeOuts;
    private static final TimeUnit STATUS_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private Collection<SmObjectImpl> statusToInitialize = new ArrayList<SmObjectImpl>();
    private final ICmsStatusDriver statusDriver;
    private final CmsVersionedRepository repository;

    public StatusInitializer(CmsVersionedRepository repository) {
        this.repository = repository;
        this.statusDriver = repository.getDriver().getStatusDriver();
    }

    public void initObjectStatus(SmObjectImpl obj, IModelLoader modelLoader) {
        if (obj.getMClass().isCmsNode()) {
            this.statusToInitialize.add(obj);
        } else {
            modelLoader.setRStatus(obj, 0L, 0L, 4363686773760L);
        }
    }

    public void onLoadFailed(SmObjectImpl obj, IModelLoader modelLoader) {
        if (obj.getMClass().isCmsNode()) {
            this.statusToInitialize.add(obj);
            this.processDeferredStatusInit(modelLoader);
        } else {
            modelLoader.setRStatus(obj, 0L, 0L, 4363686773760L);
        }
    }

    public void processDeferredStatusInit(IModelLoader modelLoader) {
        Collection<SmObjectImpl> listToInit = this.statusToInitialize;
        this.statusToInitialize = new ArrayList<SmObjectImpl>();
        if (listToInit.isEmpty()) {
            return;
        }
        ExmlFileAccess fileAccess = this.repository.getExmlFileAccess();
        List<File> files = listToInit.stream().map(f -> fileAccess.getExmlFile((MObject)f)).toList();
        CompletableFuture<IStatusSnapshot> futureSnap = this.statusDriver.asyncGetStatusBatch(files, false);
        boolean loaderIsRefresher = modelLoader instanceof IModelRefresher;
        if (futureSnap.isDone()) {
            this.finishStatusLoading(modelLoader, this.getStillOwnedObjects(listToInit), loaderIsRefresher, futureSnap.join());
        } else {
            for (SmObjectImpl toInit : listToInit) {
                this.refreshObjectStatus(toInit, modelLoader, TempSvnStatus.STATUS);
                ((CmsVersionedExmlStorageHandler)toInit.getRepositoryObject()).setCmsStatusLoaded(false);
            }
            ((CompletableFuture)futureSnap.thenAccept(snap -> this.repository.getModelLoaderProvider().asyncRefreshModel(refresher -> this.finishStatusLoading((IModelLoader)refresher, this.getStillOwnedObjects(listToInit), loaderIsRefresher, (IStatusSnapshot)snap)))).orTimeout(2L, STATUS_TIMEOUT_UNIT).exceptionally(e -> {
                Throwable throwable = e;
                if (throwable instanceof TimeoutException) {
                    void toEx;
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    TimeoutException cfr_ignored_0 = (TimeoutException)throwable;
                    this.onStatusLoadTimeOut(listToInit, (TimeoutException)toEx);
                } else {
                    this.onStatusLoadFailed(modelLoader, listToInit, (Throwable)e);
                }
                return null;
            });
        }
    }

    private Collection<SmObjectImpl> getStillOwnedObjects(Collection<SmObjectImpl> toFilter) {
        ArrayList<SmObjectImpl> ret = new ArrayList<SmObjectImpl>(toFilter.size());
        boolean changed = false;
        for (SmObjectImpl obj : toFilter) {
            if (this.hasObjectMovedOut(obj)) continue;
            ret.add(obj);
            changed = true;
        }
        return changed ? ret : toFilter;
    }

    private boolean hasObjectMovedOut(SmObjectImpl obj) {
        IRepositoryObject repoHandle = obj.getRepositoryObject();
        if (repoHandle.getRepositoryId() != this.repository.getRepositoryId()) {
            return true;
        }
        if (!(repoHandle instanceof CmsVersionedExmlStorageHandler)) {
            return true;
        }
        CmsVersionedExmlStorageHandler h = (CmsVersionedExmlStorageHandler)repoHandle;
        return h.isStatusFullyLoaded(obj);
    }

    private void onStatusLoadFailed(IModelLoader modelLoader, Collection<SmObjectImpl> listToInit, Throwable e) {
        int failedCount = 0;
        for (SmObjectImpl obj : listToInit) {
            IRepositoryObject repoHandle = obj.getRepositoryObject();
            if (repoHandle.getRepositoryId() != this.repository.getRepositoryId()) {
                this.trace("statusLoadFailed():rid: %s is now in %s instead of %s", new Object[]{obj, obj.getRepositoryObject(), this.repository});
                continue;
            }
            if (!(repoHandle instanceof CmsVersionedExmlStorageHandler)) {
                this.trace("statusLoadFailed():handle: %s is now in %s instead of %s", new Object[]{obj, obj.getRepositoryObject(), this.repository});
                continue;
            }
            CmsVersionedExmlStorageHandler h = (CmsVersionedExmlStorageHandler)repoHandle;
            if (h.isStatusFullyLoaded(obj)) continue;
            modelLoader.setRStatus(obj, 256L, 0L, 0L);
            h.setCmsStatusLoaded(true);
            ++failedCount;
        }
        if (failedCount > 0) {
            ProjectSvn.LOG.warning(String.format("Failed loading %d elements local SVN status: %s", failedCount, e));
            listToInit.forEach(o -> ProjectSvn.LOG.warning("  - " + String.valueOf(o)));
            String msg = ProjectSvn.I18N.getMessage("StatusInitializer.onStatusLoadFailed.error", new Object[]{failedCount});
            this.repository.getErrorSupport().fireWarning((Throwable)new IOException(msg, e));
        }
    }

    private void onStatusLoadTimeOut(Collection<SmObjectImpl> listToInit, TimeoutException e) {
        ArrayList<SmObjectImpl> nonLoaded = new ArrayList<SmObjectImpl>(listToInit.size());
        for (SmObjectImpl obj : listToInit) {
            CmsVersionedExmlStorageHandler h;
            IRepositoryObject repoHandle = obj.getRepositoryObject();
            if (repoHandle.getRepositoryId() != this.repository.getRepositoryId() || !(repoHandle instanceof CmsVersionedExmlStorageHandler) || (h = (CmsVersionedExmlStorageHandler)repoHandle).isStatusFullyLoaded(obj)) continue;
            nonLoaded.add(obj);
        }
        if (!nonLoaded.isEmpty()) {
            ProjectSvn.LOG.warning(String.format("Time out loading %d elements local SVN status after %d %s:", new Object[]{nonLoaded.size(), 2, STATUS_TIMEOUT_UNIT}));
            if (++this.loggedTimeOuts <= 5) {
                ThreadDumper.Result allThreads = ThreadDumper.get().getAllThreads(true);
                nonLoaded.forEach(o -> ProjectSvn.LOG.warning("  - " + String.valueOf(o)));
                ProjectSvn.LOG.warning(allThreads.toString());
            } else {
                nonLoaded.forEach(o -> ProjectSvn.LOG.warning("  - " + String.valueOf(o)));
                ProjectSvn.LOG.info(String.format(" More than %d time outs occurred, skip thread dumping.", this.loggedTimeOuts));
            }
        }
    }

    private void finishStatusLoading(IModelLoader refresher, Collection<SmObjectImpl> listToInit, boolean runPostRefresh, IStatusSnapshot snap) {
        ExmlFileAccess fileAccess = this.repository.getExmlFileAccess();
        for (SmObjectImpl toInit : listToInit) {
            File f = fileAccess.getExmlFile((MObject)toInit);
            ICmsStatus lstatus = snap.get(f);
            this.refreshObjectStatus(toInit, refresher, lstatus);
        }
        if (runPostRefresh) {
            this.postRefresh(listToInit, refresher);
        }
        this.setCmsNodesStatusLoaded(listToInit);
    }

    private final void trace(String sformat, Object ... args) {
        if (TRACE) {
            Log.trace((String)(this.getClass().getSimpleName() + "." + sformat), (Object[])args);
        }
    }

    private void setCmsNodesStatusLoaded(Collection<SmObjectImpl> listToInit) {
        for (SmObjectImpl obj : listToInit) {
            IRepositoryObject repoHandle = obj.getRepositoryObject();
            if (repoHandle.getRepositoryId() != this.repository.getRepositoryId()) {
                this.trace("setCmsNodesStatusLoaded():rid: %s is now in %s instead of %s", new Object[]{obj, repoHandle, this.repository});
                continue;
            }
            if (!(repoHandle instanceof CmsVersionedExmlStorageHandler)) {
                this.trace("setCmsNodesStatusLoaded():handle: %s is now in %s instead of %s", new Object[]{obj, repoHandle, this.repository});
                continue;
            }
            CmsVersionedExmlStorageHandler h = (CmsVersionedExmlStorageHandler)repoHandle;
            h.setCmsStatusLoaded(true);
        }
    }

    public void refreshObjectStatus(SmObjectImpl cmsNode, IModelLoader refresher, ICmsStatus cmsStatus) {
        if (cmsStatus.isVersioned()) {
            CmsVersionedRepository.StatusConf conf = new CmsVersionedRepository.StatusConf(0x8000000000L, 0x101000000000L, 0L);
            boolean objNeedsLock = this.repository.isLockNeeded() || cmsStatus.isLockingNeeded();
            conf.set(0x4000000000L, objNeedsLock && !cmsStatus.isSelfLocked());
            conf.set(0x20000000000L, objNeedsLock || cmsStatus.isSelfLocked());
            conf.set(0x800000000L, cmsStatus.isModified());
            conf.set(0x10000000000L, cmsStatus.isConflicted());
            conf.set(1024L, !cmsStatus.needsUpdate());
            conf.set(0x2000000000L, cmsStatus.isToDelete());
            refresher.setRStatus(cmsNode, conf.on, conf.off, conf.undef);
        } else if (cmsStatus.isToAdd() || cmsNode.getData().hasAnyStatus(0x100000000000L) == StatusState.TRUE) {
            long trueFlags = 0x1000000400L;
            long falseFlags = 2095944040448L;
            if (this.repository.isLockNeeded()) {
                trueFlags |= 0x20000000000L;
            } else {
                falseFlags |= 0x20000000000L;
            }
            refresher.setRStatus(cmsNode, trueFlags, falseFlags, 0L);
            SmObjectImpl parent = (SmObjectImpl)CmsNodeUtils.getParentCmsNode((MObject)cmsNode);
            if (parent != null && !parent.isDeleted()) {
                refresher.setRStatus(parent, 0x800000000L, 0L, 0L);
            }
        } else {
            refresher.setRStatus(cmsNode, 0L, 21955872818176L, 0L);
        }
    }

    public void refreshStatus(Collection<MObject> cmsNodes, IModelLoader refresher) throws CmsDriverException {
        for (MObject cmsNode : cmsNodes) {
            assert (cmsNode.getMClass().isCmsNode());
            SmObjectImpl impl = (SmObjectImpl)cmsNode;
            if (impl.getRepositoryObject().getRepositoryId() == this.repository.getRepositoryId()) {
                File f = this.repository.getExmlFileAccess().getExmlFile(cmsNode);
                ICmsStatus status = this.statusDriver.getStatus(f, false);
                this.refreshObjectStatus(impl, refresher, status);
                CmsVersionedExmlStorageHandler h = (CmsVersionedExmlStorageHandler)impl.getRepositoryObject();
                h.setCmsStatusLoaded(true);
                continue;
            }
            this.trace("refreshStatus(): %s is now in %s instead of %s", new Object[]{impl, impl.getRepositoryObject(), this.repository});
        }
        this.postRefresh(cmsNodes, refresher);
    }

    /*
     * WARNING - void declaration
     */
    public void loadCmsNodeStatus(SmObjectImpl obj, IModelLoader modelLoader) {
        IRepositoryObject iRepositoryObject = obj.getRepositoryObject();
        if (iRepositoryObject instanceof CmsVersionedExmlStorageHandler) {
            void h;
            CmsVersionedExmlStorageHandler cmsVersionedExmlStorageHandler = (CmsVersionedExmlStorageHandler)iRepositoryObject;
            CmsVersionedExmlStorageHandler cfr_ignored_0 = (CmsVersionedExmlStorageHandler)iRepositoryObject;
            if (h.isCmsStatusLoaded()) {
                return;
            }
        }
        try {
            this.refreshStatus(List.of(obj), modelLoader);
        }
        catch (CmsDriverException | RuntimeException e) {
            this.onStatusLoadFailed(modelLoader, List.of(obj), (Throwable)e);
        }
    }

    private void postRefresh(Collection<? extends MObject> cmsNodes, IModelLoader modelLoader) {
        for (MObject mObject : cmsNodes) {
            SmObjectImpl obj = (SmObjectImpl)mObject;
            boolean hasAddedChildren = this.hasCmsAddedChildren(obj, modelLoader);
            if (!hasAddedChildren && !obj.getRepositoryObject().isDirty(obj)) continue;
            modelLoader.setRStatus(obj, 0x800000000L, 0L, 0L);
        }
    }

    private boolean hasCmsAddedChildren(SmObjectImpl impl, IModelLoader modelLoader) {
        for (MObject c : CmsNodeUtils.getChildren((MObject)impl)) {
            SmObjectImpl obj = (SmObjectImpl)c;
            this.loadCmsNodeStatus(impl, modelLoader);
            if (obj.getData().hasAllStatus(0x1000000000L) != StatusState.TRUE) continue;
            return true;
        }
        return false;
    }

    private static class TempSvnStatus
    implements ICmsStatus {
        public static final TempSvnStatus STATUS = new TempSvnStatus();

        private TempSvnStatus() {
        }

        @Override
        public long getLastRevision() {
            return -1L;
        }

        @Override
        public ICmsLock getLock() {
            return null;
        }

        @Override
        public long getRevision() {
            return -1L;
        }

        @Override
        public boolean isConflicted() {
            return false;
        }

        @Override
        public boolean isLockingNeeded() {
            return true;
        }

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public boolean isSelfLocked() {
            return false;
        }

        @Override
        public boolean isToAdd() {
            return false;
        }

        @Override
        public boolean isToDelete() {
            return false;
        }

        @Override
        public boolean isVersioned() {
            return true;
        }

        @Override
        public boolean needsUpdate() {
            return true;
        }
    }
}

