/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.modelio.metamodel.uml.infrastructure.AbstractResource;
import org.modelio.vcore.model.filter.IObjectFilter;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MStatus;

public class CmsNodeUtils {
    public static Collection<MObject> getChildren(MObject node) {
        HashSet<MObject> ret = new HashSet<MObject>();
        HashSet<MObject> cycleCtx = new HashSet<MObject>();
        ArrayList<MObject> children = new ArrayList<MObject>();
        CmsNodeUtils.getCompositionChildren(node, children, cycleCtx);
        while (!children.isEmpty()) {
            ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
            for (MObject e : children) {
                if (e.getMClass().isCmsNode()) {
                    if (ret.contains(e)) continue;
                    ret.add(e);
                    continue;
                }
                CmsNodeUtils.getCompositionChildren(e, newChildren, cycleCtx);
            }
            children = newChildren;
        }
        return ret;
    }

    public static List<MObject> getAutomaticChildren(MObject in) {
        MStatus elementStatus = in.getStatus();
        if (!elementStatus.isRamc()) {
            ArrayList<MObject> ret = new ArrayList<MObject>();
            HashSet<MObject> cycleCtx = new HashSet<MObject>();
            ArrayList<MObject> children = new ArrayList<MObject>();
            CmsNodeUtils.getCompositionChildren(in, children, cycleCtx);
            while (!children.isEmpty()) {
                ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
                for (MObject e : children) {
                    if (e instanceof AbstractResource) {
                        ret.add(e);
                        continue;
                    }
                    if (e.getMClass().isCmsNode()) continue;
                    CmsNodeUtils.getCompositionChildren(e, newChildren, cycleCtx);
                }
                children = newChildren;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static Set<MObject> getAllChildren(MObject node) {
        HashSet<MObject> ret = new HashSet<MObject>();
        HashSet<MObject> cycleCtx = new HashSet<MObject>();
        ArrayList<MObject> children = new ArrayList<MObject>();
        CmsNodeUtils.getCompositionChildren(node, children, cycleCtx);
        while (!children.isEmpty()) {
            ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
            for (MObject e : children) {
                if (e.getMClass().isCmsNode() && !ret.contains(e)) {
                    ret.add(e);
                }
                CmsNodeUtils.getCompositionChildren(e, newChildren, cycleCtx);
            }
            children = newChildren;
        }
        return ret;
    }

    private static void getCompositionChildren(MObject node, List<MObject> ret, Set<MObject> cycleCtx) {
        List children = node.getCompositionChildren();
        for (MObject e : children) {
            if (cycleCtx.contains(e)) continue;
            ret.add(e);
            cycleCtx.add(e);
        }
    }

    public static Set<MObject> getAllFilteredChildren(MObject node, Predicate<MObject> filter) {
        HashSet<MObject> ret = new HashSet<MObject>();
        HashSet<MObject> cycleCtx = new HashSet<MObject>();
        ArrayList<MObject> children = new ArrayList<MObject>();
        CmsNodeUtils.getCompositionChildren(node, children, cycleCtx);
        while (!children.isEmpty()) {
            ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
            for (MObject e : children) {
                if (e.getMClass().isCmsNode() && filter.test(e) && !ret.contains(e)) {
                    ret.add(e);
                }
                CmsNodeUtils.getCompositionChildren(e, newChildren, cycleCtx);
            }
            children = newChildren;
        }
        return ret;
    }

    public static Set<MObject> getAllChildren(Collection<MObject> nodes) {
        HashSet<MObject> ret = new HashSet<MObject>();
        HashSet<MObject> cycleCtx = new HashSet<MObject>();
        ArrayList<MObject> children = new ArrayList<MObject>();
        for (MObject node : nodes) {
            CmsNodeUtils.getCompositionChildren(node, children, cycleCtx);
        }
        while (!children.isEmpty()) {
            ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
            for (MObject e : children) {
                if (e.getMClass().isCmsNode() && !ret.contains(e)) {
                    ret.add(e);
                }
                CmsNodeUtils.getCompositionChildren(e, newChildren, cycleCtx);
            }
            children = newChildren;
        }
        return ret;
    }

    public static Set<MObject> getAllFilteredChildren(Collection<MObject> nodes, IObjectFilter filter) {
        HashSet<MObject> ret = new HashSet<MObject>();
        HashSet<MObject> cycleCtx = new HashSet<MObject>();
        ArrayList<MObject> children = new ArrayList<MObject>();
        for (MObject node : nodes) {
            CmsNodeUtils.getCompositionChildren(node, children, cycleCtx);
        }
        while (!children.isEmpty()) {
            ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
            for (MObject child : children) {
                if (child.getMClass().isCmsNode() && filter.accept(child) && !ret.contains(child)) {
                    ret.add(child);
                }
                CmsNodeUtils.getCompositionChildren(child, newChildren, cycleCtx);
            }
            children = newChildren;
        }
        return ret;
    }

    public static MObject getCmsNode(MObject anElement) {
        MObject el = anElement;
        while (el != null && !el.getMClass().isCmsNode()) {
            el = el.getCompositionOwner();
        }
        return el;
    }

    public static MObject getParentCmsNode(MObject anElement) {
        return CmsNodeUtils.getCmsNode(anElement.getCompositionOwner());
    }

    private static void collectExcluded(MObject node, Collection<MObject> ret, Function<MObject, Collection<? extends MObject>>[] getters, Set<MObject> cycleCtx) {
        Function<MObject, Collection<? extends MObject>>[] functionArray = getters;
        int n = getters.length;
        int n2 = 0;
        while (n2 < n) {
            Function<MObject, Collection<? extends MObject>> f = functionArray[n2];
            for (MObject mObject : f.apply(node)) {
                if (cycleCtx.contains(mObject)) continue;
                ret.add(mObject);
                cycleCtx.add(mObject);
            }
            ++n2;
        }
    }

    @SafeVarargs
    public static Set<MObject> collectAll(Collection<MObject> nodes, Predicate<MObject> filter, Function<MObject, Collection<? extends MObject>> ... getters) {
        HashSet<MObject> ret = new HashSet<MObject>();
        HashSet<MObject> cycleCtx = new HashSet<MObject>();
        ArrayList<MObject> children = new ArrayList<MObject>();
        for (MObject node : nodes) {
            CmsNodeUtils.collectExcluded(node, children, getters, cycleCtx);
        }
        while (!children.isEmpty()) {
            ArrayList<MObject> newChildren = new ArrayList<MObject>(20);
            for (MObject child : children) {
                if (child.getMClass().isCmsNode() && !ret.contains(child) && filter.test(child)) {
                    ret.add(child);
                }
                CmsNodeUtils.collectExcluded(child, newChildren, getters, cycleCtx);
            }
            children = newChildren;
        }
        return ret;
    }
}

