/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.utils;

import com.modeliosoft.modelio.cms.api.ISymbolService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class SorterByName {
    private ISymbolService symbolService;

    public SorterByName(ISymbolService symbolService) {
        this.symbolService = symbolService;
    }

    public Comparator<MObject> asMObjectComparator() {
        return (a, b) -> this.getSortKey((MObject)a).compareTo(this.getSortKey((MObject)b));
    }

    public <T> Comparator<T> asMObjectComparator(Function<T, MObject> mapper) {
        return (a, b) -> this.getSortKey((MObject)mapper.apply(a)).compareTo(this.getSortKey((MObject)mapper.apply(b)));
    }

    public <T> Comparator<T> asMRefComparator(Function<T, MRef> mapper) {
        return (a, b) -> this.getSortKey((MRef)mapper.apply(a)).compareTo(this.getSortKey((MRef)mapper.apply(b)));
    }

    public Comparator<MRef> asMRefComparator() {
        return (a, b) -> this.getSortKey((MRef)a).compareTo(this.getSortKey((MRef)b));
    }

    public Collection<MObject> getSortedByName(Collection<MObject> elements) {
        ArrayList<MObject> ret = new ArrayList<MObject>(elements);
        Collections.sort(ret, this.asMObjectComparator());
        return ret;
    }

    public <T> Collection<T> getSortedByName(Collection<T> elements, Function<T, MObject> mapper) {
        ArrayList<T> ret = new ArrayList<T>(elements);
        Collections.sort(ret, this.asMObjectComparator(mapper));
        return ret;
    }

    public Collection<MRef> getSortedRefsByName(Collection<MRef> refs) {
        ArrayList<MRef> ret = new ArrayList<MRef>(refs);
        Collections.sort(ret, this.asMRefComparator());
        return ret;
    }

    public <T> Collection<T> getSortedRefsByName(Collection<T> elements, Function<T, MRef> mapper) {
        ArrayList<T> ret = new ArrayList<T>(elements);
        Collections.sort(ret, this.asMRefComparator(mapper));
        return ret;
    }

    private String getSortKey(MRef ref) {
        if (ref == null) {
            return "";
        }
        return this.symbolService.getFullName(ref) + "\u0001" + ref.uuid;
    }

    private String getSortKey(MObject obj) {
        if (obj == null) {
            return "";
        }
        return this.symbolService.getFullName(obj) + "\u0001" + obj.getUuid();
    }
}

