/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.utils;

import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.metamodel.uml.infrastructure.AbstractProject;
import org.modelio.vcore.smkernel.mapi.MObject;

public final class SubversionUtils {
    private SubversionUtils() {
    }

    public static boolean isVisibleRoot(MObject el) {
        MObject parent = el.getCompositionOwner();
        if (parent == null) {
            return true;
        }
        return parent instanceof AbstractProject;
    }

    public static String getLocalizedMessage(Throwable e) {
        if (e instanceof FileSystemException) {
            FileSystemException ee = (FileSystemException)e;
            return ProjectSvn.I18N.getMessage(e.getClass().getName(), new Object[]{ee.getFile(), ee.getOtherFile(), ee.getReason()});
        }
        String msg = e.getLocalizedMessage();
        if (msg == null) {
            msg = e.toString();
        }
        if (msg.isEmpty()) {
            msg = "No message";
        }
        return msg;
    }

    public static boolean hasAVisibleRoot(Collection<MObject> elements) {
        for (MObject el : elements) {
            if (!SubversionUtils.isVisibleRoot(el)) continue;
            return true;
        }
        return false;
    }

    public static <T> void deduplicate(Collection<T> c1, Collection<T> c2, Collection<T> removed) {
        ArrayList<T> common = new ArrayList<T>(c1);
        common.retainAll(c2);
        c1.removeAll(common);
        c2.removeAll(common);
        removed.addAll(common);
    }
}

