/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnCommitResult;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

class CommitModelEventHandler
implements ISVNEventHandler {
    private int worked = 0;
    private int estimatedElements = 0;
    private SvnCommitResult result;
    SubProgress progress = null;
    private ExmlFileAccess geom;

    public CommitModelEventHandler(IModelioProgress monitor, ExmlFileAccess geom, SvnCommitResult result) {
        assert (geom != null);
        this.estimatedElements = -1;
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)10);
        this.result = result;
        this.geom = geom;
    }

    public CommitModelEventHandler(IModelioProgress monitor, ExmlFileAccess geom, int estimatedElements, SvnCommitResult result) {
        assert (geom != null);
        this.geom = geom;
        this.result = result;
        this.estimatedElements = estimatedElements;
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)(this.estimatedElements * 2 + 1));
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.progress.isCanceled()) {
            throw new SVNCancelException();
        }
    }

    public ICmsCommitResult getResult() {
        return this.result;
    }

    public void handleEvent(SVNEvent ev, double unused) throws SVNException {
        File file = ev.getFile();
        SVNEventAction action = ev.getAction();
        if (action == SVNEventAction.COMMIT_ADDED) {
            if (this.geom.isModelFile(file)) {
                MRef ref = this.geom.getObRef(file);
                this.result.created.add(ref);
            }
        } else if (action == SVNEventAction.COMMIT_COMPLETED) {
            this.progress.done();
        } else if (action == SVNEventAction.COMMIT_DELETED) {
            if (this.geom.isModelFile(file)) {
                this.result.deleted.add(this.geom.getObRef(file));
            }
        } else if (action == SVNEventAction.COMMIT_REPLACED) {
            if (this.geom.isModelFile(file)) {
                this.result.updated.add(this.geom.getObRef(file));
            }
        } else if (action == SVNEventAction.COMMIT_MODIFIED && this.geom.isModelFile(file)) {
            this.result.updated.add(this.geom.getObRef(file));
        }
        this.progress.worked(1);
        ++this.worked;
        if (this.estimatedElements == -1) {
            this.progress.setWorkRemaining(5);
        } else if (this.worked % 5 == 0) {
            if (action == SVNEventAction.COMMIT_DELTA_SENT) {
                this.progress.subTask(ProjectSvn.I18N.getMessage("CommitModelEventHandler.deltaprogress", new Object[]{this.worked - this.estimatedElements, this.estimatedElements}));
            } else {
                this.progress.subTask(ProjectSvn.I18N.getMessage("CommitModelEventHandler.progress", new Object[]{this.worked, this.estimatedElements}));
            }
        }
    }
}

