/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import java.io.File;
import org.modelio.vbasic.log.Log;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;

class ConflictHandler
implements ISVNConflictHandler {
    private ExmlFileAccess geometry;

    public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
        if (conflictDescription.isPropertyConflict()) {
            return new SVNConflictResult(SVNConflictChoice.THEIRS_FULL, null);
        }
        if (conflictDescription.isTreeConflict()) {
            SVNConflictResult res = this.handleTreeConflict(conflictDescription);
            Log.warning((String)"Automatic resolution of '%1$s' %2$s tree conflict to %5$s : local action=%3$s, repository change=%4$s", (Object[])new Object[]{conflictDescription.getPath(), conflictDescription.getNodeKind(), conflictDescription.getConflictAction(), conflictDescription.getConflictReason(), ConflictHandler.toString(res.getConflictChoice())});
            return res;
        }
        SVNConflictAction conflictAction = conflictDescription.getConflictAction();
        if (conflictDescription.getNodeKind() == SVNNodeKind.FILE && (conflictAction == SVNConflictAction.EDIT || conflictAction == SVNConflictAction.REPLACE) && conflictDescription.getConflictReason() == SVNConflictReason.EDITED) {
            File wcFile = conflictDescription.getMergeFiles().getWCFile();
            if (this.geometry != null && this.geometry.isModelFile(wcFile)) {
                return new SVNConflictResult(SVNConflictChoice.POSTPONE, wcFile, true);
            }
            return new SVNConflictResult(SVNConflictChoice.POSTPONE, conflictDescription.getMergeFiles().getRepositoryFile());
        }
        return new SVNConflictResult(SVNConflictChoice.THEIRS_FULL, null);
    }

    private SVNConflictResult handleTreeConflict(SVNConflictDescription conflictDescription) {
        if (conflictDescription.getNodeKind() == SVNNodeKind.DIR) {
            SVNConflictReason reason = conflictDescription.getConflictReason();
            SVNConflictAction action = conflictDescription.getConflictAction();
            if (reason == SVNConflictReason.DELETED) {
                if (action == SVNConflictAction.DELETE) {
                    return new SVNConflictResult(SVNConflictChoice.MERGED, null);
                }
                return new SVNConflictResult(SVNConflictChoice.MINE_CONFLICT, null);
            }
            if (reason == SVNConflictReason.REPLACED) {
                return new SVNConflictResult(SVNConflictChoice.MINE_CONFLICT, null);
            }
            if (reason == SVNConflictReason.MOVED_AWAY && action == SVNConflictAction.EDIT) {
                return new SVNConflictResult(SVNConflictChoice.MINE_CONFLICT, null);
            }
            return new SVNConflictResult(SVNConflictChoice.MERGED, null);
        }
        return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
    }

    private static String toString(SVNConflictChoice choice) {
        if (choice == SVNConflictChoice.BASE) {
            return "BASE";
        }
        if (choice == SVNConflictChoice.MERGED) {
            return "MERGED";
        }
        if (choice == SVNConflictChoice.MINE_CONFLICT) {
            return "MINE_CONFLICT";
        }
        if (choice == SVNConflictChoice.MINE_FULL) {
            return "MINE_FULL";
        }
        if (choice == SVNConflictChoice.POSTPONE) {
            return "POSTPONE";
        }
        if (choice == SVNConflictChoice.THEIRS_CONFLICT) {
            return "THEIRS_CONFLICT";
        }
        if (choice == SVNConflictChoice.THEIRS_FULL) {
            return "THEIRS_FULL";
        }
        return choice.toString();
    }

    public void setFileGeometry(ExmlFileAccess filesGeometry) {
        this.geometry = filesGeometry;
    }
}

