/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.CmsAuthenticationException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.parse.CmsNodeStruct;
import com.modeliosoft.modelio.cms.driver.parse.StructureSnapshot;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnDriverException;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnDiffStatus;
import org.tmatesoft.svn.core.wc2.SvnDiffSummarize;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

class DiffRepositoryBuilder {
    private final SVNClientManager svnClient;
    private final File workingCopyPath;
    private final ExmlFileAccess filesAccess;
    private final SvnOperationFactory svnOpFactory;

    public DiffRepositoryBuilder(SVNClientManager svnClient, File workingCopyPath, ExmlFileAccess filesAccess) {
        this.svnClient = svnClient;
        this.workingCopyPath = workingCopyPath;
        this.filesAccess = filesAccess;
        this.svnOpFactory = this.svnClient.getDiffClient().getOperationsFactory();
    }

    public void exportDiffRepository(IModelioProgress monitor, Path targetPath, SVNURL srcUrl, String revision) throws CmsDriverException, InterruptedException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)20);
        mon.beginTask(ProjectSvn.I18N.getMessage("Monitor.Diff.GettingDiff", new Object[]{srcUrl, revision}), 2);
        State state = new State();
        state.revision = revision;
        state.srcUrl = srcUrl;
        state.targetPath = targetPath;
        SubProgress mon1 = mon.newChild(1);
        mon1.setWorkRemaining(5);
        try {
            DiffEventHandler diffResult = this.getDiffSummary(mon1, state);
            if (diffResult.getToGet().isEmpty()) {
                return;
            }
            HashSet<String> toGet = new HashSet<String>(diffResult.getToGet());
            toGet.add(this.filesAccess.getGeometry().getMetamodelDescriptorPath());
            toGet.add("admin/format_version.dat");
            toGet.add("admin/metamodel_descriptor.xml");
            FileGetter catOp = new FileGetter(this.svnClient, state);
            SubProgress mon2 = mon.newChild(1);
            mon2.beginTask("", toGet.size());
            int i = 0;
            for (String toDiff : toGet) {
                catOp.get(toDiff);
                mon2.worked(1);
                if (mon2.isCanceled()) {
                    throw new InterruptedException();
                }
                mon2.subTask(ProjectSvn.I18N.getMessage("Monitor.Diff.GettingFiles", new Object[]{srcUrl, revision, ++i, toGet.size()}));
            }
            int nb = diffResult.getToGet().size();
            SubProgress mon3 = mon.newChild(1);
            mon3.setWorkRemaining(nb);
            LocalExmlResourceProvider lr = new LocalExmlResourceProvider(targetPath, targetPath, revision);
            Files.createDirectories(targetPath.resolve("model"), new FileAttribute[0]);
            lr.open();
            ExmlFileAccess diffFileAccess = new ExmlFileAccess(targetPath.toFile(), lr.getGeometry());
            StructureSnapshot diffStruct = new StructureSnapshot(diffFileAccess);
            i = 0;
            HashSet<String> alreadyGot = new HashSet<String>(diffResult.getToGet());
            for (String relPath : diffResult.getToGet()) {
                File file = targetPath.resolve(relPath).toFile();
                if (diffFileAccess.isModelFile(file)) {
                    CmsNodeStruct content = diffStruct.getNode(file, null);
                    boolean parentPresent = false;
                    do {
                        parentPresent = false;
                        MRef parentRef = content.getParent();
                        if (parentRef != null) {
                            String parentRelPath = lr.getGeometry().getRelativePath(parentRef);
                            if (!diffResult.getToGet().contains(parentRelPath)) {
                                if (!diffResult.getAddedFiles().contains(parentRelPath) && alreadyGot.add(parentRelPath)) {
                                    Path src = this.workingCopyPath.toPath().resolve(parentRelPath);
                                    Path target = state.targetPath.resolve(parentRelPath);
                                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                    try {
                                        Files.copy(src, target, new CopyOption[0]);
                                        parentPresent = true;
                                    }
                                    catch (NoSuchFileException e) {
                                        Log.warning((String)"Parent %s of %s not in repository: %s", (Object[])new Object[]{parentRef, lr.getGeometry().getObRef(relPath), FileUtils.getLocalizedMessage((IOException)e)});
                                    }
                                }
                            } else {
                                parentPresent = true;
                            }
                            if (parentPresent) {
                                content = diffStruct.getNode(parentRef);
                            }
                        }
                        if (!mon3.isCanceled()) continue;
                        throw new InterruptedException();
                    } while (parentPresent);
                }
                mon3.subTask(ProjectSvn.I18N.getMessage("Monitor.Diff.GettingParents", new Object[]{srcUrl, revision, i, nb}));
                mon3.worked(1);
            }
        }
        catch (SVNCancelException e) {
            InterruptedException e2 = new InterruptedException();
            e2.initCause(e);
            throw e2;
        }
        catch (SVNAuthenticationException e) {
            throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
        catch (IOException e) {
            throw new SvnDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffEventHandler getDiffSummary(SubProgress mon1, State state) throws SVNException {
        SvnDiffSummarize dd = this.svnOpFactory.createDiffSummarize();
        SVNRevision fromRevision = SVNRevision.parse((String)state.revision);
        dd.setSources(SvnTarget.fromFile((File)this.workingCopyPath, (SVNRevision)SVNRevision.WORKING), SvnTarget.fromURL((SVNURL)state.srcUrl, (SVNRevision)fromRevision));
        dd.setDepth(SVNDepth.INFINITY);
        dd.setIgnoreAncestry(false);
        DiffEventHandler diffResult = new DiffEventHandler(mon1);
        dd.setReceiver((ISvnObjectReceiver)diffResult);
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            dd.run();
        }
        return diffResult;
    }

    private static final class DiffEventHandler
    implements ISvnObjectReceiver<SvnDiffStatus> {
        private int i;
        private final Collection<String> fadded = new HashSet<String>();
        private final Collection<String> fdeleted = new HashSet<String>();
        private final Collection<String> fmodified = new HashSet<String>();
        private final Collection<String> toGet = new HashSet<String>();
        private final SubProgress monitor;

        public DiffEventHandler(SubProgress mon) {
            this.monitor = mon;
        }

        public Collection<String> getToGet() {
            return this.toGet;
        }

        public Collection<String> getAddedFiles() {
            return this.fadded;
        }

        public void receive(SvnTarget target, SvnDiffStatus stat) throws SVNException {
            SVNStatusType type = stat.getModificationType();
            if (stat.getKind() == SVNNodeKind.FILE) {
                String path = stat.getPath();
                Log.trace((String)"exportDiffRepository: %s : %s at rev %s", (Object[])new Object[]{path, type, target.getResolvedPegRevision()});
                if (type == SVNStatusType.STATUS_DELETED) {
                    this.toGet.add(path);
                    this.fdeleted.add(path);
                    this.fadded.remove(path);
                    this.fmodified.remove(path);
                } else if (type == SVNStatusType.STATUS_ADDED) {
                    this.toGet.remove(path);
                    this.fadded.add(path);
                    this.fdeleted.remove(path);
                } else if (type == SVNStatusType.STATUS_MODIFIED) {
                    this.toGet.add(path);
                    if (!this.fadded.contains(path)) {
                        this.fmodified.add(path);
                    }
                } else {
                    Log.trace((String)"exportDiffRepository: %s status on %s (event=%s)", (Object[])new Object[]{type, path, stat});
                }
                this.monitor.worked(1);
                this.monitor.setWorkRemaining(5);
                if (this.monitor.isCanceled()) {
                    throw new SVNCancelException();
                }
                if (this.i++ % 5 == 0) {
                    String newLabel = ProjectSvn.I18N.getMessage("SvnDriver.UpdateMonitor", new Object[]{this.fadded.size(), this.fmodified.size(), this.fdeleted.size()});
                    this.monitor.subTask(newLabel);
                }
            }
        }
    }

    private static class FileGetter {
        private final State state;
        private final SvnCat catOp;
        private final SVNRevision svnRevision;
        private SVNClientManager svnMgr;

        public FileGetter(SVNClientManager svnMgr, State state) {
            this.svnMgr = svnMgr;
            this.state = state;
            this.svnRevision = SVNRevision.parse((String)state.revision);
            this.catOp = this.svnMgr.getDiffClient().getOperationsFactory().createCat();
            this.catOp.setDepth(SVNDepth.IMMEDIATES);
            this.catOp.setRevision(this.svnRevision);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void get(String relPath) throws SvnDriverException {
            Path filePath = this.state.targetPath.resolve(relPath);
            try {
                this.catOp.setSingleTarget(SvnTarget.fromURL((SVNURL)this.state.srcUrl.appendPath(relPath, false), (SVNRevision)this.svnRevision));
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Throwable throwable = null;
                Object var4_7 = null;
                try (OutputStream out = Files.newOutputStream(filePath, new OpenOption[0]);){
                    this.catOp.setOutput(out);
                    SVNClientManager sVNClientManager = this.svnMgr;
                    synchronized (sVNClientManager) {
                        this.catOp.run();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new SvnDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    try {
                        Files.delete(filePath);
                        Log.warning((String)e.getErrorMessage().getMessage());
                        Log.trace((Throwable)e);
                    }
                    catch (IOException e1) {
                        e.addSuppressed((Throwable)e1);
                        Log.warning((Throwable)e);
                    }
                }
                throw new SvnDriverException(e.getLocalizedMessage(), e);
            }
        }
    }

    private static class State {
        String revision;
        Path targetPath;
        SVNURL srcUrl;

        private State() {
        }
    }
}

