/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnLockResult;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

class LockModelEventHandler
implements ISVNEventHandler {
    private int i = 0;
    private int estimatedWork;
    private SvnLockResult result;
    IModelioProgress progress = null;
    private ExmlFileAccess geom;

    public LockModelEventHandler(IModelioProgress monitor, int estimatedWork, ExmlFileAccess geom, SvnLockResult result) {
        this.estimatedWork = estimatedWork;
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)estimatedWork);
        this.result = result;
        this.geom = geom;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.progress.isCanceled()) {
            throw new SVNCancelException();
        }
    }

    public ICmsLockResult getResult() {
        return this.result;
    }

    public void handleEvent(SVNEvent ev, double unused) throws SVNException {
        File file = ev.getFile();
        if (ev.getAction() == SVNEventAction.LOCKED) {
            if (this.geom.isModelFile(file)) {
                MRef ref = this.geom.getObRef(file);
                this.result.addLockedElement(ref);
            } else {
                this.result.addLockedFile(file);
            }
        } else if (ev.getAction() == SVNEventAction.LOCK_FAILED) {
            boolean isOutdated;
            SVNErrorCode errorCode = ev.getErrorMessage().getErrorCode();
            boolean isAlreadyLocked = errorCode == SVNErrorCode.FS_PATH_ALREADY_LOCKED;
            boolean bl = isOutdated = errorCode == SVNErrorCode.FS_OUT_OF_DATE;
            if (this.geom.isModelFile(file)) {
                MRef ref = this.geom.getObRef(file);
                if (isAlreadyLocked) {
                    this.result.addAlreadyLockedElement(ref);
                } else if (isOutdated) {
                    this.result.addOutdatedElement(ref);
                } else {
                    this.result.addError(ref, ev.getErrorMessage().toString());
                }
            } else if (isAlreadyLocked) {
                this.result.addAlreadyLockedFile(file);
            } else if (isOutdated) {
                this.result.addOutdatedFile(file);
            } else {
                this.result.addError(file, ev.getErrorMessage().toString());
            }
        } else if (ev.getAction() == SVNEventAction.UPDATE_COMPLETED) {
            this.progress.done();
        }
        this.progress.worked(1);
        ++this.i;
        if (this.i % 4 == 0) {
            this.progress.subTask(ProjectSvn.I18N.getMessage("LockModelEventHandler.progress", new Object[]{this.i, this.estimatedWork}));
        }
    }
}

