/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnLog;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import org.modelio.vbasic.progress.IModelioProgress;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;

class LogEntryHandler
implements ISVNLogEntryHandler {
    private boolean hasReadSomething = false;
    private long lastRevision;
    private final SvnLog log;
    private final IModelioProgress monitor;

    LogEntryHandler(IModelioProgress monitor, SvnLog log) {
        this.log = log;
        this.monitor = monitor;
    }

    public void begin() {
        this.hasReadSomething = false;
    }

    public long getLastReadRevision() {
        return this.lastRevision;
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        try {
            this.log.addEntry(logEntry);
            this.hasReadSomething = true;
            this.lastRevision = logEntry.getRevision();
        }
        catch (RuntimeException e) {
            ProjectSvn.LOG.error(e);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
    }

    public boolean hasReadSomething() {
        return this.hasReadSomething;
    }
}

