/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.StatusSnapshot;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnStatus;
import java.io.File;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;

class StatusHandler
implements ISVNStatusHandler {
    private final String userName;
    private final boolean needLocks;
    private final StatusSnapshot snapshot;
    private final ExmlFileAccess geom;

    public StatusHandler(StatusSnapshot snapshot, String userName, ExmlFileAccess geom, boolean needLocks) {
        assert (userName != null);
        assert (snapshot != null);
        assert (geom != null);
        this.needLocks = needLocks;
        this.snapshot = snapshot;
        this.userName = userName;
        this.geom = geom;
    }

    public void handleStatus(SVNStatus status) throws SVNException {
        if (this.isCancelled()) {
            throw new SVNCancelException();
        }
        if (status.getKind() == SVNNodeKind.FILE) {
            File extFile = status.getFile();
            MRef ref = null;
            if (this.geom.isModelFile(extFile)) {
                ref = this.geom.getObRef(extFile);
            }
            this.snapshot.add(extFile, ref, new SvnStatus(extFile, status, this.userName, this.needLocks));
        }
    }

    protected boolean isCancelled() {
        return false;
    }
}

