/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelio.vcore.smkernel.mapi.MRef;

class StatusSnapshot
implements IStatusSnapshot {
    private final Map<MRef, ICmsStatus> snap = new ConcurrentHashMap<MRef, ICmsStatus>();
    private final Map<File, ICmsStatus> fileSnap = new ConcurrentHashMap<File, ICmsStatus>();

    StatusSnapshot() {
    }

    @Override
    public ICmsStatus get(MRef ref) {
        return this.snap.get(ref);
    }

    @Override
    public Map<MRef, ICmsStatus> getAll() {
        return Collections.unmodifiableMap(this.snap);
    }

    void add(File f, MRef ref, ICmsStatus status) {
        this.fileSnap.put(f, status);
        if (ref != null) {
            this.snap.put(ref, status);
        }
    }

    @Override
    public ICmsStatus get(File file) {
        return this.fileSnap.get(file);
    }

    void remove(File file, MRef ref) {
        this.fileSnap.remove(file);
        if (ref != null) {
            this.snap.remove(ref);
        }
    }

    @Override
    public Map<File, ICmsStatus> getAllFiles() {
        return Collections.unmodifiableMap(this.fileSnap);
    }
}

