/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.api.CmsRevisionRange;
import com.modeliosoft.modelio.cms.api.ConflictSide;
import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.OutdatedElementsException;
import com.modeliosoft.modelio.cms.driver.CmsAuthenticationException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ElementNotVersionedException;
import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.cms.driver.ICmsLog;
import com.modeliosoft.modelio.cms.driver.ICmsRepositoryProperties;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import com.modeliosoft.modelio.cms.driver.parse.StructureSnapshot;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.CommitModelEventHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.ConflictHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.DiffRepositoryBuilder;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.LockModelEventHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.MultipleIOException;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnCommitResult;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnDriverException;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnLockResult;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnLog;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnStatusDriverHolder;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.UnlockModelEventHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.UnlockResult;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.UpdateModelEventHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.admin.SvnRepositoryProperties;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.AuthDatasAuthManager;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.repository.ConflictedResourceProvider;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.auth.OidcAuthData;
import org.modelio.vbasic.auth.SshAuthData;
import org.modelio.vbasic.auth.UserPasswordAuthData;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.local.ExmlBase;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.tmatesoft.svn.core.SVNAuthenticationCancelledException;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnResolve;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnSetProperty;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;
import org.tmatesoft.svn.core.wc2.hooks.ISvnPropertyValueProvider;

public class SvnDriver
implements ICmsDriver {
    private String user;
    private static final boolean DEBUG = false;
    private static final boolean staticInitialized = SvnDriver.staticInit();
    @Deprecated
    public static final boolean PREVENTIVE_CLEANUPS = false;
    private final boolean enforceLock;
    private final ISVNPropertyValueProvider newFilesPropertyProvider;
    private final AuthDatasAuthManager authManager;
    private ICmsFilesGetter filesGetter;
    private ExmlFileAccess filesGeometry;
    private ICmsStatusDriver statusDriver;
    private StructureSnapshot structureSnapshot;
    private final File workingCopyPath;
    private SVNURL repositoryURL;
    private final SVNClientManager svnClient;
    private final ConflictHandler conflictHandler;

    public SvnDriver(String repositoryUrl, Collection<IAuthData> authDatas, AuthDatasAuthManager projAuthProvider, File workingCopyPath, boolean enforceLock) throws CmsDriverException {
        this.workingCopyPath = workingCopyPath;
        this.enforceLock = enforceLock;
        this.newFilesPropertyProvider = new NewFilesSvnPropertyProvider(enforceLock);
        this.repositoryURL = SvnDriver.convertRepositoryPath(repositoryUrl);
        String protocol = this.repositoryURL.getProtocol();
        if (!List.of("http", "https", "file", "svn", "svn+ssh").contains(protocol)) {
            throw new SvnDriverException(ProjectSvn.I18N.getMessage("error.UnknownProtocol", new Object[]{protocol, repositoryUrl}));
        }
        this.conflictHandler = new ConflictHandler();
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        options.setConflictHandler((ISVNConflictHandler)this.conflictHandler);
        this.authManager = this.initAuth(authDatas, projAuthProvider);
        SvnOperationFactory svnOperationsFactory = new SvnOperationFactory();
        svnOperationsFactory.setAuthenticationManager((ISVNAuthenticationManager)this.authManager);
        svnOperationsFactory.setOptions((ISVNOptions)options);
        svnOperationsFactory.setWcGenerationSticky(true);
        svnOperationsFactory.setAutoCloseContext(false);
        this.svnClient = SVNClientManager.newInstance((SvnOperationFactory)svnOperationsFactory);
        CompletableFuture.runAsync(() -> {
            try {
                SVNClientManager sVNClientManager = this.svnClient;
                synchronized (sVNClientManager) {
                    this.svnClient.getWCClient().doInfo(this.repositoryURL, SVNRevision.HEAD, SVNRevision.HEAD);
                }
            }
            catch (SVNException sVNException) {}
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(File file) throws CmsDriverException {
        if (!SvnDriver.checkAddedFile(file)) {
            return;
        }
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                this.svnClient.getWCClient().doAdd(file, true, false, false, SVNDepth.INFINITY, false, false, true);
                boolean skipChecks = false;
                this.svnClient.getWCClient().doSetProperty(file, this.newFilesPropertyProvider, skipChecks, SVNDepth.EMPTY, null, null);
            }
            this.statusDriver.invalidateCache(file);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    private static boolean checkAddedFile(File f) {
        if (f.getPath().endsWith(".local.exml")) {
            assert (false) : String.valueOf(f) + " must not be versioned";
            Log.warning((Throwable)new IllegalArgumentException(String.valueOf(f) + " must not be versioned"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(File file, Map<String, String> fileProperties) throws CmsDriverException {
        if (!SvnDriver.checkAddedFile(file)) {
            return;
        }
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                this.svnClient.getWCClient().doAdd(file, true, false, false, SVNDepth.INFINITY, false, false, true);
                if (fileProperties != null && !fileProperties.isEmpty()) {
                    ISVNPropertyValueProvider propertyProvider = (path, svnProperties) -> {
                        SVNProperties out = new SVNProperties(svnProperties);
                        for (Map.Entry entry : fileProperties.entrySet()) {
                            out.put((String)entry.getKey(), (String)entry.getValue());
                        }
                        return out;
                    };
                    boolean skipChecks = false;
                    this.svnClient.getWCClient().doSetProperty(file, propertyProvider, skipChecks, SVNDepth.EMPTY, null, null);
                }
            }
            this.statusDriver.invalidateCache(file);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    @Override
    public IRepository buildConflictRepository(Path runtimePath, Collection<MObject> conflictedElements, Collection<File> conflictedFiles, ConflictSide side) throws IOException {
        ConflictedResourceProvider resProvider = new ConflictedResourceProvider(this.workingCopyPath.toPath(), runtimePath, this.svnClient, side, this.getStructureSnapshot());
        resProvider.add(conflictedElements);
        resProvider.addFiles(conflictedFiles);
        ExmlBase exmlBase = new ExmlBase((IExmlResourceProvider)resProvider);
        resProvider.setName(side.toString());
        return exmlBase;
    }

    @Override
    public void cancelDelete(IModelioProgress monitor, Collection<File> files) throws CmsDriverException {
        if (files.isEmpty()) {
            return;
        }
        try {
            ArrayList<Path> backed = new ArrayList<Path>(files.size());
            for (File file : files) {
                Path src = file.toPath();
                Path target = src.resolveSibling(file.getName() + ".bak");
                try {
                    Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
                    backed.add(src);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {}
            }
            Throwable throwable = null;
            Iterator<File> iterator = null;
            try (CancelDeleteRestorer finalizer = new CancelDeleteRestorer(backed);){
                this.revert(monitor, files);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SvnDriverException(MultipleIOException.getLocalizedMessage(e), e);
        }
    }

    @Override
    public void checkout(IModelioProgress monitor) throws CmsDriverException {
        SvnDriver.createDirectories(this.workingCopyPath);
        this.invalidateCaches();
        this.checkoutWC(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkout(String url, File wcPath, IAuthData auth, IModelioProgress monitor) throws CmsDriverException {
        SVNURL svnUrl = SvnDriver.convertRepositoryPath(url);
        SvnDriver.createDirectories(wcPath);
        String taskName = ProjectSvn.I18N.getMessage("Monitor.CheckoutWC", new Object[]{this.workingCopyPath, this.repositoryURL.toString()});
        SubProgress progress = SubProgress.convert((IModelioProgress)monitor, (String)taskName, (int)50);
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                try {
                    this.authManager.addAuth(svnUrl, auth);
                    this.svnClient.setEventHandler((ISVNEventHandler)new CheckoutWcSvnEventHandler(progress));
                    SVNUpdateClient updateClient = this.svnClient.getUpdateClient();
                    updateClient.setIgnoreExternals(false);
                    updateClient.doCheckout(svnUrl, wcPath, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true);
                }
                catch (SVNAuthenticationCancelledException e) {
                    throw this.toCmsAuthenticationException(e);
                }
                catch (SVNAuthenticationException e) {
                    throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
                }
                catch (SVNException e) {
                    throw new SvnDriverException(ProjectSvn.I18N.getMessage("error.CheckoutFailed", new Object[]{svnUrl, e.getErrorMessage().toString()}), e);
                }
            }
            finally {
                this.svnClient.setEventHandler(null);
                this.invalidateCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpWorkingCopy(IModelioProgress monitor) throws CmsDriverException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)20);
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                SvnCleanup cleanup = this.svnClient.getWCClient().getOperationsFactory().createCleanup();
                cleanup.setSingleTarget(SvnTarget.fromFile((File)this.workingCopyPath));
                cleanup.setBreakLocks(true);
                cleanup.run();
            }
            mon.worked(10);
            this.invalidateCaches();
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    private Collection<File> addModifiedParentDirectories(IModelioProgress aMonitor, Collection<File> files) throws CmsDriverException {
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (int)files.size());
        HashSet<File> out = new HashSet<File>(files);
        ArrayDeque<File> next = new ArrayDeque<File>(files);
        ICmsStatusDriver statusDrv = this.getStatusDriver();
        while (!next.isEmpty()) {
            File f = (File)next.poll();
            File parentFile = f.getParentFile();
            if (out.contains(parentFile) || parentFile.equals(this.workingCopyPath)) continue;
            ICmsStatus s = statusDrv.getStatus(parentFile, false);
            if (s.isModified() || s.isToAdd() || s.isToDelete() || !s.isVersioned()) {
                out.add(parentFile);
                next.add(parentFile);
                monitor.setWorkRemaining(next.size());
            }
            monitor.worked(1);
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICmsCommitResult commit(IModelioProgress aMonitor, Collection<File> files, boolean keepLock, String message) throws CmsDriverException, OutdatedElementsException {
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (int)files.size());
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                Collection<File> filesWithParent = this.addModifiedParentDirectories((IModelioProgress)monitor.newChild(1), files);
                File[] fileArray = SvnDriver.toArray(filesWithParent, this.workingCopyPath);
                SvnCommitResult result = new SvnCommitResult();
                SVNCommitClient commitClient = this.svnClient.getCommitClient();
                commitClient.setEventHandler((ISVNEventHandler)new CommitModelEventHandler((IModelioProgress)monitor.newChild(2), this.filesGeometry, files.size(), result));
                SVNCommitInfo svnresult = commitClient.doCommit(fileArray, keepLock, message, null, null, false, false, SVNDepth.EMPTY);
                if (svnresult.getNewRevision() <= 0L && !keepLock) {
                    ICmsUnlockResult unlockResult = this.unlock((IModelioProgress)monitor.newChild(1), files, false);
                    result.setUnlockResult(unlockResult);
                } else {
                    monitor.setWorkRemaining(0);
                }
                result.setCommitInfo(svnresult);
                SvnCommitResult svnCommitResult = result;
                return svnCommitResult;
            }
            catch (SVNAuthenticationCancelledException e) {
                throw this.toCmsAuthenticationException(e);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
            }
            catch (SVNException e) {
                SVNErrorCode errCode = e.getErrorMessage().getErrorCode();
                if (!errCode.equals((Object)SVNErrorCode.FS_TXN_OUT_OF_DATE) && !errCode.equals((Object)SVNErrorCode.FS_CONFLICT)) {
                    throw new SvnDriverException(e);
                }
                throw (OutdatedElementsException)new OutdatedElementsException().initCause((Throwable)e);
            }
            finally {
                this.svnClient.getCommitClient().setEventHandler(null);
                this.invalidateCaches();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICmsCommitResult commitAll(IModelioProgress aMonitor, String message) throws CmsDriverException {
        SvnCommitResult svnCommitResult = new SvnCommitResult();
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                this.svnClient.getCommitClient().setEventHandler((ISVNEventHandler)new CommitModelEventHandler(aMonitor, this.filesGeometry, svnCommitResult));
                File[] paths = new File[]{this.workingCopyPath};
                SVNCommitInfo commitInfo = this.svnClient.getCommitClient().doCommit(paths, false, message, null, null, false, false, SVNDepth.INFINITY);
                svnCommitResult.setCommitInfo(commitInfo);
                SvnCommitResult svnCommitResult2 = svnCommitResult;
                return svnCommitResult2;
            }
            catch (SVNAuthenticationCancelledException e) {
                throw this.toCmsAuthenticationException(e);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
            }
            catch (SVNException e) {
                SVNErrorCode errCode = e.getErrorMessage().getErrorCode();
                if (!errCode.equals((Object)SVNErrorCode.FS_TXN_OUT_OF_DATE) && !errCode.equals((Object)SVNErrorCode.FS_CONFLICT)) {
                    throw new SvnDriverException(e);
                }
                throw new SvnDriverException(e);
            }
            finally {
                this.svnClient.getWCClient().setEventHandler(null);
                this.invalidateCaches();
            }
        }
    }

    public static SVNURL convertRepositoryPath(String repositoryPath) throws CmsDriverException {
        try {
            if (repositoryPath.startsWith("file:")) {
                try {
                    return SVNURL.fromFile((File)new File(new URI(repositoryPath)));
                }
                catch (URISyntaxException uRISyntaxException) {
                    URL url = new URL(repositoryPath);
                    URI uri = new URI("file", url.getPath(), null);
                    File f = new File(uri);
                    return SVNURL.fromFile((File)f);
                }
            }
            File f = new File(repositoryPath);
            if (f.isDirectory()) {
                return SVNURL.fromFile((File)f);
            }
            return SVNURL.parseURIEncoded((String)repositoryPath);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.BAD_URL) {
                throw new SvnDriverException(ProjectSvn.I18N.getMessage("SvnConnection.BadUrl", new Object[]{repositoryPath, e.getLocalizedMessage()}), e);
            }
            throw new SvnDriverException(e);
        }
        catch (MalformedURLException e) {
            throw new SvnDriverException(ProjectSvn.I18N.getMessage("SvnConnection.BadUrl", new Object[]{repositoryPath, e.getLocalizedMessage()}), e);
        }
        catch (URISyntaxException e) {
            throw new SvnDriverException(ProjectSvn.I18N.getMessage("SvnConnection.BadUrl", new Object[]{repositoryPath, e.getLocalizedMessage()}), e);
        }
    }

    @Override
    public void createBranch(String branchName, String message) throws CmsDriverException {
        this.doCopy(branchName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRepositoryStructure(IModelioProgress monitor, MMetamodel metamodel) throws CmsDriverException {
        Throwable throwable;
        ArrayList<Path> dirs = new ArrayList<Path>();
        ArrayList files = new ArrayList();
        Path wcPath = this.workingCopyPath.toPath();
        Path modelDir = this.getWcModelDirectory().toPath();
        dirs.add(wcPath);
        dirs.add(modelDir);
        monitor.subTask("Creating repository structure 1/3 ...");
        for (File dirPath : this.getFilesGeometry().getInitialDirectories(metamodel)) {
            dirs.add(dirPath.toPath());
        }
        Path adminDir = this.getWcAdminDirectory().toPath();
        dirs.add(adminDir);
        Path stampFile = wcPath.resolve("admin").resolve("stamp.dat");
        try {
            throwable = null;
            Object var10_12 = null;
            try (Stream<Path> fs = Files.walk(adminDir, new FileVisitOption[0]);){
                fs.filter(p -> !p.equals(stampFile)).forEach(files::add);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SvnDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
        if (!dirs.isEmpty()) {
            throwable = this.svnClient;
            synchronized (throwable) {
                try {
                    try {
                        SvnScheduleForAddition addcmd;
                        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)11);
                        ProgressMonitorEventHandler handler = new ProgressMonitorEventHandler((IModelioProgress)mon.newChild(2), files.size(), SVNEventAction.ADD);
                        SvnOperationFactory opsFactory = this.svnClient.getWCClient().getOperationsFactory();
                        opsFactory.setEventHandler((ISVNEventHandler)handler);
                        try {
                            addcmd = opsFactory.createScheduleForAddition();
                            addcmd.addTarget(SvnTarget.fromFile((File)this.workingCopyPath));
                            addcmd.addTarget(SvnTarget.fromFile((File)this.getWcAdminDirectory()));
                            addcmd.setDepth(SVNDepth.EMPTY);
                            addcmd.setAddParents(false);
                            addcmd.setForce(true);
                            addcmd.setIncludeIgnored(false);
                            addcmd.run();
                        }
                        finally {
                            opsFactory.setEventHandler(null);
                        }
                        this.addToIgnore(this.getWcAdminDirectory(), "stamp.dat");
                        this.addToProp(this.workingCopyPath, "svn:global-ignores", "*.local.exml");
                        mon.worked(1);
                        mon.subTask("Creating repository structure 2/3 ...");
                        handler = new ProgressMonitorEventHandler((IModelioProgress)mon.newChild(2), files.size(), SVNEventAction.ADD);
                        opsFactory.setEventHandler((ISVNEventHandler)handler);
                        try {
                            addcmd = opsFactory.createScheduleForAddition();
                            addcmd.addTarget(SvnTarget.fromFile((File)this.workingCopyPath));
                            addcmd.setDepth(SVNDepth.INFINITY);
                            addcmd.setAddParents(false);
                            addcmd.setForce(true);
                            addcmd.setIncludeIgnored(false);
                            addcmd.run();
                        }
                        finally {
                            opsFactory.setEventHandler(null);
                        }
                        try {
                            SvnRevert revCmd = opsFactory.createRevert();
                            revCmd.addTarget(SvnTarget.fromFile((File)stampFile.toFile()));
                            revCmd.run();
                        }
                        catch (SVNException e) {
                            Log.warning((Throwable)e);
                        }
                        mon.worked(1);
                        mon.subTask("Creating repository structure 3/3 : committing to SVN ...");
                        SvnCommitResult svnCommitResult = new SvnCommitResult();
                        this.svnClient.getCommitClient().setEventHandler((ISVNEventHandler)new CommitModelEventHandler((IModelioProgress)mon.newChild(5), this.filesGeometry, svnCommitResult));
                        SvnCommit commitCmd = this.svnClient.getCommitClient().getOperationsFactory().createCommit();
                        commitCmd.addTarget(SvnTarget.fromFile((File)this.workingCopyPath));
                        commitCmd.setDepth(SVNDepth.INFINITY);
                        commitCmd.setCombinePackets(true);
                        commitCmd.setKeepLocks(false);
                        commitCmd.setCommitMessage(ProjectSvn.I18N.getMessage("SvnDriver.updateRepositoryStructure.commitmsg", new Object[0]));
                        commitCmd.run();
                    }
                    catch (SVNAuthenticationCancelledException e) {
                        throw this.toCmsAuthenticationException(e);
                    }
                    catch (SVNAuthenticationException e) {
                        throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
                    }
                    catch (SVNException e) {
                        throw new SvnDriverException(e);
                    }
                    catch (IOException e) {
                        throw new SvnDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
                    }
                }
                finally {
                    this.svnClient.getCommitClient().setEventHandler(null);
                    monitor.subTask("");
                }
            }
        }
    }

    @Override
    public void createTag(String tagName, String message) throws CmsDriverException {
        this.doCopy(tagName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(IModelioProgress monitor, Collection<File> filesToDelete) throws CmsDriverException {
        if (filesToDelete.isEmpty()) {
            return;
        }
        ProgressMonitorEventHandler handler = new ProgressMonitorEventHandler(monitor, filesToDelete.size(), SVNEventAction.DELETE);
        SvnOperationFactory operationsFactory = this.svnClient.getWCClient().getOperationsFactory();
        SvnScheduleForRemoval remove = operationsFactory.createScheduleForRemoval();
        for (File file : filesToDelete) {
            remove.addTarget(SvnTarget.fromFile((File)file));
        }
        remove.setForce(true);
        remove.setDeleteFiles(false);
        remove.setDryRun(false);
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            operationsFactory.setEventHandler((ISVNEventHandler)handler);
            try {
                try {
                    remove.run();
                }
                catch (SVNException e) {
                    throw new SvnDriverException(e);
                }
            }
            finally {
                operationsFactory.setEventHandler(null);
                this.statusDriver.invalidateCache(filesToDelete);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void delete(File file) throws CmsDriverException, ElementNotVersionedException {
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                try {
                    this.svnClient.getWCClient().doDelete(file, true, false, false);
                }
                catch (SVNException e) {
                    SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
                    if (errorCode == SVNErrorCode.BAD_FILENAME || errorCode == SVNErrorCode.UNVERSIONED_RESOURCE || errorCode == SVNErrorCode.WC_PATH_NOT_FOUND || errorCode == SVNErrorCode.WC_NOT_WORKING_COPY) {
                        if (!this.filesGeometry.isModelFile(file)) throw new SvnDriverException(e);
                        MRef ref = this.filesGeometry.getObRef(file);
                        throw new ElementNotVersionedException(ref, (Throwable)e);
                    }
                    if (errorCode != SVNErrorCode.CLIENT_MODIFIED) throw new SvnDriverException(e);
                    try {
                        File[] paths = new File[]{file};
                        this.svnClient.getWCClient().doRevert(paths, SVNDepth.EMPTY, null);
                        this.svnClient.getWCClient().doDelete(file, true, false, false);
                        this.statusDriver.invalidateCache(file);
                    }
                    catch (SVNException e1) {
                        e.addSuppressed((Throwable)e1);
                        throw new SvnDriverException(e);
                    }
                    return;
                }
            }
            finally {
                this.statusDriver.invalidateCache(file);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICmsUpdateResult exportRepository(IModelioProgress monitor, String label, String revision, File destPath) throws CmsDriverException, InterruptedException {
        SubProgress progress = SubProgress.convert((IModelioProgress)monitor);
        progress.beginTask(ProjectSvn.I18N.getMessage("Monitor.Export", new Object[]{label, revision}), -1);
        UpdateModelEventHandler handler = new UpdateModelEventHandler((IModelioProgress)progress, this.filesGeometry.copyIn(destPath));
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            this.svnClient.setEventHandler((ISVNEventHandler)handler);
            try {
                try {
                    SVNRevision rev = SVNRevision.parse((String)revision);
                    SVNUpdateClient updateClient = this.svnClient.getUpdateClient();
                    SVNURL srcPath = label == null ? this.repositoryURL : SvnDriver.convertRepositoryPath(label);
                    updateClient.setIgnoreExternals(false);
                    updateClient.doExport(srcPath, destPath, SVNRevision.HEAD, rev, null, true, SVNDepth.INFINITY);
                }
                catch (SVNAuthenticationCancelledException e) {
                    throw this.toCmsAuthenticationException(e);
                }
                catch (SVNCancelException e) {
                    InterruptedException e2 = new InterruptedException();
                    e2.initCause(e);
                    throw e2;
                }
                catch (SVNAuthenticationException e) {
                    throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
                }
                catch (SVNException e) {
                    throw new SvnDriverException(e);
                }
            }
            finally {
                this.svnClient.setEventHandler(null);
            }
        }
        return handler.getResult();
    }

    @Override
    public ICmsRepositoryProperties getAdminProperties() throws IOException {
        return new SvnRepositoryProperties(this.workingCopyPath);
    }

    @Override
    public ICmsFilesGetter getFilesGetter() {
        if (this.filesGetter == null) {
            throw new IllegalStateException();
        }
        return this.filesGetter;
    }

    @Override
    public final ExmlFileAccess getFilesGeometry() {
        if (this.filesGeometry == null) {
            throw new IllegalStateException();
        }
        return this.filesGeometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICmsLog getLog(IModelioProgress monitor, Collection<File> files) throws CmsDriverException {
        File[] filesToLog = files == null || files.isEmpty() ? new File[]{this.getWcModelDirectory()} : SvnDriver.toArray(files);
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                SVNURL rootUrl = this.svnClient.getWCClient().getReposRoot(this.workingCopyPath, this.repositoryURL, SVNRevision.WORKING);
                SVNInfo wcInfo = this.svnClient.getWCClient().doInfo(this.workingCopyPath, SVNRevision.WORKING);
                SVNURL wcUrl = wcInfo.getURL();
                String wcRelPathInRepo = wcUrl.getPath().replace(rootUrl.getPath(), "");
                ExmlFileAccess reposGeom = this.filesGeometry.copyIn(new File(wcRelPathInRepo));
                SvnLog log = new SvnLog(filesToLog, this.svnClient, reposGeom, monitor);
                return log;
            }
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    @Override
    public ICmsLog getLog(IModelioProgress monitor, String branchUrl, String fromRevision, Collection<File> filesToLog, boolean stopOnBranchStart) throws CmsDriverException {
        SVNRevision svnFromRevision;
        SVNURL svnBranchUrl = branchUrl == null || branchUrl.isEmpty() ? this.repositoryURL : SvnDriver.convertRepositoryPath(branchUrl);
        if (fromRevision == null || fromRevision.isEmpty()) {
            svnFromRevision = SVNRevision.HEAD;
        } else {
            svnFromRevision = SVNRevision.parse((String)fromRevision);
            if (!svnFromRevision.isValid()) {
                throw new SvnDriverException("'" + fromRevision + "' is not a valid revision.");
            }
        }
        String[] targetPaths = null;
        if (filesToLog != null && !filesToLog.isEmpty()) {
            targetPaths = new String[filesToLog.size()];
            int i = 0;
            for (File f : filesToLog) {
                targetPaths[i] = this.workingCopyPath.toPath().relativize(f.toPath()).toString();
                ++i;
            }
        }
        SvnLog log = new SvnLog(svnBranchUrl, svnFromRevision, stopOnBranchStart, targetPaths, this.svnClient, this.filesGeometry, monitor);
        return log;
    }

    @Override
    public URI getRepositoryUri() {
        return URI.create(this.repositoryURL.toString());
    }

    @Override
    public ICmsStatusDriver getStatusDriver() {
        return this.statusDriver;
    }

    @Override
    public StructureSnapshot getStructureSnapshot() {
        this.structureSnapshot = new StructureSnapshot(this.getFilesGeometry());
        return this.structureSnapshot;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isVersioned(Path p) {
        return SVNWCUtil.isVersionedDirectory((File)p.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICmsLockResult lock(IModelioProgress aMonitor, Collection<File> filesToLock, boolean stealLock, String lockComment) throws CmsDriverException {
        SvnLockResult result = new SvnLockResult();
        if (filesToLock.isEmpty()) {
            return result;
        }
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                LockModelEventHandler handler = new LockModelEventHandler(aMonitor, filesToLock.size(), this.filesGeometry, result);
                this.svnClient.getWCClient().setEventHandler((ISVNEventHandler)handler);
                this.svnClient.getWCClient().doLock(SvnDriver.toArray(filesToLock), stealLock, lockComment);
                SvnLockResult svnLockResult = result;
                return svnLockResult;
            }
            catch (SVNAuthenticationCancelledException e) {
                throw this.toCmsAuthenticationException(e);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
            }
            catch (SVNException e) {
                throw new SvnDriverException(e);
            }
            finally {
                this.svnClient.getWCClient().setEventHandler(null);
                this.statusDriver.invalidateCache(filesToLock);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ICmsUpdateResult merge(IModelioProgress monitor, String fromUrl, Collection<String> revisions) throws CmsDriverException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public ICmsUpdateResult merge(IModelioProgress monitor, String fromUrl, String fromRevision, Collection<CmsRevisionRange> revisions) throws CmsDriverException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void moveFile(File oldPath, File newPath, boolean doMoveFile) throws CmsDriverException {
        this.copyMoveFile(oldPath, newPath, true, doMoveFile);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void relocateRepository(IModelioProgress monitor, String newRepositoryPath) throws CmsDriverException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(IModelioProgress monitor, Collection<File> files) throws CmsDriverException {
        if (files.isEmpty()) {
            return;
        }
        int nbfiles = files.size();
        ProgressMonitorEventHandler handler = new ProgressMonitorEventHandler(monitor, nbfiles, new SVNEventAction[0]){

            @Override
            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                SVNEventAction action;
                super.handleEvent(event, progress);
                if (event.getFile() != null) {
                    SvnDriver.this.statusDriver.invalidateCache(event.getFile());
                }
                if ((action = event.getAction()) == SVNEventAction.REVERT) {
                    Log.trace((String)"SvnDriver : reverted '%s'", (Object[])new Object[]{event.getFile()});
                } else if (action == SVNEventAction.FAILED_REVERT) {
                    Log.error((String)"SvnDriver : SVN revert failed on '%s': %s", (Object[])new Object[]{event.getFile(), event.getErrorMessage()});
                    if (event.getErrorMessage() != null) {
                        throw new SVNException(event.getErrorMessage());
                    }
                }
            }
        };
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                try {
                    Map<File, Collection<File>> groups = this.groupByWorkingCopy(files);
                    this.svnClient.getWCClient().setEventHandler((ISVNEventHandler)handler);
                    for (Map.Entry<File, Collection<File>> group : groups.entrySet()) {
                        this.svnClient.getWCClient().doRevert(SvnDriver.toArray(group.getValue()), SVNDepth.FILES, null);
                    }
                }
                catch (SVNAuthenticationCancelledException e) {
                    throw this.toCmsAuthenticationException(e);
                }
                catch (SVNAuthenticationException e) {
                    throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
                }
                catch (SVNException e) {
                    throw new SvnDriverException(e);
                }
            }
            finally {
                this.svnClient.getWCClient().setEventHandler(null);
            }
        }
    }

    @Override
    public ICmsUpdateResult revertRevision(IModelioProgress monitor, String revision) throws CmsDriverException {
        SVNRevision to = SVNRevision.parse((String)revision);
        String from = String.valueOf(to.getNumber() - 1L);
        CmsRevisionRange range = new CmsRevisionRange(to.toString(), from);
        return this.merge(monitor, this.repositoryURL.toString(), null, Collections.singleton(range));
    }

    @Override
    public void initialize(ICmsFilesGetter filesGetter) {
        Objects.requireNonNull(filesGetter);
        Objects.requireNonNull(filesGetter.getFilesGeometry());
        this.filesGetter = filesGetter;
        this.filesGeometry = filesGetter.getFilesGeometry();
        this.conflictHandler.setFileGeometry(this.filesGeometry);
        this.statusDriver = new SvnStatusDriverHolder(this.svnClient, this.filesGeometry, this.user, this.enforceLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResolved(Collection<File> conflictedFiles, ConflictSide side) throws CmsDriverException {
        SVNConflictChoice choice = switch (side) {
            case ConflictSide.BASE -> SVNConflictChoice.BASE;
            case ConflictSide.MINE -> SVNConflictChoice.MINE_FULL;
            case ConflictSide.THEIRS -> SVNConflictChoice.THEIRS_FULL;
            case ConflictSide.MERGED -> SVNConflictChoice.MERGED;
            default -> throw new AssertionError(side);
        };
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                SvnResolve resolve = this.svnClient.getWCClient().getOperationsFactory().createResolve();
                resolve.setDepth(SVNDepth.EMPTY);
                resolve.setConflictChoice(choice);
                for (File f : conflictedFiles) {
                    resolve.addTarget(SvnTarget.fromFile((File)f));
                }
                resolve.run();
            }
            catch (SVNAuthenticationCancelledException e) {
                throw this.toCmsAuthenticationException(e);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
            }
            catch (SVNException e) {
                throw new SvnDriverException(e);
            }
        }
        this.statusDriver.invalidateCache(conflictedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> suggestMergeSources() throws SvnDriverException, CmsAuthenticationException {
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                SVNDiffClient diffClient = this.svnClient.getDiffClient();
                Collection srcs = diffClient.doSuggestMergeSources(this.workingCopyPath, SVNRevision.HEAD);
                ArrayList<String> ret = new ArrayList<String>(srcs.size());
                for (SVNURL url : srcs) {
                    ret.add(url.toDecodedString());
                }
                ret.add(this.repositoryURL.toDecodedString());
                return ret;
            }
        }
        catch (SVNAuthenticationCancelledException e) {
            throw this.toCmsAuthenticationException(e);
        }
        catch (SVNCancelException sVNCancelException) {
            return null;
        }
        catch (SVNAuthenticationException e) {
            throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ICmsUpdateResult switchWorkingCopy(IModelioProgress monitor, String newRepositoryPath) throws CmsDriverException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICmsUnlockResult unlock(IModelioProgress aMonitor, Collection<File> filesToUnlock, boolean breakLock) throws CmsDriverException {
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (int)(filesToUnlock.size() + 1));
        ArrayList<File> files = new ArrayList<File>(filesToUnlock.size());
        UnlockResult result = new UnlockResult();
        for (File f : filesToUnlock) {
            if (!breakLock && !this.getStatusDriver().getStatus(f, false).isSelfLocked()) continue;
            files.add(f);
        }
        monitor.worked(1);
        if (files.isEmpty()) {
            return result;
        }
        monitor.subTask("Unlocking " + files.size() + " files...");
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                File[] fileArray = files.toArray(new File[files.size()]);
                UnlockModelEventHandler handler = new UnlockModelEventHandler((IModelioProgress)monitor, files.size(), result, this.filesGeometry);
                this.svnClient.getWCClient().setEventHandler((ISVNEventHandler)handler);
                this.svnClient.getWCClient().doUnlock(fileArray, breakLock);
                UnlockResult unlockResult = result;
                return unlockResult;
            }
            catch (SVNAuthenticationCancelledException e) {
                throw this.toCmsAuthenticationException(e);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
            }
            catch (SVNException e) {
                throw new SvnDriverException(e);
            }
            finally {
                this.svnClient.getWCClient().setEventHandler(null);
                this.statusDriver.invalidateCache(filesToUnlock);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int updateAdmin(IModelioProgress monitor) throws CmsDriverException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public ICmsUpdateResult updateModel(IModelioProgress monitor, Collection<File> additionalUpdates, String revision) throws CmsDriverException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void debugHttp500(File[] toUpdate, SVNRevision rev, SVNException e) {
        if (Log.getLogger().getLevel() != 0) {
            return;
        }
        Log.trace((String)(e.getMessage() + " infos:"));
        Log.trace((String)" - revision = %s", (Object[])new Object[]{rev});
        Log.trace((String)" - toUpdate = %s", (Object[])new Object[]{Arrays.toString(toUpdate)});
        Log.trace((String)" - repositoryURL = %s", (Object[])new Object[]{this.repositoryURL});
        try {
            SVNUpdateClient updateClient = this.svnClient.getUpdateClient();
            Log.trace((String)" - repo root for rev %s = %s", (Object[])new Object[]{rev, updateClient.getReposRoot(this.workingCopyPath, this.repositoryURL, rev)});
            Log.trace((String)" - repo root for rev %s = %s", (Object[])new Object[]{SVNRevision.WORKING, updateClient.getReposRoot(this.workingCopyPath, this.repositoryURL, SVNRevision.WORKING)});
        }
        catch (SVNException e1) {
            Log.trace((String)"Failed getting at least one repository root");
            Log.trace((Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRepositoryStructure(IModelioProgress monitor, MMetamodel metamodel) throws CmsDriverException {
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            this.upgradeWorkingCopy(monitor);
            ArrayList dirsToCreate = new ArrayList();
            dirsToCreate.addAll(this.filesGeometry.getGeometry().getInitialDirectories(metamodel));
            SVNRepository repo = this.getSvnRepositoryConnection();
            boolean hasMissingWcDirs = false;
            try {
                long revision = repo.getLatestRevision();
                Iterator it = dirsToCreate.iterator();
                while (it.hasNext()) {
                    String dir = (String)it.next();
                    File d = new File(this.workingCopyPath, dir);
                    String svnPath = dir.replace(File.separatorChar, '/');
                    SVNNodeKind nodeKind = repo.checkPath(svnPath, revision);
                    if (nodeKind == SVNNodeKind.DIR) {
                        if (d.isDirectory()) {
                            SVNStatusType status = this.svnClient.getStatusClient().doStatus(d, false).getContentsStatus();
                            if (status == SVNStatusType.STATUS_NORMAL || status == SVNStatusType.STATUS_MODIFIED) {
                                it.remove();
                                continue;
                            }
                            if (status == SVNStatusType.STATUS_ADDED) continue;
                            throw new SvnDriverException(ProjectSvn.I18N.getMessage("SvnDriver.updateRepositoryStructure.badstatus", new Object[]{d.getPath(), status.toString()}));
                        }
                        it.remove();
                        hasMissingWcDirs = true;
                        continue;
                    }
                    SvnDriver.createDirectories(d);
                }
                repo.closeSession();
            }
            catch (SVNAuthenticationCancelledException e) {
                throw this.toCmsAuthenticationException(e);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
            }
            catch (SVNException e) {
                throw new SvnDriverException(e);
            }
            if (!dirsToCreate.isEmpty()) {
                SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)(dirsToCreate.size() + 15));
                try {
                    File[] wcdirsToCreate = new File[dirsToCreate.size()];
                    int i = 0;
                    for (String d : dirsToCreate) {
                        wcdirsToCreate[i] = new File(this.workingCopyPath, d);
                        ++i;
                    }
                    this.svnClient.getWCClient().doAdd(wcdirsToCreate, true, false, false, SVNDepth.EMPTY, false, false, false);
                    mon.worked(5);
                    SVNCommitInfo commitInfo = this.svnClient.getCommitClient().doCommit(wcdirsToCreate, false, ProjectSvn.I18N.getMessage("SvnDriver.updateRepositoryStructure.commitmsg", new Object[0]), null, null, false, false, SVNDepth.EMPTY);
                    if (commitInfo.getErrorMessage() != null) {
                        throw new SVNException(commitInfo.getErrorMessage());
                    }
                    mon.done();
                }
                catch (SVNAuthenticationCancelledException e) {
                    throw this.toCmsAuthenticationException(e);
                }
                catch (SVNAuthenticationException e) {
                    throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
                }
                catch (SVNException e) {
                    throw new SvnDriverException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExmlFilesAsBinary(IModelioProgress monitor) throws SVNException {
        final SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)10);
        final ExmlFileAccess geom = this.filesGeometry;
        ISVNPropertyValueProvider propertyValueProvider = new ISVNPropertyValueProvider(){

            public SVNProperties providePropertyValues(File path, SVNProperties properties) {
                if (geom.isModelFile(path)) {
                    SVNProperties modif = new SVNProperties(properties);
                    modif.put("svn:mime-type", "application/octet-stream");
                    return modif;
                }
                return properties;
            }
        };
        ISVNPropertyHandler handler = new ISVNPropertyHandler(){

            public void handleProperty(long revision, SVNPropertyData property) {
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) {
            }

            public void handleProperty(File path, SVNPropertyData property) {
                mon.worked(1);
                mon.setWorkRemaining(10);
            }
        };
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            this.svnClient.getWCClient().doSetProperty(this.getWcModelDirectory(), propertyValueProvider, false, SVNDepth.INFINITY, handler, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkoutWC(IModelioProgress aProgress) throws CmsDriverException {
        String taskName = ProjectSvn.I18N.getMessage("Monitor.CheckoutWC", new Object[]{this.workingCopyPath, this.repositoryURL.toString()});
        SubProgress progress = SubProgress.convert((IModelioProgress)aProgress, (String)taskName, (int)50);
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                try {
                    this.svnClient.setEventHandler((ISVNEventHandler)new CheckoutWcSvnEventHandler(progress));
                    SVNUpdateClient updateClient = this.svnClient.getUpdateClient();
                    updateClient.setIgnoreExternals(false);
                    updateClient.doCheckout(this.repositoryURL, this.workingCopyPath, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true);
                }
                catch (SVNAuthenticationCancelledException e) {
                    throw this.toCmsAuthenticationException(e);
                }
                catch (SVNAuthenticationException e) {
                    throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
                }
                catch (SVNException e) {
                    throw new SvnDriverException(ProjectSvn.I18N.getMessage("error.CheckoutFailed", new Object[]{this.repositoryURL, e.getErrorMessage().toString()}), e);
                }
            }
            finally {
                this.svnClient.setEventHandler(null);
                this.invalidateCaches();
            }
        }
    }

    private File[] computeFilesToUpdateArray(Collection<File> additionalUpdates) {
        File[] toUpdate = new File[additionalUpdates.size() + 1];
        additionalUpdates.toArray(toUpdate);
        toUpdate[toUpdate.length - 1] = this.workingCopyPath;
        return toUpdate;
    }

    private static void createDirectories(File dir) throws CmsDriverException {
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            String msg = ProjectSvn.I18N.getMessage("SvnDriver.createDir.failed", new Object[]{dir.getPath(), FileUtils.getLocalizedMessage((IOException)e)});
            throw new SvnDriverException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopy(String destUrl, String message) throws CmsDriverException {
        SVNCopySource[] sources = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.HEAD, this.workingCopyPath)};
        try {
            SVNURL dst = "file".equals(this.repositoryURL.getProtocol()) && !destUrl.startsWith("file:/") ? SVNURL.fromFile((File)new File(destUrl)) : SVNURL.parseURIEncoded((String)destUrl);
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                this.svnClient.getCopyClient().doCopy(sources, dst, false, false, true, message, null);
            }
        }
        catch (SVNAuthenticationCancelledException e) {
            throw this.toCmsAuthenticationException(e);
        }
        catch (SVNAuthenticationException e) {
            throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getSidedPath(File normalPath, ConflictSide side) throws UnsupportedOperationException, IOException {
        try {
            SVNInfo info;
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                info = this.svnClient.getWCClient().doInfo(normalPath, SVNRevision.WORKING);
            }
            File ret = switch (side) {
                case ConflictSide.BASE -> info.getConflictOldFile();
                case ConflictSide.MINE -> info.getConflictWrkFile();
                case ConflictSide.THEIRS -> info.getConflictNewFile();
                default -> throw new UnsupportedOperationException();
            };
            if (ret == null) {
                return normalPath;
            }
            return ret;
        }
        catch (SVNException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    private File getWcAdminDirectory() {
        return new File(this.workingCopyPath, "admin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWcFormat() throws SVNException {
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            SvnOperationFactory operationsFactory = this.svnClient.getWCClient().getOperationsFactory();
            SvnGetStatus getStatus = operationsFactory.createGetStatus();
            getStatus.setSingleTarget(SvnTarget.fromFile((File)this.workingCopyPath));
            getStatus.setReportAll(true);
            getStatus.setDepth(SVNDepth.EMPTY);
            SvnStatus status = (SvnStatus)getStatus.run();
            if (status != null) {
                int workingCopyFormat = status.getWorkingCopyFormat();
                return workingCopyFormat;
            }
            return -1;
        }
    }

    private File getWcModelDirectory() {
        return this.filesGeometry.getModelDirectory();
    }

    private AuthDatasAuthManager initAuth(Collection<IAuthData> authDatas, AuthDatasAuthManager sharedAuthManager) throws CmsAuthenticationException {
        AuthDatasAuthManager newAuthManager = sharedAuthManager;
        if (newAuthManager == null) {
            newAuthManager = new AuthDatasAuthManager();
        }
        if (authDatas.isEmpty()) {
            return newAuthManager;
        }
        for (IAuthData a : authDatas) {
            String uname;
            newAuthManager.addAuth(this.repositoryURL, a);
            if (this.user != null && !this.user.isEmpty() || (uname = SvnDriver.findUserName(a)) == null || uname.isEmpty()) continue;
            this.user = uname;
        }
        if (this.user == null || this.user.isEmpty()) {
            this.user = System.getProperty("user.name");
        }
        return newAuthManager;
    }

    private void invalidateCaches() {
        if (this.statusDriver != null) {
            this.statusDriver.invalidateCaches();
        }
    }

    private void repairConflictedFiles(ICmsUpdateResult result) {
        for (MRef ref : result.getConflictedElements()) {
            File orig = null;
            File f = this.getFilesGeometry().getExmlFile(ref);
            try {
                orig = this.getSidedPath(f, ConflictSide.MINE);
                Files.copy(orig.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (NoSuchFileException e) {
                if (orig == null || e.getFile().equals(orig.toString())) {
                    Log.warning((String)"No .mine file for '%s': %s", (Object[])new Object[]{f, FileUtils.getLocalizedMessage((IOException)e)});
                    continue;
                }
                Log.warning((String)"Failed copying '%s' to '%s' : %s", (Object[])new Object[]{orig, f, FileUtils.getLocalizedMessage((IOException)e)});
                Log.trace((Throwable)e);
            }
            catch (IOException e) {
                Log.warning((String)"Failed copying '%s' to '%s' : %s", (Object[])new Object[]{orig, f, FileUtils.getLocalizedMessage((IOException)e)});
                Log.trace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, Collection<File>> groupByWorkingCopy(Collection<File> files) throws SvnDriverException {
        HashMap<File, Collection<File>> ret = new HashMap<File, Collection<File>>();
        SvnGetInfo cmd = this.svnClient.getWCClient().getOperationsFactory().createGetInfo();
        cmd.setDepth(SVNDepth.EMPTY);
        cmd.setSleepForTimestamp(false);
        for (File f : files) {
            File wcRoot = null;
            cmd.setSingleTarget(SvnTarget.fromFile((File)f));
            try {
                SVNClientManager sVNClientManager = this.svnClient;
                synchronized (sVNClientManager) {
                    SvnInfo info = (SvnInfo)cmd.run();
                    wcRoot = info.getWcInfo().getWcRoot();
                }
                Collection l = ret.computeIfAbsent(wcRoot, k -> new ArrayList());
                l.add(f);
            }
            catch (SVNException e) {
                SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
                if (errorCode == SVNErrorCode.WC_NOT_WORKING_COPY || errorCode == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw new SvnDriverException(e);
            }
        }
        return ret;
    }

    private static File[] toArray(Collection<File> files) {
        return files.toArray(new File[files.size()]);
    }

    private static File[] toArray(Collection<File> filesToUnlock, File other) {
        int collSize = filesToUnlock.size();
        File[] array = filesToUnlock.toArray(new File[collSize + 1]);
        array[collSize] = other;
        return array;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean upgradeWorkingCopy(IModelioProgress monitor) throws CmsDriverException {
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            SvnOperationFactory operationsFactory = this.svnClient.getWCClient().getOperationsFactory();
            try {
                int wcFormat = this.getWcFormat();
                ProjectSvn.LOG.info(ProjectSvn.I18N.getMessage("SvnDriver.upgradeWorkingCopy.diagnostic", new Object[]{ProjectSvn.I18N.getMessage("$WC_FORMAT." + wcFormat, new Object[0]), wcFormat, ProjectSvn.I18N.getMessage("$WC_FORMAT.31", new Object[0]), 31}));
                if (wcFormat == 31) return false;
                String taskLabel = ProjectSvn.I18N.getMessage("Monitor.UpgradingWC.task", new Object[]{ProjectSvn.I18N.getMessage("$WC_FORMAT." + wcFormat, new Object[0]), ProjectSvn.I18N.getMessage("$WC_FORMAT.31", new Object[0])});
                ProjectSvn.LOG.warning(taskLabel);
                final SubProgress m = SubProgress.convert((IModelioProgress)monitor, (String)taskLabel, (int)50);
                m.subTask(ProjectSvn.I18N.getString("Monitor.Cleanup"));
                this.cleanUpWorkingCopy((IModelioProgress)m.newChild(10));
                m.subTask(ProjectSvn.I18N.getMessage("Monitor.UpgradingWC.subtask", new Object[0]));
                ISVNEventHandler eventHandler = new ISVNEventHandler(){
                    private int i = 0;

                    public void checkCancelled() {
                    }

                    public void handleEvent(SVNEvent event, double progress) {
                        if (event.getAction() == SVNEventAction.UPGRADED_PATH) {
                            m.subTask(ProjectSvn.I18N.getMessage("Monitor.UpgradingWC.DirUpgraded", new Object[]{event.getFile().getName()}));
                            m.worked(1);
                            ++this.i;
                            if (this.i > 20) {
                                m.setWorkRemaining(5);
                            }
                        } else {
                            m.subTask(" " + String.valueOf(event.getFile()) + ":" + String.valueOf(event.getAction()));
                        }
                    }
                };
                operationsFactory.setEventHandler(eventHandler);
                SvnUpgrade upgradeOp = operationsFactory.createUpgrade();
                upgradeOp.addTarget(SvnTarget.fromFile((File)SvnOperationFactory.getWorkingCopyRoot((File)this.workingCopyPath, (boolean)false)));
                upgradeOp.run();
                m.done();
                ProjectSvn.LOG.warning(ProjectSvn.I18N.getMessage("Monitor.UpgradingWC.done", new Object[0]));
                return true;
            }
            catch (SVNException e) {
                throw new SvnDriverException(e);
            }
            finally {
                operationsFactory.setEventHandler(null);
                this.invalidateCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFileContent(File p, OutputStream dst, String revision) throws CmsDriverException {
        try {
            SVNRevision rev = SVNRevision.parse((String)revision);
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                this.svnClient.getWCClient().doGetFileContents(p, rev, rev, false, dst);
            }
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    @Override
    public void copyFile(File oldPath, File newPath, boolean doFsOperation) throws CmsDriverException {
        this.copyMoveFile(oldPath, newPath, false, doFsOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyMoveFile(File oldPath, File newPath, boolean isMove, boolean doFsOperation) throws SvnDriverException {
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                SvnCopy cp = this.svnClient.getCopyClient().getOperationsFactory().createCopy();
                cp.setSingleTarget(SvnTarget.fromFile((File)newPath));
                cp.setMove(isMove);
                cp.setFailWhenDstExists(true);
                cp.setMakeParents(true);
                cp.setIgnoreExternals(false);
                cp.setAllowMixedRevisions(false);
                cp.setMetadataOnly(!doFsOperation);
                cp.addCopySource(SvnCopySource.create((SvnTarget)SvnTarget.fromFile((File)oldPath), (SVNRevision)SVNRevision.WORKING));
                cp.run();
            }
            this.statusDriver.invalidateCache(oldPath);
            this.statusDriver.invalidateCache(newPath);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    @Override
    public void exportDiffRepository(IModelioProgress monitor, Path extractTargetPath, String url, String revision) throws CmsDriverException, InterruptedException {
        DiffRepositoryBuilder br = new DiffRepositoryBuilder(this.svnClient, this.workingCopyPath, this.getFilesGeometry());
        SVNURL srcUrl = url == null ? this.repositoryURL : SvnDriver.convertRepositoryPath(url);
        br.exportDiffRepository(monitor, extractTargetPath, srcUrl, revision);
    }

    private static boolean staticInit() {
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            this.svnClient.dispose();
        }
        if (this.statusDriver != null) {
            this.statusDriver.dispose();
            this.statusDriver = null;
        }
        this.structureSnapshot = null;
    }

    public void addToIgnore(File path, String toIgnore) throws SvnDriverException {
        this.addToProp(path, "svn:ignore", toIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToProp(File path, String key, String value) throws SvnDriverException {
        ISvnPropertyValueProvider propertyValueProvider = (apath, properties) -> {
            SVNProperties ret = new SVNProperties(properties);
            String old = properties.getStringValue(key);
            ret.put(key, (String)(old != null ? old + "\n" + value : value));
            return ret;
        };
        SVNClientManager sVNClientManager = this.svnClient;
        synchronized (sVNClientManager) {
            try {
                SvnSetProperty ps = this.svnClient.getWCClient().getOperationsFactory().createSetProperty();
                ps.setPropertyValueProvider(propertyValueProvider);
                ps.setForce(false);
                ps.setDepth(SVNDepth.EMPTY);
                ps.setSingleTarget(SvnTarget.fromFile((File)path));
                ps.run();
            }
            catch (SVNException e) {
                throw new SvnDriverException(e);
            }
        }
    }

    private SVNRepository getSvnRepositoryConnection() throws CmsAuthenticationException, SvnDriverException {
        SVNRepository repo;
        try {
            repo = this.svnClient.getRepositoryPool().createRepository(this.repositoryURL, false);
        }
        catch (SVNAuthenticationCancelledException e) {
            throw this.toCmsAuthenticationException(e);
        }
        catch (SVNAuthenticationException e) {
            throw new CmsAuthenticationException(e.getLocalizedMessage(), e);
        }
        catch (SVNException e2) {
            throw new SvnDriverException(e2);
        }
        return repo;
    }

    private CmsAuthenticationException toCmsAuthenticationException(SVNAuthenticationCancelledException e) {
        Throwable realError = e;
        if (e.getLastAuthenticationError() != null) {
            realError = e.getLastAuthenticationError().getCause();
        }
        if (realError == null) {
            realError = e;
        }
        return new CmsAuthenticationException(realError.getLocalizedMessage(), realError);
    }

    private static String findUserName(IAuthData authData) {
        if (authData instanceof UserPasswordAuthData) {
            UserPasswordAuthData userPassData = (UserPasswordAuthData)authData;
            return userPassData.getUser();
        }
        if (authData instanceof OidcAuthData) {
            OidcAuthData oidcData = (OidcAuthData)authData;
            return oidcData.getUserId();
        }
        if (authData instanceof SshAuthData) {
            SshAuthData sshAuthData = (SshAuthData)authData;
            return sshAuthData.getSvnUserName();
        }
        return null;
    }

    private static class CancelDeleteRestorer
    implements Closeable {
        private final Collection<Path> backed;

        public CancelDeleteRestorer(Collection<Path> backed) {
            this.backed = backed;
        }

        @Override
        public void close() throws IOException {
            IOException ex = null;
            for (Path src : this.backed) {
                Path target = src.resolveSibling(src.getFileName().toString() + ".bak");
                try {
                    Files.move(target, src, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    ex = MultipleIOException.accumulate(ex, e, null);
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    private static final class CheckoutWcSvnEventHandler
    implements ISVNEventHandler {
        private int nbUpdate;
        private int nbCreate;
        private int nbDelete;
        private String oldLabel;
        private final SubProgress progress;

        CheckoutWcSvnEventHandler(SubProgress progress) {
            this.progress = Objects.requireNonNull(progress);
        }

        public void checkCancelled() throws SVNCancelException {
            if (this.progress.isCanceled()) {
                throw new SVNCancelException();
            }
        }

        public void handleEvent(SVNEvent ev, double unused) {
            SVNEventAction action = ev.getAction();
            if (action == SVNEventAction.UPDATE_ADD) {
                ++this.nbCreate;
            } else if (action == SVNEventAction.UPDATE_COMPLETED) {
                this.progress.done();
            } else if (action == SVNEventAction.UPDATE_DELETE) {
                ++this.nbDelete;
            } else if (action != SVNEventAction.UPDATE_EXISTS && action != SVNEventAction.UPDATE_EXTERNAL && action != SVNEventAction.UPDATE_NONE && action != SVNEventAction.UPDATE_REPLACE && action == SVNEventAction.UPDATE_UPDATE) {
                ++this.nbUpdate;
            }
            String newLabel = ProjectSvn.I18N.getMessage("SvnDriver.UpdateMonitor", new Object[]{this.nbCreate, this.nbUpdate, this.nbDelete});
            if (!newLabel.equals(this.oldLabel)) {
                this.progress.subTask(newLabel);
                this.oldLabel = newLabel;
            }
            if (action != SVNEventAction.UPDATE_COMPLETED) {
                this.progress.worked(10);
                this.progress.setWorkRemaining(50);
            }
        }
    }

    private final class NewFilesSvnPropertyProvider
    implements ISVNPropertyValueProvider {
        NewFilesSvnPropertyProvider(boolean enforceLocks) {
        }

        public SVNProperties providePropertyValues(File path, SVNProperties properties) throws SVNException {
            if (!path.isDirectory()) {
                if (SvnDriver.this.getFilesGeometry().isModelFile(path)) {
                    properties.put("svn:mime-type", "application/xml");
                } else {
                    properties.put("svn:mime-type", "application/octet-stream");
                }
            }
            return properties;
        }
    }

    private static class ProgressMonitorEventHandler
    implements ISVNEventHandler {
        private IModelioProgress monitor;
        private Collection<SVNEventAction> accepted;

        public ProgressMonitorEventHandler(IModelioProgress monitor, int monSize, SVNEventAction ... accepted) {
            this.monitor = SubProgress.convert((IModelioProgress)monitor, (int)monSize);
            this.accepted = accepted != null ? Arrays.asList(accepted) : null;
        }

        public void checkCancelled() throws SVNCancelException {
            if (this.monitor.isCanceled()) {
                throw new SVNCancelException();
            }
        }

        public void handleEvent(SVNEvent event, double progress) throws SVNException {
            if (this.accepted == null || this.accepted.contains(event.getAction())) {
                this.monitor.worked(1);
            }
        }
    }
}

