/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.cms.driver.ICmsResultFileEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.modelio.vcore.smkernel.mapi.MRef;

class SvnLockResult
implements ICmsLockResult {
    private List<MRef> locked = new ArrayList<MRef>();
    private Collection<IRefResultEntry> failures = new ArrayList<IRefResultEntry>();
    private Collection<File> lockedFiles = new ArrayList<File>();
    private Collection<ICmsResultFileEntry> fileFailures = new ArrayList<ICmsResultFileEntry>();
    private List<MRef> alreadyLocked = new ArrayList<MRef>();
    private Collection<File> alreadyLockedFiles = new ArrayList<File>();
    private List<MRef> outdated = new ArrayList<MRef>();
    private Collection<File> outdatedFiles = new ArrayList<File>();

    SvnLockResult() {
    }

    @Override
    public Collection<MRef> getAlreadyLockedElements() {
        return this.alreadyLocked;
    }

    @Override
    public Collection<File> getAlreadyLockedFiles() {
        return this.alreadyLockedFiles;
    }

    @Override
    public Collection<ICmsResultFileEntry> getFileLockFailures() {
        return this.fileFailures;
    }

    @Override
    public Collection<IRefResultEntry> getLockFailures() {
        return this.failures;
    }

    @Override
    public Collection<MRef> getLockedElements() {
        return this.locked;
    }

    @Override
    public Collection<File> getLockedFiles() {
        return this.lockedFiles;
    }

    void addAlreadyLockedElement(MRef ref) {
        this.alreadyLocked.add(ref);
    }

    void addAlreadyLockedFile(File file) {
        this.alreadyLockedFiles.add(file);
    }

    void addError(MRef ref, String errorMessage) {
        this.failures.add(new ObRefEntry(ref, errorMessage));
    }

    void addError(File file, String errorMessage) {
        this.fileFailures.add(new FileEntry(file, errorMessage));
    }

    void addLockedElement(MRef ref) {
        this.locked.add(ref);
    }

    void addLockedFile(File file) {
        this.lockedFiles.add(file);
    }

    @Override
    public Collection<MRef> getOutdatedElements() {
        return this.outdated;
    }

    public void addOutdatedElement(MRef ref) {
        this.outdated.add(ref);
    }

    @Override
    public Collection<File> getOutdatedFiles() {
        return this.outdatedFiles;
    }

    public void addOutdatedFile(File file) {
        this.outdatedFiles.add(file);
    }

    private static class FileEntry
    implements ICmsResultFileEntry {
        private String cause;
        private File file;

        public FileEntry(File ref, String cause) {
            this.file = ref;
            this.cause = cause;
        }

        @Override
        public String getMessage() {
            return this.cause;
        }

        @Override
        public File getFile() {
            return this.file;
        }
    }

    private static class ObRefEntry
    implements IRefResultEntry {
        private String cause;
        private MRef ref;

        public ObRefEntry(MRef ref, String cause) {
            this.ref = ref;
            this.cause = cause;
        }

        public String getMessage() {
            return this.cause;
        }

        public MRef getRef() {
            return this.ref;
        }
    }
}

