/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsLog;
import com.modeliosoft.modelio.cms.driver.ICmsLogEntry;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.LogEntryHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnDriverException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.blob.IBlobChangeEvent;
import org.modelio.vcore.session.api.blob.IBlobInfo;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

class SvnLog
implements ICmsLog {
    private int nextIndex = 0;
    private SVNRevision nextRevisionStart;
    private final SVNRevision revisionStart;
    private final org.tmatesoft.svn.core.wc2.SvnLog log;
    private final Object sync;
    private final List<ICmsLogEntry> entries = new ArrayList<ICmsLogEntry>(200);
    private final LogEntryHandler handler;
    private final ExmlFileAccess geom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnLog(File[] filesToLog, SVNClientManager svnClient, ExmlFileAccess geom, IModelioProgress monitor) {
        this.handler = new LogEntryHandler(monitor, this);
        this.nextRevisionStart = this.revisionStart = SVNRevision.HEAD;
        this.geom = geom;
        Object object = this.sync = svnClient;
        synchronized (object) {
            this.log = svnClient.getLogClient().getOperationsFactory().createLog();
            this.log.setStopOnCopy(false);
            File[] fileArray = filesToLog;
            int n = filesToLog.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.log.addTarget(SvnTarget.fromFile((File)file));
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnLog(File[] filesToLog, SVNRevision fromRevision, SVNClientManager svnClient, ExmlFileAccess geom, IModelioProgress monitor) {
        this.handler = new LogEntryHandler(monitor, this);
        this.nextRevisionStart = this.revisionStart = fromRevision;
        this.geom = geom;
        Object object = this.sync = svnClient;
        synchronized (object) {
            this.log = svnClient.getLogClient().getOperationsFactory().createLog();
            this.log.setStopOnCopy(false);
            File[] fileArray = filesToLog;
            int n = filesToLog.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.log.addTarget(SvnTarget.fromFile((File)file));
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnLog(SVNURL branchUrl, SVNRevision fromRevision, boolean stopOnBranchStart, String[] filesToLog, SVNClientManager svnClient, ExmlFileAccess geom, IModelioProgress monitor) {
        this.handler = new LogEntryHandler(monitor, this);
        this.nextRevisionStart = this.revisionStart = fromRevision;
        this.geom = geom;
        Object object = this.sync = svnClient;
        synchronized (object) {
            this.log = svnClient.getLogClient().getOperationsFactory().createLog();
            this.log.addTarget(SvnTarget.fromURL((SVNURL)branchUrl, (SVNRevision)this.revisionStart));
            this.log.setStopOnCopy(stopOnBranchStart);
            if (filesToLog != null) {
                this.log.setTargetPaths(filesToLog);
            }
        }
    }

    @Override
    public boolean hasNext() throws CmsDriverException {
        if (this.nextIndex == -1) {
            return false;
        }
        if (this.nextIndex == this.entries.size()) {
            if (this.readNextEntries()) {
                return true;
            }
            this.nextIndex = -1;
            return false;
        }
        return true;
    }

    @Override
    public ICmsLogEntry next() throws CmsDriverException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more log entry");
        }
        ICmsLogEntry ret = this.entries.get(this.nextIndex);
        ++this.nextIndex;
        return ret;
    }

    void addEntry(SVNLogEntry logEntry) {
        this.entries.add(new Entry(logEntry, this.geom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readNextEntries() throws CmsDriverException {
        try {
            String[] revisionProperties = null;
            this.handler.begin();
            this.log.setRevisionRanges(null);
            this.log.addRange(SvnRevisionRange.create((SVNRevision)this.nextRevisionStart, (SVNRevision)SVNRevision.create((long)0L)));
            this.log.setDiscoverChangedPaths(true);
            this.log.setUseMergeHistory(false);
            this.log.setLimit(50L);
            this.log.setRevisionProperties(revisionProperties);
            this.log.setReceiver(SvnCodec.logReceiver((ISVNLogEntryHandler)this.handler));
            Object object = this.sync;
            synchronized (object) {
                this.log.run();
            }
            if (this.handler.hasReadSomething()) {
                this.nextRevisionStart = SVNRevision.create((long)(this.handler.getLastReadRevision() - 1L));
                return true;
            }
            return false;
        }
        catch (SVNException e) {
            SVNErrorCode code = e.getErrorMessage().getErrorCode();
            if (code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.WC_PATH_NOT_FOUND || code == SVNErrorCode.CLIENT_BAD_REVISION) {
                return false;
            }
            throw new SvnDriverException(e);
        }
    }

    private static <T> T ifNull(T val, T defaultVal) {
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    private static class Entry
    implements ICmsLogEntry,
    IBlobChangeEvent {
        private final SVNLogEntry logEntry;
        private Collection<File> createdFiles = null;
        private Collection<File> modifiedFiles = null;
        private Collection<File> deletedFiles = null;
        private List<MRef> created = null;
        private List<MRef> updated = null;
        private List<MRef> deleted = null;
        private final ExmlFileAccess geom;
        final Collection<IBlobInfo> createdBlobs = new ArrayList<IBlobInfo>();
        final Collection<IBlobInfo> modifiedBlobs = new ArrayList<IBlobInfo>();
        final Collection<IBlobInfo> deletedBlobs = new ArrayList<IBlobInfo>();

        public Entry(SVNLogEntry logEntry, ExmlFileAccess geom) {
            this.logEntry = logEntry;
            this.geom = geom;
            this.initChanged();
        }

        private void initChanged() {
            if (this.created == null) {
                this.created = new ArrayList<MRef>();
                this.updated = new ArrayList<MRef>();
                this.deleted = new ArrayList<MRef>();
                this.createdFiles = new ArrayList<File>();
                this.modifiedFiles = new ArrayList<File>();
                this.deletedFiles = new ArrayList<File>();
                Map map = this.logEntry.getChangedPaths();
                for (Map.Entry it : map.entrySet()) {
                    File file = new File((String)it.getKey());
                    SVNLogEntryPath v = (SVNLogEntryPath)it.getValue();
                    if (this.geom.isModelFile(file)) {
                        MRef ref = this.geom.getObRef(file);
                        switch (v.getType()) {
                            case 'A': {
                                this.created.add(ref);
                                break;
                            }
                            case 'D': {
                                this.deleted.add(ref);
                                break;
                            }
                            case 'M': 
                            case 'R': {
                                this.updated.add(ref);
                                break;
                            }
                        }
                        continue;
                    }
                    switch (v.getType()) {
                        case 'A': {
                            this.createdFiles.add(file);
                            break;
                        }
                        case 'D': {
                            this.deletedFiles.add(file);
                            break;
                        }
                        case 'M': 
                        case 'R': {
                            this.modifiedFiles.add(file);
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public String getAuthor() {
            return SvnLog.ifNull(this.logEntry.getAuthor(), "<none>");
        }

        @Override
        public Date getDate() {
            return SvnLog.ifNull(this.logEntry.getDate(), new Date(0L));
        }

        @Override
        public String getMessage() {
            return SvnLog.ifNull(this.logEntry.getMessage(), "<none>");
        }

        @Override
        public String getRevision() {
            return Long.toString(this.logEntry.getRevision());
        }

        @Override
        public Collection<MRef> getModifiedElements() {
            this.initChanged();
            return this.updated;
        }

        @Override
        public Collection<MRef> getCreatedElements() {
            this.initChanged();
            return this.created;
        }

        @Override
        public Collection<MRef> getDeletedElements() {
            this.initChanged();
            return this.deleted;
        }

        @Override
        public IBlobChangeEvent getBlobChanges() {
            return this;
        }

        public Collection<IBlobInfo> getCreatedBlobs() {
            return this.createdBlobs;
        }

        public Collection<IBlobInfo> getDeletedBlobs() {
            return this.deletedBlobs;
        }

        public Collection<IBlobInfo> getUpdatedBlobs() {
            return this.modifiedBlobs;
        }

        @Override
        public Collection<File> getCreatedFiles() {
            return this.createdFiles;
        }

        @Override
        public Collection<File> getDeletedFiles() {
            return this.deletedFiles;
        }

        @Override
        public Collection<File> getModifiedFiles() {
            return this.modifiedFiles;
        }
    }
}

