/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.ICmsLock;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnLock;
import java.io.File;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

class SvnStatus
implements ICmsStatus {
    private final String user;
    private final boolean needsLock;
    public final SVNStatus status;

    @Deprecated
    private SvnStatus(File f, SVNStatus status, String user) {
        this(f, status, user, !f.canWrite());
    }

    public SvnStatus(File f, SVNStatus status, String user, boolean useLocks) {
        assert (user != null);
        this.needsLock = SvnStatus.isLockNeeded(f, status, useLocks);
        this.status = status;
        this.user = user;
    }

    @Override
    public long getLastRevision() {
        if (!this.isVersioned()) {
            return -1L;
        }
        return this.status.getCommittedRevision().getNumber();
    }

    @Override
    public ICmsLock getLock() {
        if (!this.isVersioned()) {
            return null;
        }
        SVNLock localLock = this.status.getLocalLock();
        if (localLock != null) {
            return new SvnLock(localLock, true, localLock.getOwner().equals(this.user));
        }
        SVNLock remoteLock = this.status.getRemoteLock();
        if (remoteLock != null) {
            return new SvnLock(remoteLock, false, false);
        }
        return null;
    }

    @Override
    public long getRevision() {
        if (!this.isVersioned()) {
            return -1L;
        }
        return this.status.getRevision().getNumber();
    }

    @Override
    public boolean isSelfLocked() {
        if (!this.isVersioned()) {
            return false;
        }
        SVNLock l = this.status.getLocalLock();
        return l != null && l.getOwner().equals(this.user);
    }

    @Override
    public boolean isModified() {
        if (!this.isVersioned()) {
            return false;
        }
        return this.status.getContentsStatus() == SVNStatusType.STATUS_MODIFIED;
    }

    @Override
    public boolean isVersioned() {
        return this.status != null && this.status.isVersioned() && !this.isToAdd();
    }

    @Override
    public boolean needsUpdate() {
        if (!this.isVersioned()) {
            return false;
        }
        return this.status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE;
    }

    @Override
    public boolean isToAdd() {
        return this.status != null && this.status.getNodeStatus() == SVNStatusType.STATUS_ADDED;
    }

    @Override
    public boolean isConflicted() {
        if (!this.isVersioned()) {
            return false;
        }
        SVNStatusType contentsStatus = this.status.getContentsStatus();
        return contentsStatus == SVNStatusType.STATUS_CONFLICTED;
    }

    private static boolean isLockNeeded(File f, SVNStatus status, boolean useLocks) {
        if (f == null || status == null) {
            return false;
        }
        if (status.getRemoteLock() != null) {
            return true;
        }
        return status.getKind() == SVNNodeKind.FILE && useLocks;
    }

    @Override
    public boolean isLockingNeeded() {
        return this.needsLock;
    }

    @Override
    public boolean isToDelete() {
        return this.status != null && this.status.getNodeStatus() == SVNStatusType.STATUS_DELETED;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SvnStatus(");
        if (this.isVersioned()) {
            stringBuilder.append("versioned");
        }
        if (this.isToAdd()) {
            stringBuilder.append(", to add");
        }
        if (this.isToDelete()) {
            stringBuilder.append(", to delete");
        }
        if (this.isModified()) {
            stringBuilder.append(", modified");
        }
        if (this.isSelfLocked()) {
            stringBuilder.append(", self locked");
        }
        if (this.getLock() != null) {
            stringBuilder.append(", locked by ");
            stringBuilder.append(this.getLock().getOwner());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

