/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.StatusHandler;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.StatusSnapshot;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnDriverException;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnStatus;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.modelio.vbasic.debug.ThreadDumper;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

class SvnStatusDriver
implements ICmsStatusDriver {
    private String user;
    private boolean enforceLocks;
    private final boolean isRemote;
    private SVNClientManager svnClient;
    private StatusSnapshot statusSnapShot;
    private final Object cachesLock = new Object();
    private volatile BackgroundProcess backgroundProcess;
    private final Object backgroundLock = new Object();
    private AggregatedSvnStatusRequest requestedStatuses;
    private final Object requestedStatusesLock = new Object();
    private ExmlFileAccess geometry;
    private final ExecutorService asyncSvnClientExecutor;
    private final ExecutorService asyncExecutor;

    private static ThreadFactory createThreadFactory(String prefix) {
        AtomicLong asyncThreadCount = new AtomicLong();
        return r -> {
            Thread t = new Thread(r, prefix + asyncThreadCount.addAndGet(1L));
            t.setDaemon(true);
            return t;
        };
    }

    @Override
    public void dispose() {
        this.asyncExecutor.shutdownNow();
        this.asyncSvnClientExecutor.shutdownNow();
    }

    public SvnStatusDriver(SVNClientManager svnClient, ExmlFileAccess geometry, String user, boolean enforceLocks, boolean remote) {
        Objects.requireNonNull(svnClient);
        Objects.requireNonNull(geometry);
        Objects.requireNonNull(user);
        this.svnClient = svnClient;
        this.geometry = geometry;
        this.user = user;
        this.enforceLocks = enforceLocks;
        this.isRemote = remote;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), SvnStatusDriver.createThreadFactory("SvnStatusDriver-async-"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.asyncExecutor = threadPoolExecutor;
        threadPoolExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10), SvnStatusDriver.createThreadFactory("SvnStatusDriver-svnclient-"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.asyncSvnClientExecutor = threadPoolExecutor;
    }

    @Override
    public CompletableFuture<ICmsStatus> asyncGetStatus(File f, boolean askServer) {
        return this.asyncGetStatusBatch(Set.of(f), askServer).thenApply(snap -> snap.get(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<IStatusSnapshot> asyncGetStatusBatch(Collection<File> files, boolean askServer) {
        assert (askServer == this.isRemote);
        StatusSnapshot existingSnapshot = this.getCachedStatusSnapShot(false);
        if (existingSnapshot != null && existingSnapshot.getAllFiles().keySet().containsAll(files)) {
            return CompletableFuture.completedFuture(existingSnapshot);
        }
        Object object = this.requestedStatusesLock;
        synchronized (object) {
            if (this.requestedStatuses == null) {
                AggregatedSvnStatusRequest newRequest = new AggregatedSvnStatusRequest();
                newRequest.addAll(files);
                this.asyncExecutor.submit(() -> this.executeBatchStatusRequest(newRequest));
                this.requestedStatuses = newRequest;
            } else {
                this.requestedStatuses.addAll(files);
            }
            return this.requestedStatuses.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchStatusRequest(AggregatedSvnStatusRequest newRequest) {
        try {
            Object object = this.requestedStatusesLock;
            synchronized (object) {
                AggregatedSvnStatusRequest curBatch = this.requestedStatuses;
                if (curBatch != newRequest) {
                    throw new IllegalStateException(String.format("expected %s != current %s", newRequest, curBatch));
                }
                this.requestedStatuses = null;
            }
            StatusSnapshot ret = new StatusSnapshot();
            if (newRequest.stats.started().isTooLong()) {
                ProjectSvn.LOG.info(String.valueOf(newRequest) + " waited longer than expected");
            }
            for (File file : newRequest.requestedStatuses) {
                ret.add(file, null, this.getStatus(file, this.isRemote));
            }
            if (newRequest.stats.ended().isTooLong()) {
                ProjectSvn.LOG.info(String.valueOf(newRequest) + " runned longer than expected");
            }
            newRequest.result.complete(ret);
        }
        catch (Exception e) {
            Log.trace((Throwable)e);
            newRequest.stats.ended();
            newRequest.result.completeExceptionally(e);
        }
        catch (Error e) {
            Log.error((Throwable)e);
            newRequest.stats.ended();
            newRequest.result.completeExceptionally(e);
            throw e;
        }
    }

    @Override
    public ICmsStatus getStatus(File file, boolean askServer) throws CmsDriverException {
        assert (askServer == this.isRemote);
        StatusSnapshot cachedSnapShot = this.getCachedStatusSnapShot(true);
        ICmsStatus ret = cachedSnapShot.get(file);
        if (ret != null) {
            return ret;
        }
        ret = this.doGetStatus(file, askServer);
        if (this.geometry.isModelFile(file)) {
            cachedSnapShot.add(file, this.geometry.getObRef(file), ret);
        } else {
            cachedSnapShot.add(file, null, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatusSnapshot getStatusSnapShot(IModelioProgress aMonitor, boolean remote) throws CmsDriverException {
        assert (remote == this.isRemote);
        try {
            StatusSnapshot newSnap = new StatusSnapshot();
            this.doGetStatusSnapShot(aMonitor, newSnap, true);
            Object object = this.backgroundLock;
            synchronized (object) {
                Object object2 = this.cachesLock;
                synchronized (object2) {
                    this.statusSnapShot = newSnap;
                }
            }
            return newSnap;
        }
        catch (InterruptedException e) {
            throw new SvnDriverException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCaches() {
        Object object = this.backgroundLock;
        synchronized (object) {
            if (this.backgroundProcess != null) {
                this.backgroundProcess.cancel();
            }
            Object object2 = this.cachesLock;
            synchronized (object2) {
                this.statusSnapShot = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICmsStatus doGetStatus(File path, boolean askServer) throws CmsDriverException {
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                Future<ICmsStatus> future = this.asyncSvnClientExecutor.submit(() -> {
                    SVNStatus svnkitStatus = this.svnClient.getStatusClient().doStatus(path, askServer);
                    return new SvnStatus(path, svnkitStatus, this.user, this.enforceLocks);
                });
                return future.get(30L, TimeUnit.SECONDS);
            }
        }
        catch (ExecutionException e) {
            SVNErrorCode errorCode;
            if (e.getCause() instanceof SVNException && ((errorCode = ((SVNException)e.getCause()).getErrorMessage().getErrorCode()) == SVNErrorCode.WC_NOT_WORKING_COPY || errorCode == SVNErrorCode.WC_PATH_NOT_FOUND)) {
                return new SvnStatus(path, null, this.user, this.enforceLocks);
            }
            throw new SvnDriverException(e);
        }
        catch (InterruptedException | RejectedExecutionException | TimeoutException e) {
            ThreadDumper.get().getDeadLocks().addAsSupressed((Throwable)e);
            throw new SvnDriverException(e);
        }
    }

    void doGetStatusSnapShot(IModelioProgress aMonitor, StatusSnapshot snapshot, boolean atOnce) throws CmsDriverException, InterruptedException {
        File reposDir = this.geometry.getModelDirectory();
        if (aMonitor != null && aMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (atOnce) {
            DriverStatusHandler statusHandler = new DriverStatusHandler(snapshot, this.user, this.geometry, aMonitor, this.enforceLocks);
            this.scanDirStatus(reposDir, statusHandler, true);
        } else {
            boolean isformat3 = this.geometry.getGeometry().getModelDirectoryLevels() > 2;
            File[] dirContent = reposDir.listFiles();
            if (dirContent != null) {
                SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (int)dirContent.length);
                DriverStatusHandler statusHandler = new DriverStatusHandler(snapshot, this.user, this.geometry, aMonitor, this.enforceLocks);
                File[] fileArray = dirContent;
                int n = dirContent.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (monitor.isCanceled() || Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    monitor.worked(1);
                    if (f.isDirectory() && !f.getName().startsWith(".") && !f.isHidden()) {
                        if (!isformat3) {
                            this.scanDirStatus(f, statusHandler, true);
                        } else {
                            File[] dirContent2 = f.listFiles();
                            if (dirContent2 != null) {
                                File[] fileArray2 = dirContent2;
                                int n3 = dirContent2.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File f2 = fileArray2[n4];
                                    if (monitor.isCanceled() || Thread.interrupted()) {
                                        throw new InterruptedException();
                                    }
                                    if (f2.isDirectory() && !f2.getName().startsWith(".") && !f2.isHidden()) {
                                        this.scanDirStatus(f2, statusHandler, true);
                                    }
                                    ++n4;
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusSnapshot getCachedStatusSnapShot(boolean launchIfAbsent) {
        StatusSnapshot ret;
        Object object = this.cachesLock;
        synchronized (object) {
            ret = this.statusSnapShot;
        }
        if (ret == null && launchIfAbsent) {
            ret = this.launchBackgroundSnapshot();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusSnapshot launchBackgroundSnapshot() {
        Object object = this.backgroundLock;
        synchronized (object) {
            Object object2 = this.cachesLock;
            synchronized (object2) {
                StatusSnapshot newSnap;
                if (this.statusSnapShot != null) {
                    return this.statusSnapShot;
                }
                this.statusSnapShot = newSnap = new StatusSnapshot();
                if (this.isBackgroundSnapshotEnabled()) {
                    BackgroundProcess oldProcess = this.backgroundProcess;
                    this.backgroundProcess = new BackgroundProcess(this.geometry.getModelDirectory(), this.isRemote, newSnap);
                    if (oldProcess != null) {
                        this.backgroundProcess.progress.delegates.addAll(oldProcess.progress.delegates);
                    }
                    this.backgroundProcess.start();
                }
                return newSnap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<IStatusSnapshot> getBackgroundStatusProgress(IModelioProgress progressListener, boolean remote) {
        assert (remote == this.isRemote);
        Object object = this.backgroundLock;
        synchronized (object) {
            if (this.backgroundProcess != null) {
                this.backgroundProcess.addDelegate(progressListener);
                return this.backgroundProcess.getPromise();
            }
            if (progressListener != null) {
                progressListener.done();
            }
            return CompletableFuture.completedFuture(this.statusSnapShot);
        }
    }

    private boolean isBackgroundSnapshotEnabled() {
        return Boolean.parseBoolean(System.getProperty("modelio.svn.status.background", "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirStatus(File dir, StatusHandler statusHandler, boolean recursive) throws CmsDriverException, InterruptedException {
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                this.svnClient.getStatusClient().doStatus(dir, SVNRevision.HEAD, recursive ? SVNDepth.INFINITY : SVNDepth.FILES, this.isRemote, true, false, false, (ISVNStatusHandler)statusHandler, null);
            }
        }
        catch (SVNCancelException e) {
            throw (InterruptedException)new InterruptedException().initCause(e);
        }
        catch (SVNException e) {
            throw new SvnDriverException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(File file) {
        MRef ref = null;
        if (this.geometry.isModelFile(file)) {
            ref = this.geometry.getObRef(file);
        }
        Object object = this.cachesLock;
        synchronized (object) {
            if (this.statusSnapShot != null) {
                this.statusSnapShot.remove(file, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(Collection<File> files) {
        Object object = this.cachesLock;
        synchronized (object) {
            for (File file : files) {
                this.invalidateCache(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugGetStatusError(File path, boolean askServer) {
        try {
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                SVNStatusType parentStatus;
                SVNStatus parentSvnStatus = this.svnClient.getStatusClient().doStatus(path.getParentFile(), askServer);
                SVNStatusType sVNStatusType = parentStatus = parentSvnStatus != null ? parentSvnStatus.getNodeStatus() : null;
                if (parentStatus != SVNStatusType.STATUS_NORMAL && parentStatus != SVNStatusType.STATUS_MODIFIED) {
                    Log.trace((String)"%s.doGetStatus(): '%s' not versioned, '%s' is: %s.", (Object[])new Object[]{this.getClass().getSimpleName(), path, path.getParent(), parentStatus});
                }
            }
        }
        catch (SVNException e2) {
            Log.warning((String)"%s.doGetStatus(): neither '%s' nor parent '%s' are versioned: %s.", (Object[])new Object[]{this.getClass().getSimpleName(), path, path.getParent(), e2.getMessage()});
        }
    }

    private static class AggregatedSvnStatusRequest {
        final Set<File> requestedStatuses = new HashSet<File>();
        final Stats stats = new Stats();
        final CompletableFuture<IStatusSnapshot> result = new CompletableFuture();

        private AggregatedSvnStatusRequest() {
        }

        public synchronized void addAll(Collection<File> files) {
            this.requestedStatuses.addAll(files);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AggregatedSvnStatusRequest [requestedStatuses=");
            builder.append(this.toString(this.requestedStatuses, 5));
            builder.append(", stats=");
            builder.append(this.stats);
            builder.append(", result=");
            builder.append(!this.result.isDone() ? "not done" : (this.result.isCancelled() ? "cancelled" : (this.result.isCompletedExceptionally() ? "failed" : "done")));
            builder.append("]");
            return builder.toString();
        }

        private String toString(Collection<File> collection, int maxLen) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            int i = 0;
            Iterator<File> iterator = collection.iterator();
            while (iterator.hasNext() && i < maxLen) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(iterator.next().getName());
                ++i;
            }
            if (i >= maxLen) {
                builder.append(", ").append(collection.size() - maxLen).append(" more...");
            }
            builder.append("]");
            return builder.toString();
        }
    }

    private class BackgroundProcess {
        private final boolean isRemote;
        private final StatusSnapshot snapshot;
        private final Thread backgroundProcess;
        private final File reposDir;
        private final StatusProgress progress = new StatusProgress();
        private final CompletableFuture<IStatusSnapshot> promise;

        public BackgroundProcess(File reposDir, boolean isRemote, StatusSnapshot snapshot) {
            this.reposDir = reposDir;
            this.snapshot = snapshot;
            this.isRemote = isRemote;
            this.promise = new CompletableFuture();
            this.backgroundProcess = new Thread(this::backgroundGetSnapshot, "SVN status getter");
            this.backgroundProcess.setUncaughtExceptionHandler((t, e) -> {
                Log.error((Throwable)e);
                this.promise.completeExceptionally(e);
            });
        }

        public void start() {
            this.progress.setCanceled(false);
            this.backgroundProcess.start();
        }

        public void addDelegate(IModelioProgress delegate) {
            this.progress.addDelegate(delegate);
        }

        public void cancel() {
            this.progress.setCanceled(true);
            this.promise.cancel(false);
        }

        void backgroundGetSnapshot() {
            try {
                Thread.sleep(100L);
                if (this.progress.isCanceled()) {
                    this.promise.cancel(false);
                    return;
                }
                long t1 = System.nanoTime();
                Log.trace((String)("Begin background status snapshot on '" + String.valueOf(this.reposDir) + "', remote=" + this.isRemote));
                SvnStatusDriver.this.doGetStatusSnapShot(this.progress, this.snapshot, false);
                long duration = System.nanoTime() - t1;
                if (this.progress.isCanceled()) {
                    Log.trace((String)" Canceled finished background status snapshot on '%s', after %s", (Object[])new Object[]{this.reposDir, Duration.ofNanos(duration)});
                    this.promise.cancel(false);
                    return;
                }
                Log.trace((String)" Ended background status snapshot on '%s'. Duration= %s .", (Object[])new Object[]{this.reposDir, Duration.ofNanos(duration)});
                this.promise.complete(this.snapshot);
                this.progress.done();
            }
            catch (CmsDriverException | RuntimeException e) {
                Log.warning((String)(" Background status snapshot on '" + String.valueOf(this.reposDir) + "' failed: " + ((Throwable)e).toString()));
                this.promise.completeExceptionally((Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                Log.trace((String)(" Canceled background status snapshot on '" + String.valueOf(this.reposDir) + "'. "));
                this.promise.cancel(false);
            }
        }

        public CompletableFuture<IStatusSnapshot> getPromise() {
            return this.promise;
        }
    }

    private static class DriverStatusHandler
    extends StatusHandler {
        private final IModelioProgress progress;

        public DriverStatusHandler(StatusSnapshot snapshot, String userName, ExmlFileAccess geom, IModelioProgress progress, boolean needLocks) {
            super(snapshot, userName, geom, needLocks);
            this.progress = progress;
        }

        @Override
        protected boolean isCancelled() {
            return this.progress != null && this.progress.isCanceled();
        }
    }

    private static class Stats {
        private long waitNanos = -1L;
        private long runNanos = -1L;
        private static final long timeOutNanos = 30000000000L;
        private final Instant initTime = Instant.now();

        public Stats started() {
            Instant now = Instant.now();
            this.waitNanos = Duration.between(this.initTime, now).toNanos();
            return this;
        }

        public Stats ended() {
            Instant now = Instant.now();
            this.runNanos = Duration.between(this.initTime, now).toNanos() - this.waitNanos;
            return this;
        }

        public boolean isTooLong() {
            return this.waitNanos > 30000000000L || this.runNanos > 30000000000L;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Stats [initTime=");
            builder.append(DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofInstant(this.initTime, ZoneId.systemDefault())));
            if (this.waitNanos >= 0L) {
                builder.append(", wait=");
                builder.append(Stats.prettyNanos(this.waitNanos));
            }
            if (this.runNanos >= 0L) {
                builder.append(", run=");
                builder.append(Stats.prettyNanos(this.runNanos));
            }
            builder.append("]");
            return builder.toString();
        }

        private static final String prettyNanos(long nanos) {
            long s;
            long m;
            if (nanos == 0L) {
                return "none";
            }
            StringBuilder buffer = new StringBuilder();
            Duration d = Duration.ofNanos(nanos);
            long p = d.toDaysPart();
            if (p > 0L) {
                buffer.append(p).append(" days ");
            }
            if ((p = (long)d.toHoursPart()) > 0L) {
                buffer.append(p).append(" h ");
            }
            if ((m = (long)d.toMinutesPart()) > 0L) {
                buffer.append(m).append(" m ");
            }
            if ((s = (long)d.toSecondsPart()) > 0L) {
                buffer.append(s).append(" s ");
            }
            if (m < 1L) {
                p = d.toMillisPart();
                if (p > 0L) {
                    buffer.append(p).append(" millis ");
                } else if (s < 3L && (p = (long)d.toNanosPart()) > 0L) {
                    buffer.append(p).append(" nanos ");
                }
            }
            if (buffer.isEmpty()) {
                return "?" + String.valueOf(d);
            }
            return buffer.substring(0, buffer.length() - 1);
        }
    }

    private static class StatusProgress
    implements IModelioProgress {
        private String taskName;
        private String subTask;
        private int totalWork;
        private double worked;
        private boolean cancelled;
        private final Collection<WeakReference<IModelioProgress>> delegates = new CopyOnWriteArraySet<WeakReference<IModelioProgress>>();
        private final ReferenceQueue<? super IModelioProgress> refQueue = new ReferenceQueue();

        public void beginTask(String name, int totalWork) {
            this.taskName = name;
            this.totalWork = totalWork;
            this.worked = 0.0;
            this.subTask = "";
            this.cancelled = false;
        }

        public void addDelegate(IModelioProgress delegate) {
            if (delegate != null) {
                this.delegates.add(new WeakReference<IModelioProgress>(delegate, this.refQueue));
                if (this.totalWork > 0) {
                    delegate.beginTask(this.taskName, this.totalWork);
                }
                if (this.subTask != null) {
                    delegate.subTask(this.subTask);
                }
                if (this.worked >= 1.0) {
                    delegate.worked((int)this.worked);
                } else if (this.worked > 0.0) {
                    delegate.internalWorked(this.worked);
                }
                if (this.worked >= (double)this.totalWork) {
                    delegate.done();
                } else if (this.cancelled) {
                    delegate.setCanceled(true);
                }
            }
        }

        public void done() {
            this.worked = this.totalWork;
            this.forEachDelegate(IModelioProgress::done);
        }

        void forEachDelegate(Consumer<IModelioProgress> action) {
            if (this.refQueue.poll() != null) {
                while (this.refQueue.poll() != null) {
                }
                this.delegates.removeIf(r -> r.refersTo(null));
            }
            this.delegates.forEach(ref -> {
                IModelioProgress d = (IModelioProgress)ref.get();
                if (d != null) {
                    action.accept(d);
                }
            });
        }

        public void internalWorked(double work) {
            this.worked += work;
            this.forEachDelegate(d2 -> d2.internalWorked(work));
        }

        public boolean isCanceled() {
            for (WeakReference<IModelioProgress> ref : this.delegates) {
                IModelioProgress d = (IModelioProgress)ref.get();
                if (d == null || !d.isCanceled()) continue;
                return true;
            }
            return this.cancelled;
        }

        public void setCanceled(boolean value) {
            this.cancelled = value;
            this.forEachDelegate(d -> d.setCanceled(value));
        }

        public void setTaskName(String name) {
            this.taskName = name;
            this.forEachDelegate(d -> d.setTaskName(name));
        }

        public void subTask(String name) {
            this.subTask = name;
            this.forEachDelegate(d -> d.subTask(name));
        }

        public void worked(int work) {
            this.worked += (double)work;
            this.forEachDelegate(d -> d.worked(work));
        }
    }
}

