/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnStatusDriver;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.wc.SVNClientManager;

class SvnStatusDriverHolder
implements ICmsStatusDriver {
    private final String user;
    private final ICmsStatusDriver localDriver;
    private final ICmsStatusDriver remoteDriver;

    public SvnStatusDriverHolder(SVNClientManager svnClient, ExmlFileAccess geometry, String user, boolean enforceLocks) {
        Objects.requireNonNull(svnClient);
        Objects.requireNonNull(geometry);
        Objects.requireNonNull(user);
        this.user = user;
        this.localDriver = new SvnStatusDriver(svnClient, geometry, user, enforceLocks, false);
        this.remoteDriver = new SvnStatusDriver(svnClient, geometry, user, enforceLocks, true);
    }

    private ICmsStatusDriver getDriver(boolean askServer) {
        if (askServer) {
            return this.remoteDriver;
        }
        return this.localDriver;
    }

    @Override
    public CompletableFuture<ICmsStatus> asyncGetStatus(File f, boolean askServer) {
        return this.getDriver(askServer).asyncGetStatus(f, askServer);
    }

    @Override
    public CompletableFuture<IStatusSnapshot> asyncGetStatusBatch(Collection<File> files, boolean askServer) {
        return this.getDriver(askServer).asyncGetStatusBatch(files, askServer);
    }

    @Override
    public ICmsStatus getStatus(File file, boolean askServer) throws CmsDriverException {
        return this.getDriver(askServer).getStatus(file, askServer);
    }

    @Override
    public IStatusSnapshot getStatusSnapShot(IModelioProgress aMonitor, boolean remote) throws CmsDriverException {
        return this.getDriver(remote).getStatusSnapShot(aMonitor, remote);
    }

    @Override
    public void invalidateCaches() {
        this.getDriver(false).invalidateCaches();
        this.getDriver(true).invalidateCaches();
    }

    @Override
    public void invalidateCache(File file) {
        this.getDriver(false).invalidateCache(file);
        this.getDriver(true).invalidateCache(file);
    }

    @Override
    public void invalidateCache(Collection<File> files) {
        this.getDriver(false).invalidateCache(files);
        this.getDriver(true).invalidateCache(files);
    }

    @Override
    public void dispose() {
        this.getDriver(false).dispose();
        this.getDriver(true).dispose();
    }

    @Override
    public CompletableFuture<IStatusSnapshot> getBackgroundStatusProgress(IModelioProgress progressListener, boolean remote) {
        return this.getDriver(remote).getBackgroundStatusProgress(progressListener, remote);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [user=");
        builder.append(this.user);
        builder.append(", localDriver=");
        builder.append(this.localDriver);
        builder.append("]");
        return builder.toString();
    }
}

