/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;

class SvnUpdateResult
implements ICmsUpdateResult {
    private Collection<String> createdBlobs = new ArrayList<String>();
    private Collection<String> updatedBlobs = new ArrayList<String>();
    private Collection<String> conflictedBlobs = new ArrayList<String>();
    private Collection<String> deletedBlobs = new ArrayList<String>();
    private Collection<String> mergedBlobs = new ArrayList<String>();
    private Collection<String> unlockedBlobs = new ArrayList<String>();
    private List<MRef> updated = new ArrayList<MRef>();
    private List<MRef> created = new ArrayList<MRef>();
    private List<MRef> deleted = new ArrayList<MRef>();
    private List<MRef> conflicted = new ArrayList<MRef>();
    private List<MRef> merged = new ArrayList<MRef>();
    private List<MRef> unlocked = new ArrayList<MRef>();
    Throwable incompleteCause;
    private Collection<File> updatedOtherFiles = new ArrayList<File>();
    private Collection<File> createdOtherFiles = new ArrayList<File>();
    private Collection<File> deletedOtherFiles = new ArrayList<File>();
    private Collection<File> conflictedOtherFiles = new ArrayList<File>();
    private Collection<File> mergedOtherFiles = new ArrayList<File>();
    private Collection<File> unlockedOtherFiles = new ArrayList<File>();
    private ExmlFileAccess geom;

    @Override
    public List<MRef> getCreatedElements() {
        return this.created;
    }

    @Override
    public List<MRef> getDeletedElements() {
        return this.deleted;
    }

    @Override
    public List<MRef> getUpdatedElements() {
        return this.updated;
    }

    @Override
    public List<MRef> getConflictedElements() {
        return this.conflicted;
    }

    @Override
    public List<MRef> getMergedElements() {
        return this.merged;
    }

    @Override
    public List<MRef> getUnlockedElements() {
        return this.unlocked;
    }

    @Override
    public Collection<String> getCreatedBlobs() {
        return this.createdBlobs;
    }

    @Override
    public Collection<String> getDeletedBlobs() {
        return this.deletedBlobs;
    }

    @Override
    public Collection<String> getUpdatedBlobs() {
        return this.updatedBlobs;
    }

    @Override
    public Collection<String> getConflictedBlobs() {
        return this.conflictedBlobs;
    }

    @Override
    public Throwable getIncompleteUpdateCause() {
        return this.incompleteCause;
    }

    public boolean isEmpty() {
        return this.getUpdatedElements().isEmpty() && this.getCreatedElements().isEmpty() && this.getDeletedElements().isEmpty() && this.getConflictedElements().isEmpty() && this.getMergedElements().isEmpty() && this.getUpdatedBlobs().isEmpty() && this.getCreatedBlobs().isEmpty() && this.getConflictedBlobs().isEmpty() && this.getDeletedBlobs().isEmpty() && this.getMergedBlobs().isEmpty() && this.getUnlockedBlobs().isEmpty() && this.getCreatedOtherFiles().isEmpty() && this.getConflictedOtherFiles().isEmpty() && this.getDeletedOtherFiles().isEmpty() && this.getMergedOtherFiles().isEmpty() && this.getUnlockedOtherFiles().isEmpty() && this.getUpdatedOtherFiles().isEmpty();
    }

    public SvnUpdateResult(ExmlFileAccess geom) {
        this.geom = Objects.requireNonNull(geom);
    }

    void addUpdatedFile(File f) {
        this.dispatch(f, this.updated, this.updatedBlobs, this.updatedOtherFiles);
    }

    void addCreatedFile(File f) {
        this.dispatch(f, this.created, this.createdBlobs, this.createdOtherFiles);
    }

    void addDeletedFile(File f) {
        this.dispatch(f, this.deleted, this.deletedBlobs, this.deletedOtherFiles);
    }

    void addConflictedFile(File f) {
        this.dispatch(f, this.conflicted, this.conflictedBlobs, this.conflictedOtherFiles);
    }

    void addMergedFile(File f) {
        this.dispatch(f, this.merged, this.mergedBlobs, this.mergedOtherFiles);
    }

    void addUnlockedFile(File f) {
        this.dispatch(f, this.unlocked, this.unlockedBlobs, this.unlockedOtherFiles);
    }

    private void dispatch(File file, Collection<MRef> refs, Collection<String> blobs, Collection<File> others) {
        if (this.geom.isModelFile(file)) {
            MRef obRef = this.geom.getObRef(file);
            refs.add(obRef);
        } else if (this.geom.isBlobFile(file)) {
            String blobKey = this.geom.getBlobKey(file);
            blobs.add(blobKey);
        } else {
            others.add(file);
        }
    }

    @Override
    public Collection<File> getConflictedOtherFiles() {
        return this.conflictedOtherFiles;
    }

    @Override
    public Collection<File> getCreatedOtherFiles() {
        return this.createdOtherFiles;
    }

    @Override
    public Collection<File> getDeletedOtherFiles() {
        return this.deletedOtherFiles;
    }

    @Override
    public Collection<File> getMergedOtherFiles() {
        return this.mergedOtherFiles;
    }

    @Override
    public Collection<File> getUnlockedOtherFiles() {
        return this.unlockedOtherFiles;
    }

    @Override
    public Collection<File> getUpdatedOtherFiles() {
        return this.updatedOtherFiles;
    }

    @Override
    public Collection<String> getMergedBlobs() {
        return this.mergedBlobs;
    }

    @Override
    public Collection<String> getUnlockedBlobs() {
        return this.unlockedBlobs;
    }
}

