/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.UnlockResult;
import java.io.File;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

class UnlockFilesEventHandler
implements ISVNEventHandler {
    private int i = 0;
    private int estimatedWork;
    private UnlockResult result;
    IModelioProgress progress = null;

    UnlockFilesEventHandler(IModelioProgress monitor, int estimatedWork, UnlockResult result) {
        this.estimatedWork = estimatedWork;
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)estimatedWork);
        this.result = result;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.progress.isCanceled()) {
            throw new SVNCancelException();
        }
    }

    public void handleEvent(SVNEvent ev, double unused) throws SVNException {
        File file = ev.getFile();
        if (ev.getAction() == SVNEventAction.LOCKED) {
            this.result.addUnlockedFile(file);
        } else if (ev.getAction() == SVNEventAction.LOCK_FAILED) {
            boolean isAlreadyLocked;
            boolean bl = isAlreadyLocked = ev.getErrorMessage().getErrorCode() == SVNErrorCode.FS_LOCK_OWNER_MISMATCH;
            if (isAlreadyLocked) {
                this.result.addLockedElseWhereFile(file);
            } else {
                this.result.addError(file, ev.getErrorMessage().toString());
            }
        } else if (ev.getAction() == SVNEventAction.UPDATE_COMPLETED) {
            this.progress.done();
        }
        this.progress.worked(1);
        ++this.i;
        if (this.i % 4 == 0) {
            this.progress.subTask("Locking " + this.i + "/" + this.estimatedWork);
        }
    }
}

