/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.UnlockResult;
import java.io.File;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

class UnlockModelEventHandler
implements ISVNEventHandler {
    private int i = 0;
    private int estimatedWork;
    private UnlockResult result;
    IModelioProgress progress = null;
    private ExmlFileAccess geom;

    public UnlockModelEventHandler(IModelioProgress monitor, int estimatedWork, UnlockResult result2, ExmlFileAccess geom) {
        this.estimatedWork = estimatedWork;
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)estimatedWork);
        this.result = result2;
        this.geom = geom;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.progress.isCanceled()) {
            throw new SVNCancelException();
        }
    }

    public void handleEvent(SVNEvent ev, double unused) throws SVNException {
        File file = ev.getFile();
        if (ev.getAction() == SVNEventAction.UNLOCKED) {
            if (this.geom.isModelFile(file)) {
                MRef ref = this.geom.getObRef(file);
                this.result.addUnlockedElement(ref);
            } else {
                this.result.addUnlockedFile(file);
            }
        } else if (ev.getAction() == SVNEventAction.UNLOCK_FAILED) {
            SVNErrorCode errorCode = ev.getErrorMessage().getErrorCode();
            if (errorCode == SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN) {
                if (this.geom.isModelFile(file)) {
                    MRef ref = this.geom.getObRef(file);
                    this.result.addUnlockedElement(ref);
                } else {
                    this.result.addUnlockedFile(file);
                }
            } else {
                boolean isAlreadyLocked;
                boolean bl = isAlreadyLocked = errorCode == SVNErrorCode.FS_LOCK_OWNER_MISMATCH;
                if (this.geom.isModelFile(file)) {
                    MRef ref = this.geom.getObRef(file);
                    if (isAlreadyLocked) {
                        this.result.addLockedElseWhereElement(ref);
                    } else {
                        this.result.addError(ref, ev.getErrorMessage().toString());
                    }
                } else if (isAlreadyLocked) {
                    this.result.addLockedElseWhereFile(file);
                } else {
                    this.result.addError(file, ev.getErrorMessage().toString());
                }
            }
        } else if (ev.getAction() == SVNEventAction.UPDATE_COMPLETED) {
            this.progress.done();
        } else {
            StringBuilder s = new StringBuilder();
            s.append(ev.toString());
            if (ev.getErrorMessage() != null) {
                s.append(": ");
                s.append(ev.getErrorMessage());
            }
            if (this.geom.isModelFile(file)) {
                MRef ref = this.geom.getObRef(file);
                this.result.addError(ref, s.toString());
            } else {
                this.result.addError(file, s.toString());
            }
        }
        ++this.i;
        this.progress.worked(1);
        this.progress.subTask("Unlocking " + this.i + "/" + this.estimatedWork + " files...");
    }
}

