/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.driver.ICmsResultFileEntry;
import com.modeliosoft.modelio.cms.driver.ICmsUnlockFilesResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.modelio.vcore.smkernel.mapi.MRef;

class UnlockResult
implements ICmsUnlockResult,
ICmsUnlockFilesResult {
    private List<MRef> locked = new ArrayList<MRef>();
    private Collection<IRefResultEntry> failures = new ArrayList<IRefResultEntry>();
    private Collection<File> unlockedFiles = new ArrayList<File>();
    private Collection<ICmsResultFileEntry> fileFailures = new ArrayList<ICmsResultFileEntry>();
    private List<MRef> lockedElseWhere = new ArrayList<MRef>();
    private Collection<File> lockedElseWhereFiles = new ArrayList<File>();

    UnlockResult() {
    }

    @Override
    public Collection<File> getAlreadyLockedFiles() {
        return this.lockedElseWhereFiles;
    }

    @Override
    public Collection<ICmsResultFileEntry> getFileUnlockFailures() {
        return this.fileFailures;
    }

    public Collection<IRefResultEntry> getLockFailures() {
        return this.failures;
    }

    public Collection<MRef> getLockedElseWhereElements() {
        return this.lockedElseWhere;
    }

    public Collection<MRef> getUnlockedElements() {
        return this.locked;
    }

    @Override
    public Collection<File> getUnlockedFiles() {
        return this.unlockedFiles;
    }

    void addError(MRef ref, String errorMessage) {
        this.failures.add(new ObRefEntry(ref, errorMessage));
    }

    void addError(File file, String errorMessage) {
        this.fileFailures.add(new FileEntry(file, errorMessage));
    }

    void addLockedElseWhereElement(MRef ref) {
        this.lockedElseWhere.add(ref);
    }

    void addLockedElseWhereFile(File file) {
        this.lockedElseWhereFiles.add(file);
    }

    void addUnlockedElement(MRef ref) {
        this.locked.add(ref);
    }

    void addUnlockedFile(File file) {
        this.unlockedFiles.add(file);
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty() || !this.fileFailures.isEmpty() || !this.lockedElseWhere.isEmpty() || !this.lockedElseWhereFiles.isEmpty();
    }

    private static class FileEntry
    implements ICmsResultFileEntry {
        private String cause;
        private File file;

        public FileEntry(File ref, String cause) {
            this.file = ref;
            this.cause = cause;
        }

        @Override
        public String getMessage() {
            return this.cause;
        }

        @Override
        public File getFile() {
            return this.file;
        }
    }

    private static class ObRefEntry
    implements IRefResultEntry {
        private String cause;
        private MRef ref;

        public ObRefEntry(MRef ref, String cause) {
            this.ref = ref;
            this.cause = cause;
        }

        public String getMessage() {
            return this.cause;
        }

        public MRef getRef() {
            return this.ref;
        }
    }
}

