/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

class UpdateAdminEventHandler
implements ISVNEventHandler {
    private int count = 0;
    private SubProgress progress = null;

    public UpdateAdminEventHandler(IModelioProgress monitor) {
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)4);
        this.count = 0;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.progress.isCanceled()) {
            throw new SVNCancelException();
        }
    }

    public int getChangesNumber() {
        return this.count;
    }

    public void handleEvent(SVNEvent ev, double unused) throws SVNException {
        if (ev.getAction() == SVNEventAction.UPDATE_ADD) {
            ++this.count;
            this.progress.subTask("Added " + String.valueOf(ev.getFile()));
        } else if (ev.getAction() == SVNEventAction.UPDATE_COMPLETED) {
            this.progress.done();
        } else if (ev.getAction() == SVNEventAction.UPDATE_DELETE) {
            ++this.count;
            this.progress.subTask("Deleted " + String.valueOf(ev.getFile()));
        } else if (ev.getAction() == SVNEventAction.UPDATE_REPLACE) {
            ++this.count;
        } else if (ev.getAction() == SVNEventAction.UPDATE_UPDATE) {
            ++this.count;
            this.progress.subTask("Updated " + String.valueOf(ev.getFile()));
        } else if (ev.getAction() == SVNEventAction.RESTORE) {
            ++this.count;
            this.progress.subTask("Restored " + String.valueOf(ev.getFile()));
        }
        this.progress.worked(1);
        this.progress.setWorkRemaining(4);
    }
}

