/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnUpdateResult;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.util.Objects;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

class UpdateModelEventHandler
implements ISVNEventHandler {
    private int i = 0;
    private final SvnUpdateResult result;
    private SubProgress progress;
    private final ExmlFileAccess geom;

    public UpdateModelEventHandler(IModelioProgress monitor, ExmlFileAccess geom) {
        this.progress = SubProgress.convert((IModelioProgress)monitor, (int)5);
        this.result = new SvnUpdateResult(geom);
        this.geom = Objects.requireNonNull(geom);
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.progress.isCanceled()) {
            throw new SVNCancelException();
        }
    }

    public SvnUpdateResult getResult() {
        return this.result;
    }

    public void handleEvent(SVNEvent ev, double unused) throws SVNException {
        SVNStatusType lockType;
        File file = ev.getFile();
        SVNEventAction action = ev.getAction();
        if (action == SVNEventAction.UPDATE_ADD || action == SVNEventAction.UPDATE_SHADOWED_ADD) {
            this.result.addCreatedFile(file);
            if (action == SVNEventAction.UPDATE_SHADOWED_ADD) {
                this.handleConflictStatus(ev);
            }
        } else if (action == SVNEventAction.UPDATE_COMPLETED) {
            this.progress.done();
        } else if (action == SVNEventAction.UPDATE_DELETE || action == SVNEventAction.UPDATE_SHADOWED_DELETE) {
            this.result.addDeletedFile(file);
            if (action == SVNEventAction.UPDATE_SHADOWED_DELETE) {
                this.handleConflictStatus(ev);
            }
            if (this.i == 0) {
                this.progress.subTask("Deleted " + String.valueOf(file));
            }
        } else if (action == SVNEventAction.UPDATE_REPLACE || action == SVNEventAction.UPDATE_UPDATE || action == SVNEventAction.UPDATE_SHADOWED_UPDATE) {
            this.result.addUpdatedFile(file);
            this.handleConflictStatus(ev);
        } else if (action == SVNEventAction.RESTORE) {
            this.result.addCreatedFile(file);
        } else if (action == SVNEventAction.RESOLVED) {
            this.result.addMergedFile(file);
            Log.trace((String)"Conflict on '%s' automatically resolved by Modelio.", (Object[])new Object[]{file});
        }
        if ((lockType = ev.getLockStatus()) == SVNStatusType.LOCK_UNLOCKED) {
            this.result.addUnlockedFile(file);
        }
        if (this.i == 0) {
            String newLabel = ProjectSvn.I18N.getMessage("SvnDriver.UpdateMonitor", new Object[]{this.result.getCreatedElements().size(), this.result.getUpdatedElements().size(), this.result.getDeletedElements().size()});
            this.progress.subTask(newLabel);
            this.progress.worked(1);
            this.progress.setWorkRemaining(5);
        }
        if (this.i++ == 5) {
            this.i = 0;
        }
    }

    private void handleConflictStatus(SVNEvent ev) {
        SVNStatusType contentsStatus = ev.getContentsStatus();
        if (contentsStatus != SVNStatusType.CHANGED) {
            if (contentsStatus == SVNStatusType.CONFLICTED || contentsStatus == SVNStatusType.CONFLICTED_UNRESOLVED) {
                this.result.addConflictedFile(ev.getFile());
            } else if (contentsStatus == SVNStatusType.MERGED) {
                this.result.addMergedFile(ev.getFile());
            }
        }
    }
}

