/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.BearerSvnAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.auth.OidcAuthData;
import org.modelio.vbasic.auth.SshAuthData;
import org.modelio.vbasic.auth.UserPasswordAuthData;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class LocalAuthProvider
implements ISVNAuthenticationProvider {
    private List<AuthEntry> auths = new ArrayList<AuthEntry>();

    public void addAuth(SVNURL reposUrl, IAuthData authData) {
        if (authData instanceof UserPasswordAuthData) {
            UserPasswordAuthData userPassData = (UserPasswordAuthData)authData;
            this.removeAuths(reposUrl, SVNPasswordAuthentication.class);
            this.removeAuths(reposUrl, SVNUserNameAuthentication.class);
            SVNPasswordAuthentication svnAuth = SVNPasswordAuthentication.newInstance((String)userPassData.getUser(), (char[])(userPassData.getPassword() != null ? userPassData.getPassword().toCharArray() : null), (boolean)false, (SVNURL)reposUrl, (boolean)false);
            this.auths.add(new AuthEntry(reposUrl, (SVNAuthentication)svnAuth));
            SVNUserNameAuthentication userAuth = SVNUserNameAuthentication.newInstance((String)userPassData.getUser(), (boolean)false, (SVNURL)reposUrl, (boolean)false);
            this.auths.add(new AuthEntry(reposUrl, (SVNAuthentication)userAuth));
        } else if (authData instanceof OidcAuthData) {
            OidcAuthData oidcData = (OidcAuthData)authData;
            this.removeAuths(reposUrl, SVNPasswordAuthentication.class);
            this.removeAuths(reposUrl, SVNUserNameAuthentication.class);
            BearerSvnAuthentication svnAuth = new BearerSvnAuthentication(oidcData, reposUrl);
            this.auths.add(new AuthEntry(reposUrl, (SVNAuthentication)svnAuth));
            SVNUserNameAuthentication userAuth = SVNUserNameAuthentication.newInstance((String)oidcData.getUserId(), (boolean)false, (SVNURL)reposUrl, (boolean)false);
            this.auths.add(new AuthEntry(reposUrl, (SVNAuthentication)userAuth));
        } else if (authData instanceof SshAuthData) {
            SshAuthData sshData = (SshAuthData)authData;
            this.removeAuths(reposUrl, SVNSSHAuthentication.class);
            this.auths.add(new AuthEntry(reposUrl, (SVNAuthentication)LocalAuthProvider.createSshSvnAuth(sshData, reposUrl)));
        }
        Collections.sort(this.auths);
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        SVNAuthentication firstMatch = null;
        boolean previousfound = false;
        for (AuthEntry a : this.auths) {
            if (!this.urlMatches(url, a) && !this.realmMatches(realm, a) || !a.auth.getKind().equals(kind) || a.auth.equals(previousAuth)) continue;
            if (previousAuth == null) {
                return a.auth;
            }
            if (a.auth.equals(previousAuth)) {
                previousfound = true;
                continue;
            }
            if (previousfound) {
                return a.auth;
            }
            if (firstMatch != null) continue;
            firstMatch = a.auth;
        }
        if (previousfound) {
            return null;
        }
        return firstMatch;
    }

    private boolean urlMatches(SVNURL url, AuthEntry authEntry) {
        return url != null && url.getHost().equals(authEntry.url.getHost()) && url.getPath().startsWith(authEntry.url.getPath());
    }

    private boolean realmMatches(String realm, AuthEntry authEntry) {
        return realm != null && realm.contains(authEntry.url.getHost());
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        return 2;
    }

    private static SVNSSHAuthentication createSshSvnAuth(SshAuthData sshData, SVNURL reposUrl) {
        String userName = sshData.getSshUserName();
        char[] keyValue = sshData.getPrivateKey();
        char[] passphrase = sshData.getPrivateKeyPassword();
        int portNumber = sshData.getPortNumber();
        boolean storageAllowed = false;
        boolean isPartial = false;
        SVNSSHAuthentication svnSshAuth = SVNSSHAuthentication.newInstance((String)userName, (char[])keyValue, (char[])passphrase, (int)portNumber, (boolean)storageAllowed, (SVNURL)reposUrl, (boolean)isPartial);
        return svnSshAuth;
    }

    private void removeAuths(SVNURL reposUrl, Class<? extends SVNAuthentication> authCls) {
        this.auths.removeIf(en -> en.url.equals((Object)reposUrl) && authCls.isInstance(en.auth));
    }

    private static class AuthEntry
    implements Comparable<AuthEntry> {
        public final SVNURL url;
        public final SVNAuthentication auth;

        public AuthEntry(SVNURL url, SVNAuthentication auth) {
            this.url = url;
            this.auth = auth;
        }

        public String toString() {
            return "AuthEntry [url=" + String.valueOf(this.url) + ", auth=" + String.valueOf(this.auth) + "]";
        }

        @Override
        public int compareTo(AuthEntry o) {
            int ret = this.auth.getKind().compareTo(o.auth.getKind());
            if (ret != 0) {
                return ret;
            }
            ret = o.url.toString().compareTo(this.url.toString());
            return ret;
        }
    }
}

