/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth;

import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.modelio.vbasic.net.InvalidCertificateException;
import org.modelio.vbasic.net.SslManager;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;

public final class SvnLocalTrustManager
implements X509TrustManager {
    private static final X509TrustManager delegate = SslManager.getInstance().getTrustManager();
    private final SVNURL url;

    public SvnLocalTrustManager(SVNURL url) {
        this.url = url;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return delegate.getAcceptedIssuers();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            delegate.checkServerTrusted(chain, authType);
        }
        catch (InvalidCertificateException e) {
            URI uri = URI.create(this.url.toString());
            if (SslManager.getInstance().fixUntrustedServer(uri, chain, (Throwable)e)) {
                throw e;
            }
            throw new SVNSSLUtil.CertificateNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        delegate.checkClientTrusted(chain, authType);
    }
}

