/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.SimpleProxyManager2;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.SvnLocalTrustManager;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.IAuthProviderEntry;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.OidcAuthProvider;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.SimpleAuthProvider;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.auth.OidcAuthData;
import org.modelio.vbasic.auth.SshAuthData;
import org.modelio.vbasic.auth.UserPasswordAuthData;
import org.modelio.vbasic.log.Log;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class AuthDatasAuthManager
implements ISVNAuthenticationManager,
ISVNSSLPasspharsePromptSupport,
ISVNSSHHostVerifier {
    private int lastEntryIndex;
    private List<IAuthProviderEntry> entries = new ArrayList<IAuthProviderEntry>();
    private ISVNAuthenticationManager defaultManager = new DefaultSVNAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), false, null, null, null, null);
    private SVNErrorMessage lastErrorMessage;
    private SVNAuthentication lastAuthentication;

    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
        this.defaultManager.setAuthenticationProvider(provider);
    }

    public void addAuth(SVNURL reposUrl, IAuthData authData) {
        if (authData instanceof UserPasswordAuthData) {
            UserPasswordAuthData userPassData = (UserPasswordAuthData)authData;
            this.removeAuths(reposUrl, "svn.simple");
            this.removeAuths(reposUrl, "svn.username");
            SVNPasswordAuthentication svnAuth = SVNPasswordAuthentication.newInstance((String)userPassData.getUser(), (char[])(userPassData.getPassword() != null ? userPassData.getPassword().toCharArray() : null), (boolean)false, (SVNURL)reposUrl, (boolean)false);
            this.entries.add(new SimpleAuthProvider(reposUrl, (SVNAuthentication)svnAuth));
            SVNUserNameAuthentication userAuth = SVNUserNameAuthentication.newInstance((String)userPassData.getUser(), (boolean)false, (SVNURL)reposUrl, (boolean)false);
            this.entries.add(new SimpleAuthProvider(reposUrl, (SVNAuthentication)userAuth));
        } else if (authData instanceof OidcAuthData) {
            OidcAuthData oidcData = (OidcAuthData)authData;
            this.removeAuths(reposUrl, "svn.simple");
            this.removeAuths(reposUrl, "svn.username");
            this.entries.add(new OidcAuthProvider(reposUrl, oidcData));
            SVNUserNameAuthentication userAuth = SVNUserNameAuthentication.newInstance((String)oidcData.getUserId(), (boolean)false, (SVNURL)reposUrl, (boolean)false);
            this.entries.add(new SimpleAuthProvider(reposUrl, (SVNAuthentication)userAuth));
        } else if (authData instanceof SshAuthData) {
            SshAuthData sshData = (SshAuthData)authData;
            this.removeAuths(reposUrl, "svn.ssh");
            this.entries.add(new SimpleAuthProvider(reposUrl, (SVNAuthentication)AuthDatasAuthManager.createSshSvnAuth(sshData, reposUrl)));
        }
        this.checkConnectionParams(reposUrl);
        Collections.sort(this.entries);
    }

    private static String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    private void checkConnectionParams(SVNURL reposUrl) {
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)reposUrl);
            repository.setAuthenticationManager((ISVNAuthenticationManager)this);
            String logCat = this.getClass().getSimpleName();
            String protocol = reposUrl.getProtocol();
            int readTimeout = this.getReadTimeout(repository);
            if (readTimeout <= 0) {
                Log.trace((String)"%s: %s read timeout is %d ms for %s", (Object[])new Object[]{logCat, protocol, readTimeout, reposUrl});
            } else if ((long)readTimeout < Duration.ofMinutes(10L).toMillis()) {
                Log.warning((String)"%s: %s read timeout is %s for %s, this should be 10 minutes minimum.", (Object[])new Object[]{logCat, protocol, AuthDatasAuthManager.humanReadableFormat(Duration.ofMillis(readTimeout)), reposUrl});
                Log.warning((String)"%s: See '%s' SVN configuration file", (Object[])new Object[]{logCat, new File(SVNWCUtil.getDefaultConfigurationDirectory(), "servers")});
            } else {
                Log.trace((String)"%s: %s read timeout is %s for %s", (Object[])new Object[]{logCat, protocol, AuthDatasAuthManager.humanReadableFormat(Duration.ofMillis(readTimeout)), reposUrl});
            }
            int connectTimeout = this.getConnectTimeout(repository);
            if (connectTimeout <= 0) {
                Log.trace((String)"%s: %s connect timeout is %d ms for %s", (Object[])new Object[]{logCat, protocol, connectTimeout, reposUrl});
            } else if ((long)connectTimeout > Duration.ofSeconds(60L).toMillis()) {
                Log.warning((String)"%s: %s connect timeout is %s for %s, should be 60 seconds maximum.", (Object[])new Object[]{logCat, protocol, AuthDatasAuthManager.humanReadableFormat(Duration.ofMillis(connectTimeout)), reposUrl});
                Log.warning((String)"%s: See '%s' SVN configuration file", (Object[])new Object[]{logCat, new File(SVNWCUtil.getDefaultConfigurationDirectory(), "servers")});
            } else {
                Log.trace((String)"%s: %s connect timeout is %s for %s", (Object[])new Object[]{logCat, protocol, AuthDatasAuthManager.humanReadableFormat(Duration.ofMillis(connectTimeout)), reposUrl});
            }
        }
        catch (SVNException e) {
            Log.error((Throwable)e);
        }
    }

    private void removeAuths(SVNURL reposUrl, String kind) {
        this.entries.removeIf(en -> en.getSvnUrl().equals((Object)reposUrl) && kind.equals(en.getKind()));
    }

    private static SVNSSHAuthentication createSshSvnAuth(SshAuthData sshData, SVNURL reposUrl) {
        String userName = sshData.getSshUserName();
        char[] keyValue = sshData.getPrivateKey();
        char[] passphrase = sshData.getPrivateKeyPassword();
        int portNumber = sshData.getPortNumber();
        boolean storageAllowed = false;
        boolean isPartial = false;
        SVNSSHAuthentication svnSshAuth = SVNSSHAuthentication.newInstance((String)userName, (char[])keyValue, (char[])passphrase, (int)portNumber, (boolean)storageAllowed, (SVNURL)reposUrl, (boolean)isPartial);
        return svnSshAuth;
    }

    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        this.lastEntryIndex = 0;
        do {
            IAuthProviderEntry manager;
            SVNAuthentication auth;
            if ((auth = (manager = this.entries.get(this.lastEntryIndex)).requestClientAuthentication(kind, url, realm, null, null, false)) != null) {
                return auth;
            }
            ++this.lastEntryIndex;
        } while (this.lastEntryIndex < this.entries.size());
        return this.defaultManager.getFirstAuthentication(kind, realm, url);
    }

    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        do {
            IAuthProviderEntry manager;
            SVNAuthentication auth;
            if ((auth = (manager = this.entries.get(this.lastEntryIndex)).requestClientAuthentication(kind, url, realm, this.lastErrorMessage, this.lastAuthentication, false)) != null) {
                return auth;
            }
            ++this.lastEntryIndex;
        } while (this.lastEntryIndex < this.entries.size());
        return this.defaultManager.getNextAuthentication(kind, realm, url);
    }

    public boolean isAuthenticationForced() {
        return false;
    }

    public void acknowledgeTrustManager(TrustManager manager) {
        this.defaultManager.acknowledgeTrustManager(manager);
    }

    public TrustManager getTrustManager(SVNURL url) throws SVNException {
        return new SvnLocalTrustManager(url);
    }

    public int getConnectTimeout(SVNRepository repository) {
        return this.defaultManager.getConnectTimeout(repository);
    }

    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        this.lastErrorMessage = errorMessage;
        this.lastAuthentication = authentication;
        this.defaultManager.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication);
    }

    public int getReadTimeout(SVNRepository repository) {
        return this.defaultManager.getReadTimeout(repository);
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        return SimpleProxyManager2.getFromDefaultAndSystemProperties(this.defaultManager.getProxyManager(url));
    }

    public void verifyHostKey(String hostName, int port, String keyAlgorithm, byte[] hostKey) throws SVNException {
        if (this.defaultManager instanceof ISVNSSHHostVerifier) {
            ((ISVNSSHHostVerifier)this.defaultManager).verifyHostKey(hostName, port, keyAlgorithm, hostKey);
        }
    }

    public boolean isSSLPassphrasePromtSupported() {
        if (!(this.defaultManager instanceof ISVNSSLPasspharsePromptSupport)) {
            return false;
        }
        return ((ISVNSSLPasspharsePromptSupport)this.defaultManager).isSSLPassphrasePromtSupported();
    }
}

