/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.IAuthProviderEntry;
import java.io.IOException;
import org.modelio.vbasic.auth.OidcAuthData;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;

class OidcAuthProvider
implements IAuthProviderEntry {
    private int failureCount;
    private final OidcAuthData oidcAuth;
    private final SVNURL relatedUrl;
    private SVNPasswordAuthentication storedAuth;

    public OidcAuthProvider(SVNURL url, OidcAuthData storedAuth) {
        this.relatedUrl = url;
        this.oidcAuth = storedAuth;
    }

    @Override
    public String getKind() {
        return "svn.simple";
    }

    @Override
    public SVNURL getSvnUrl() {
        return this.relatedUrl;
    }

    @Override
    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        if (!"svn.simple".equals(kind)) {
            return null;
        }
        if (!this.urlMatches(url) && !this.realmMatches(realm)) {
            return null;
        }
        if (previousAuth == this.storedAuth) {
            ++this.failureCount;
            if (this.failureCount > 2) {
                this.failureCount = 0;
                this.storedAuth = null;
                return null;
            }
        }
        try {
            this.storedAuth = this.createOidcAuthentication();
            return this.storedAuth;
        }
        catch (IOException e) {
            if (errorMessage != null) {
                Log.error((Throwable)e);
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_NOT_AUTHORIZED, (String)FileUtils.getLocalizedMessage((IOException)e), (Object)e);
                errorMessage.getRootErrorMessage().setChildErrorMessage(err);
            }
            return null;
        }
    }

    private SVNPasswordAuthentication createOidcAuthentication() throws IOException {
        String token = this.oidcAuth.getToken();
        SVNPasswordAuthentication svnAuth = SVNPasswordAuthentication.newInstance((String)this.oidcAuth.getUserId(), (char[])token.toCharArray(), (boolean)false, (SVNURL)this.relatedUrl, (boolean)false);
        return svnAuth;
    }

    private boolean urlMatches(SVNURL url) {
        return url != null && url.getHost().equals(this.relatedUrl.getHost()) && url.getPath().startsWith(this.relatedUrl.getPath());
    }

    private boolean realmMatches(String realm) {
        return realm != null && realm.contains(this.relatedUrl.getHost());
    }
}

