/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple;

import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.IAuthProviderEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;

class SimpleAuthProvider
implements IAuthProviderEntry {
    private final SVNAuthentication storedAuth;
    private final SVNURL relatedUrl;

    public SimpleAuthProvider(SVNURL url, SVNAuthentication storedAuth) {
        this.relatedUrl = url;
        this.storedAuth = storedAuth;
    }

    @Override
    public String getKind() {
        return this.storedAuth.getKind();
    }

    @Override
    public SVNURL getSvnUrl() {
        return this.relatedUrl;
    }

    @Override
    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        if (previousAuth == this.storedAuth) {
            return null;
        }
        if (!this.storedAuth.getKind().equals(kind)) {
            return null;
        }
        if (!this.urlMatches(url) && !this.realmMatches(realm)) {
            return null;
        }
        return this.storedAuth;
    }

    private boolean urlMatches(SVNURL url) {
        return url != null && url.getHost().equals(this.relatedUrl.getHost()) && url.getPath().startsWith(this.relatedUrl.getPath());
    }

    private boolean realmMatches(String realm) {
        return realm != null && realm.contains(this.relatedUrl.getHost());
    }
}

