/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.repository;

import com.modeliosoft.modelio.cms.api.ConflictSide;
import com.modeliosoft.modelio.cms.driver.parse.CmsNodeStruct;
import com.modeliosoft.modelio.cms.driver.parse.StructureSnapshot;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.repository.LocalResource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.resource.AbstractExmlResourceProvider;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class ConflictedResourceProvider
extends AbstractExmlResourceProvider {
    private String name;
    private ConflictSide side;
    private SVNClientManager svnClient;
    private Collection<MRef> content = new HashSet<MRef>();
    private Path indexPath;
    private Path repositoryPath;
    private StructureSnapshot struct;

    public ConflictedResourceProvider(Path repositoryPath, Path runtimePath, SVNClientManager svnClient, ConflictSide side, StructureSnapshot structureSnapshot) {
        this.svnClient = svnClient;
        this.repositoryPath = repositoryPath;
        this.side = side;
        this.name = repositoryPath.getFileName().toString();
        this.indexPath = runtimePath.resolve(".index");
        this.struct = structureSnapshot;
    }

    public void add(Collection<MObject> conflictedElements) {
        for (MObject o : conflictedElements) {
            this.content.add(new MRef(o));
        }
    }

    public void addFiles(Collection<File> conflictedFiles) {
    }

    public void buildIndexes(IModelioProgress monitor) throws IOException {
        Files.createDirectories(this.indexPath, new FileAttribute[0]);
    }

    public void close() throws IOException, FileSystemException {
    }

    public void commit() throws IOException {
    }

    protected void doCreateRepository(MMetamodel mm) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Collection<IExmlResourceProvider.ExmlResource> getAllResources(IModelioProgress aMonitor) throws IOException {
        assert (this.struct != null);
        SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)100);
        ArrayList<MRef> roots = new ArrayList<MRef>(this.content);
        HashSet<MRef> foundContent = new HashSet<MRef>();
        this.buildContentTree(roots, foundContent, mon.newChild(50));
        ArrayList<IExmlResourceProvider.ExmlResource> ret = new ArrayList<IExmlResourceProvider.ExmlResource>();
        ArrayList<MRef> newContent = new ArrayList<MRef>(foundContent.size());
        mon.setWorkRemaining(foundContent.size());
        for (MRef ref : foundContent) {
            IExmlResourceProvider.ExmlResource resource = this.doGetResource(ref);
            ret.add(resource);
            newContent.add(ref);
            mon.worked(1);
        }
        this.content = newContent;
        return ret;
    }

    public Collection<IExmlResourceProvider.ExmlResource> getAllBlobs(IModelioProgress aMonitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    public File getIndexAccessPath() {
        return this.indexPath.toFile();
    }

    public IExmlResourceProvider.ExmlResource getLocalResource(ObjId cmsNodeId) {
        String f = this.getGeometry().getLocalFileRelativePath(cmsNodeId.toMRef());
        return new RoLocalResource(this.repositoryPath.resolve(f));
    }

    public String getName() {
        return this.name;
    }

    public IExmlResourceProvider.ExmlResource getResource(ObjId cmsNodeId) throws IOException {
        MRef mref = cmsNodeId.toMRef();
        if (!this.content.contains(mref)) {
            return null;
        }
        return this.doGetResource(mref);
    }

    public String getStamp() {
        return this.side.toString();
    }

    public URI getURI() {
        return this.repositoryPath.toUri();
    }

    public boolean isBrowsable() {
        return true;
    }

    public boolean isWriteable() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRepository(IExmlRepositoryGeometry geometry) {
        this.struct = new StructureSnapshot(new ExmlFileAccess(this.repositoryPath.toFile(), geometry));
    }

    public String toString() {
        return "'" + this.name + "' " + String.valueOf(this.side) + " conflict repository @" + String.valueOf(this.repositoryPath);
    }

    public void writeStamp() throws IOException {
    }

    private void buildContentTree(Collection<MRef> nodes, Collection<MRef> found, SubProgress mon) throws IOException {
        for (MRef ref : nodes) {
            if (found.contains(ref)) continue;
            found.add(ref);
            File exmlPath = this.resolvePath(this.getGeometry().getRelativePath(ref));
            File localExmlPath = this.repositoryPath.resolve(this.getGeometry().getLocalFileRelativePath(ref)).toFile();
            CmsNodeStruct node = this.struct.getNode(exmlPath, localExmlPath);
            if (node != null) {
                this.buildContentTree(node.getComponents(), found, mon);
            }
            mon.worked(1);
            mon.setWorkRemaining(5);
        }
    }

    private IExmlResourceProvider.ExmlResource doGetResource(MRef ref) throws IOException {
        File ret = this.resolvePath(this.getGeometry().getRelativePath(ref));
        return new RoLocalResource(ret.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getSidedPath(File normalPath) throws UnsupportedOperationException, IOException {
        try {
            SVNInfo info;
            SVNClientManager sVNClientManager = this.svnClient;
            synchronized (sVNClientManager) {
                info = this.svnClient.getWCClient().doInfo(normalPath, SVNRevision.WORKING);
            }
            File ret = switch (this.side) {
                case ConflictSide.BASE -> info.getConflictOldFile();
                case ConflictSide.MINE -> info.getConflictWrkFile();
                case ConflictSide.THEIRS -> info.getConflictNewFile();
                default -> throw new UnsupportedOperationException(this.side.toString());
            };
            if (ret == null) {
                return normalPath;
            }
            return ret;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return normalPath;
            }
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public boolean exists() throws IOException {
        return Files.isDirectory(this.repositoryPath, new LinkOption[0]);
    }

    public IExmlResourceProvider.ExmlResource getRelativePathResource(String relativePath) throws IOException {
        File sided = this.resolvePath(relativePath);
        return new RoLocalResource(sided.toPath());
    }

    File resolvePath(String relativePath) throws IOException {
        Path p = this.repositoryPath.resolve(relativePath);
        File sided = this.getSidedPath(p.toFile());
        return sided;
    }

    static class RoLocalResource
    extends LocalResource {
        public RoLocalResource(Path p) {
            super(p);
        }

        @Override
        public OutputStream write() throws IOException {
            throw new AccessDeniedException(this.getPublicLocation());
        }

        @Override
        public void delete() throws IOException {
            throw new AccessDeniedException(this.getPublicLocation());
        }
    }
}

