/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.resilient;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsLog;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.driver.WrappedCmsDriver;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.resilient.ResilientCmsLog;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.resilient.ResilientCmsStatusDriver;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.resilient.RetryPolicy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;

public class ResilientCmsDriver
extends WrappedCmsDriver {
    public ResilientCmsDriver(ICmsDriver wrapped) {
        super(wrapped);
    }

    @Override
    public ICmsLog getLog(IModelioProgress monitor, Collection<File> files) throws CmsDriverException {
        ICmsLog cmsLog = new RetryPolicy().call(() -> super.getLog(monitor, files));
        return new ResilientCmsLog(cmsLog);
    }

    @Override
    public ICmsLog getLog(IModelioProgress monitor, String branchUrl, String fromRevision, Collection<File> files, boolean stopOnBranchStart) throws CmsDriverException {
        ICmsLog cmsLog = new RetryPolicy().call(() -> super.getLog(monitor, branchUrl, fromRevision, files, stopOnBranchStart));
        return new ResilientCmsLog(cmsLog);
    }

    @Override
    public void getFileContent(File filePath, OutputStream dst, String revision) throws CmsDriverException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(32768);
        new RetryPolicy().call(() -> {
            os.reset();
            super.getFileContent(filePath, os, revision);
            return null;
        });
        try {
            os.writeTo(dst);
        }
        catch (IOException e) {
            throw new CmsDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    @Override
    public ICmsStatusDriver getStatusDriver() {
        return new ResilientCmsStatusDriver(super.getStatusDriver());
    }
}

