/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.resilient;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import java.io.EOFException;
import java.net.SocketException;
import org.modelio.vbasic.log.Log;

public class RetryPolicy {
    private int count;
    private static final int MAX = 3;

    public final <T> T call(CmsSupplier<T> action) throws CmsDriverException {
        CmsDriverException lastError = null;
        while (this.count < 3) {
            try {
                return action.get();
            }
            catch (CmsDriverException e) {
                if (!this.isRetryable((Throwable)((Object)e))) {
                    throw e;
                }
                Log.warning((String)"%s: %s operation failed %d time(s) with %s", (Object[])new Object[]{this.getClass().getSimpleName(), action, this.count + 1, e});
                if (lastError != null) {
                    e.addSuppressed((Throwable)((Object)lastError));
                }
                lastError = e;
                ++this.count;
            }
        }
        if (lastError == null) {
            throw new IllegalStateException();
        }
        throw lastError;
    }

    protected boolean isRetryable(Throwable e) {
        Throwable t = e;
        while (t != null) {
            if (t instanceof SocketException) {
                return true;
            }
            if (t instanceof EOFException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    @FunctionalInterface
    public static interface CmsSupplier<T> {
        public T get() throws CmsDriverException;
    }
}

