/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.services;

import com.modeliosoft.modelio.cms.driver.CmsAuthenticationException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnDriver;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.auth.NoneAuthData;
import org.modelio.vbasic.auth.OidcAuthData;
import org.modelio.vbasic.auth.UserPasswordAuthData;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnConnection
implements AutoCloseable {
    private String projectName;
    private File workingCopyPath = null;
    private SVNURL repositoryURL = null;
    private SVNClientManager svnClient = null;

    public SvnConnection(String repositoryPath, IAuthData auth, File projectSpacePath, String projectName) throws CmsAuthenticationException, CmsDriverException {
        this.workingCopyPath = projectSpacePath;
        this.projectName = projectName;
        this.repositoryURL = SvnDriver.convertRepositoryPath(repositoryPath);
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        String protocol = this.repositoryURL.getProtocol();
        if (!Arrays.asList("http", "https", "file", "svn", "svn+ssh").contains(protocol)) {
            throw new CmsDriverException(ProjectSvn.I18N.getMessage("error.UnknownProtocol", new Object[]{protocol, repositoryPath}));
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        options.setConflictHandler((ISVNConflictHandler)new ConflictHandler());
        ISVNAuthenticationManager svnAuthManager = this.initAuth(auth);
        this.svnClient = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)svnAuthManager);
    }

    public void checkoutWorkingCopy(IModelioProgress aProgress) throws IOException, CmsAuthenticationException {
        SubProgress progress = SubProgress.convert((IModelioProgress)aProgress);
        try {
            try {
                this.svnClient.setEventHandler((ISVNEventHandler)new UpdateHandler(progress, this.projectName));
                SVNUpdateClient updateClient = this.svnClient.getUpdateClient();
                updateClient.setIgnoreExternals(false);
                updateClient.doCheckout(this.repositoryURL, this.workingCopyPath, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(ProjectSvn.I18N.getMessage("SvnConnection.UpdateFailed", new Object[]{this.repositoryURL, e.getErrorMessage().toString()}), e);
            }
            catch (SVNException e) {
                throw new IOException(ProjectSvn.I18N.getMessage("SvnConnection.CheckoutFailed", new Object[]{this.repositoryURL, e.getErrorMessage().toString()}), e);
            }
        }
        finally {
            this.svnClient.setEventHandler(null);
        }
    }

    public void updateFile(Path path, IModelioProgress aProgress) throws IOException, CmsAuthenticationException {
        SubProgress progress = SubProgress.convert((IModelioProgress)aProgress);
        try {
            try {
                SVNRevision revision = SVNRevision.HEAD;
                boolean allowUnversionedObstructions = true;
                this.svnClient.setEventHandler((ISVNEventHandler)new UpdateHandler(progress, this.projectName));
                this.svnClient.getUpdateClient().doUpdate(path.toFile(), revision, SVNDepth.INFINITY, allowUnversionedObstructions, false);
            }
            catch (SVNAuthenticationException e) {
                throw new CmsAuthenticationException(ProjectSvn.I18N.getMessage("SvnConnection.UpdateFailed", new Object[]{this.repositoryURL, e.getErrorMessage().toString()}), e);
            }
            catch (SVNException e) {
                throw new IOException(ProjectSvn.I18N.getMessage("SvnConnection.UpdateFailed", new Object[]{this.repositoryURL, e.getErrorMessage().toString()}), e);
            }
        }
        finally {
            this.svnClient.setEventHandler(null);
        }
    }

    @Override
    public void close() {
        if (this.svnClient == null) {
            return;
        }
        this.svnClient.dispose();
        this.svnClient = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isVersioned(Path p) {
        return SVNWCUtil.isVersionedDirectory((File)p.toFile());
    }

    public URI getRepositoryUri() {
        return URI.create(this.repositoryURL.toString());
    }

    public static URI convertToURI(String repositoryPath) throws CmsDriverException {
        SVNURL svnUrl = SvnDriver.convertRepositoryPath(repositoryPath);
        return URI.create(svnUrl.toString());
    }

    private ISVNAuthenticationManager initAuth(IAuthData authData) throws CmsAuthenticationException {
        if (authData instanceof UserPasswordAuthData) {
            UserPasswordAuthData userPassData = (UserPasswordAuthData)authData;
            return BasicAuthenticationManager.newInstance((String)userPassData.getUser(), (char[])userPassData.getPassword().toCharArray());
        }
        if (authData instanceof OidcAuthData) {
            char[] token;
            OidcAuthData oidcData = (OidcAuthData)authData;
            try {
                token = oidcData.getToken().toCharArray();
            }
            catch (IOException e) {
                throw new CmsAuthenticationException(this.repositoryURL.toString() + ": " + FileUtils.getLocalizedMessage((IOException)e), e);
            }
            BasicAuthenticationManager ret = BasicAuthenticationManager.newInstance((String)oidcData.getUserId(), (char[])token);
            ret.setAuthenticationForced(true);
            return ret;
        }
        if (authData == null || authData instanceof NoneAuthData) {
            return BasicAuthenticationManager.newInstance(null, null, null, (int)-1);
        }
        throw new CmsAuthenticationException(this.repositoryURL.toString() + ": " + authData.getSchemeId() + " authentication scheme not supported", null);
    }

    private static class ConflictHandler
    implements ISVNConflictHandler {
        public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
            return new SVNConflictResult(SVNConflictChoice.THEIRS_FULL, null);
        }
    }

    private static final class UpdateHandler
    implements ISVNEventHandler {
        private int nbCreated;
        private int nbUpdated;
        private int nbDeleted;
        private String projName;
        private final SubProgress progress;

        UpdateHandler(SubProgress progress, String projName) {
            this.progress = progress;
            this.projName = projName;
            this.progress.setWorkRemaining(10);
        }

        public void checkCancelled() throws SVNCancelException {
            if (this.progress.isCanceled()) {
                throw new SVNCancelException();
            }
        }

        public void handleEvent(SVNEvent ev, double unused) throws SVNException {
            SVNEventAction action = ev.getAction();
            if (action == SVNEventAction.UPDATE_ADD) {
                ++this.nbCreated;
            } else if (action == SVNEventAction.UPDATE_COMPLETED) {
                this.progress.subTask("");
                this.progress.done();
            } else if (action == SVNEventAction.UPDATE_DELETE) {
                ++this.nbDeleted;
            } else if (action == SVNEventAction.UPDATE_EXISTS) {
                Log.warning((String)ev.toString());
            } else if (action == SVNEventAction.UPDATE_REPLACE) {
                ++this.nbUpdated;
            } else if (action == SVNEventAction.UPDATE_SKIP_ACCESS_DENINED) {
                Log.warning((String)ev.toString());
            } else if (action == SVNEventAction.UPDATE_SKIP_OBSTRUCTION) {
                Log.warning((String)ev.toString());
            } else if (action == SVNEventAction.UPDATE_UPDATE) {
                ++this.nbUpdated;
            }
            if (action != SVNEventAction.UPDATE_COMPLETED) {
                this.progress.worked(1);
                this.progress.setWorkRemaining(10);
                String newLabel = ProjectSvn.I18N.getMessage("SvnConnection.UpdateMonitor", new Object[]{this.nbCreated, this.nbUpdated, this.nbDeleted, this.projName});
                this.progress.subTask(newLabel);
            }
        }
    }
}

