/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.cmsdriver.services;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsDriverFactory;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.SvnDriver;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.impl.auth.multiple.AuthDatasAuthManager;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.resilient.ResilientCmsDriver;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.modelio.gproject.core.IGProject;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.log.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class SvnDriverFactory {
    private static boolean lookForPlugins = true;
    private static boolean useDefaultDriver = true;
    private static final WeakHashMap<IGProject, AuthDatasAuthManager> projAuthProviders = new WeakHashMap();

    public static void configure(boolean lookForPlugins, boolean useDefaultDriver) {
        SvnDriverFactory.lookForPlugins = lookForPlugins;
        SvnDriverFactory.useDefaultDriver = useDefaultDriver;
    }

    public static ICmsDriver getDriver(String repositoryPath, Collection<IAuthData> authDatas, File workingCopyPath, IGProject gProject, boolean enforceLocks) throws CmsDriverException {
        Supplier<ICmsDriver> defaultDriverProvider = () -> {
            try {
                AuthDatasAuthManager authProvider = projAuthProviders.computeIfAbsent(gProject, k -> new AuthDatasAuthManager());
                SvnDriver svnDriver = new SvnDriver(repositoryPath, authDatas, authProvider, workingCopyPath, enforceLocks);
                ResilientCmsDriver resilientCmsDriver = new ResilientCmsDriver(svnDriver);
                return resilientCmsDriver;
            }
            catch (CmsDriverException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        };
        try {
            if (lookForPlugins) {
                ICmsDriver found = SvnDriverFactory.findCmsDriverFromPlugins(repositoryPath, authDatas, workingCopyPath, enforceLocks, defaultDriverProvider);
                if (found != null) {
                    return found;
                }
                if (!useDefaultDriver) {
                    throw new CmsDriverException("No ICmsDriverFactory returned a driver for repository: " + repositoryPath);
                }
                Log.trace((String)"SvnDriverFactory: No driver factory returned a driver, using default driver provider.");
            }
            return defaultDriverProvider.get();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CmsDriverException) {
                throw (CmsDriverException)((Object)e.getCause());
            }
            throw new CmsDriverException(e.getMessage(), e);
        }
    }

    private static ICmsDriver findCmsDriverFromPlugins(String repositoryPath, Collection<IAuthData> authDatas, File workingCopyPath, boolean enforceLocks, Supplier<ICmsDriver> defaultDriverProvider) throws CmsDriverException {
        ServiceLoader<ICmsDriverFactory> factories = ServiceLoader.load(ICmsDriverFactory.class, ICmsDriverFactory.class.getClassLoader());
        for (ICmsDriverFactory factory : factories) {
            ICmsDriver driver = factory.getDriver(repositoryPath, authDatas, workingCopyPath, enforceLocks, defaultDriverProvider);
            if (driver == null) continue;
            Log.trace((String)("SvnDriverFactory: Using driver factory: " + factory.getClass().getName()));
            return driver;
        }
        ICmsDriverFactory osgiCmsDriverFactory = SvnDriverFactory.findOsgiCmsDriver();
        if (osgiCmsDriverFactory != null) {
            ICmsDriver driver = osgiCmsDriverFactory.getDriver(repositoryPath, authDatas, workingCopyPath, enforceLocks, defaultDriverProvider);
            if (driver != null) {
                Log.trace((String)"SvnDriverFactory: Using %s OSGI CMS driver .", (Object[])new Object[]{driver.getClass().getName()});
                return driver;
            }
            Log.trace((String)("SvnDriverFactory: " + String.valueOf(osgiCmsDriverFactory) + " OSGI CMS driver factory did not return a driver for repository: " + repositoryPath));
        }
        return null;
    }

    private static ICmsDriverFactory findOsgiCmsDriver() {
        try {
            return new OsgiCmsDriverFactory().findOsgiCmsDriver();
        }
        catch (LinkageError e) {
            Log.trace((String)"SvnDriverFactory: %s(%s) caught while trying to find OSGI CMS driver factory, OSGI probably not available.", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
            Log.trace((Throwable)e);
            return null;
        }
    }

    private static class OsgiCmsDriverFactory {
        private OsgiCmsDriverFactory() {
        }

        public ICmsDriverFactory findOsgiCmsDriver() {
            Bundle bundle = FrameworkUtil.getBundle(SvnDriverFactory.class);
            if (bundle == null) {
                Log.trace((String)"OsgiCmsDriverFactory: Cannot find the bundle for SvnDriverFactory. OSGI context is not available.");
                return null;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(ICmsDriverFactory.class);
            if (serviceReference == null) {
                if (Log.getLogger().getLevel() <= 0) {
                    this.logAllBundles(bundle, bundleContext);
                }
                return null;
            }
            return (ICmsDriverFactory)bundleContext.getService(serviceReference);
        }

        private void logAllBundles(Bundle bundle, BundleContext bundleContext) {
            Log.trace((String)("OsgiCmsDriverFactory: No ICmsDriverFactory service found in " + String.valueOf(bundle) + " OSGI context with bundles:"));
            Bundle[] bundles = bundleContext.getBundles();
            Arrays.sort(bundles, (b1, b2) -> b1.getSymbolicName().compareTo(b2.getSymbolicName()));
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                Log.trace((String)"  - Bundle %s (%s) is %s.", (Object[])new Object[]{b.getSymbolicName(), b.getVersion(), OsgiCmsDriverFactory.getStateString(b)});
                if (b.getSymbolicName().contains("javahl")) {
                    Object[] refs = b.getRegisteredServices();
                    Log.trace((String)"    - %d services registered in %s bundle:", (Object[])new Object[]{refs != null ? refs.length : 0, b.getSymbolicName()});
                    if (refs != null) {
                        Log.trace((String)"      - %s", (Object[])new Object[]{Arrays.toString(refs != null ? refs : new ServiceReference[]{})});
                        Object[] objectArray = refs;
                        int n3 = refs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object ref = objectArray[n4];
                            Log.trace((String)"        - Service %s %s with properties: %s", (Object[])new Object[]{ref, ref.getProperty("service.id"), Arrays.toString(ref.getPropertyKeys())});
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }

        private static String getStateString(Bundle bundle) {
            switch (bundle.getState()) {
                case 32: {
                    return "ACTIVE";
                }
                case 2: {
                    return "INSTALLED";
                }
                case 4: {
                    return "RESOLVED";
                }
                case 8: {
                    return "STARTING";
                }
                case 16: {
                    return "STOPPING";
                }
                case 1: {
                    return "UNINSTALLED";
                }
            }
            return "UNKNOWN: " + bundle.getState();
        }
    }
}

