/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment;

import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.modelio.vcore.session.UnknownMetaclassException;
import org.modelio.vcore.session.api.blob.IBlobSupport;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;

class FragmentCmsFilesGetter
implements ICmsFilesGetter {
    private ExmlFileAccess filesGeometry;
    private IModel imodel;
    private IBlobSupport blobSupport;

    public FragmentCmsFilesGetter(IModel imodel, ExmlFileAccess geo, IBlobSupport blobSupport) {
        Objects.requireNonNull(imodel);
        Objects.requireNonNull(geo);
        Objects.requireNonNull(blobSupport);
        this.imodel = imodel;
        this.blobSupport = blobSupport;
        this.filesGeometry = geo;
    }

    @Override
    public Collection<File> getRelatedRefFiles(Collection<MRef> cmsNodeRefs) {
        ArrayList<File> ret = new ArrayList<File>(cmsNodeRefs.size() * 2);
        for (MRef ref : cmsNodeRefs) {
            this.addRelatedRefFiles(ref, ret);
        }
        return ret;
    }

    @Override
    public Collection<File> getRelatedRefFiles(MRef cmsNodeRef) {
        ArrayList<File> ret = new ArrayList<File>(2);
        this.addRelatedRefFiles(cmsNodeRef, ret);
        return ret;
    }

    private void addRelatedRefFiles(MRef ref, Collection<File> ret) throws UnknownMetaclassException {
        ret.add(this.filesGeometry.getExmlFile(ref));
        MObject cmsNode = this.imodel.findByRef(ref);
        if (cmsNode != null) {
            Collection blobIds = this.blobSupport.getRelatedBlobs(cmsNode);
            this.addBlobFiles(blobIds, ret);
        }
    }

    @Override
    public Collection<File> getRelatedFiles(Collection<MObject> cmsNodes) {
        ArrayList<File> ret = new ArrayList<File>(cmsNodes.size() * 2);
        for (MObject cmsNode : cmsNodes) {
            this.getFiles(cmsNode, ret);
        }
        return ret;
    }

    @Override
    public Collection<File> getRelatedFiles(MObject cmsNode) {
        ArrayList<File> ret = new ArrayList<File>(2);
        this.getFiles(cmsNode, ret);
        return ret;
    }

    private void getFiles(MObject cmsNode, Collection<File> ret) {
        ret.add(this.filesGeometry.getExmlFile(cmsNode));
        Collection blobIds = this.blobSupport.getRelatedBlobs(cmsNode);
        this.addBlobFiles(blobIds, ret);
    }

    private void addBlobFiles(Collection<String> blobIds, Collection<File> ret) {
        for (String blobKey : blobIds) {
            File f = this.filesGeometry.getBlobFile(blobKey);
            if (!f.isFile()) continue;
            ret.add(f);
        }
    }

    @Override
    public Collection<File> getBlobFiles(Collection<String> blobIds) {
        ArrayList<File> ret = new ArrayList<File>(blobIds.size());
        this.addBlobFiles(blobIds, ret);
        return ret;
    }

    @Override
    public Collection<File> getExmlFiles(Collection<MRef> refs) {
        ArrayList<File> ret = new ArrayList<File>(refs.size());
        for (MRef ref : refs) {
            ret.add(this.filesGeometry.getExmlFile(ref));
        }
        return ret;
    }

    @Override
    public ExmlFileAccess getFilesGeometry() {
        return this.filesGeometry;
    }

    @Override
    public Collection<File> getRelatedExmlFiles(Collection<MObject> cmsNodes) {
        ArrayList<File> ret = new ArrayList<File>(cmsNodes.size() * 2);
        for (MObject cmsNode : cmsNodes) {
            ret.add(this.filesGeometry.getExmlFile(cmsNode));
        }
        return ret;
    }

    @Override
    public Collection<File> getRelatedBlobFiles(Collection<MObject> cmsNodes) {
        ArrayList<File> ret = new ArrayList<File>(cmsNodes.size());
        for (MObject cmsNode : cmsNodes) {
            Collection blobIds = this.blobSupport.getRelatedBlobs(cmsNode);
            this.addBlobFiles(blobIds, ret);
        }
        return ret;
    }
}

