/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment;

import com.modeliosoft.modelio.cms.driver.CmsAuthenticationException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.repository.RemoteAccessResourceProvider;
import com.modeliosoft.modelio.gproject.svn.cmsdriver.services.SvnDriverFactory;
import com.modeliosoft.modelio.gproject.svn.fragment.FragmentCmsFilesGetter;
import com.modeliosoft.modelio.gproject.svn.fragment.migration.ChainedSvnFragmentMigrator;
import com.modeliosoft.modelio.gproject.svn.fragment.migration.SaveMmVersionMigrator;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.RemovalRecorder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.FragmentMigrationNeededException;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGPartState;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.DefinitionScope;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.project.GProperties;
import org.modelio.gproject.data.project.IFragmentInfos;
import org.modelio.gproject.data.project.auth.UnknownAuthData;
import org.modelio.gproject.migration.FragmentMigratorWithBackup;
import org.modelio.gproject.parts.IGModelFragmentMigrator;
import org.modelio.gproject.parts.fragment.AbstractGModelFragment;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.metamodel.StandardMetamodel;
import org.modelio.metamodel.uml.infrastructure.AbstractProject;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.auth.NoneAuthData;
import org.modelio.vbasic.auth.SshAuthData;
import org.modelio.vbasic.auth.UserPasswordAuthData;
import org.modelio.vbasic.files.CloseOnFail;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.model.spi.mm.MigrationChain;
import org.modelio.vcore.model.spi.mm.MmVersionComparator;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.blob.IBlobSupport;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.version.ModelioVersion;
import org.modelio.vstore.exml.common.AbstractExmlRepository;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;

public class GSvnFragment
extends AbstractGModelFragment {
    private static final String PROP_INDEX_WITH_DATA = "exml.indexWithData";
    private static final String PROP_USE_LOCKS = "cms.useLocks";
    private boolean useLocks = this.readUseLocks();
    private ICmsDriver cmsDriver;
    private CmsVersionedRepository repository;
    private IAuthData tunnelAuth = this.loadTunnelAuth();

    public GSvnFragment(GProjectPartDescriptor desc) {
        super(desc);
    }

    protected void doInstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    protected void doUninstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    public IRepository doMountInitRepository(IGProject project, IModelioProgress aMonitor) throws IOException, FragmentAuthenticationException {
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (int)100);
        boolean indexWithData = Boolean.valueOf(this.getProperties().getValue(PROP_INDEX_WITH_DATA));
        boolean ok = false;
        try {
            Path location = this.getDataDirectory();
            this.cmsDriver = SvnDriverFactory.getDriver(this.getDescriptor().getLocation().toString(), this.getAllAuthDatas(), location.toFile(), this.getProject(), this.useLocks);
            if (!this.cmsDriver.isVersioned(location)) {
                SubProgress childMon = monitor.newChild(50);
                this.atomicSvnCheckout((IModelioProgress)childMon);
            }
            if (!Files.isDirectory(location, new LinkOption[0])) {
                throw new NoSuchFileException(location.toString());
            }
            if (monitor.isCanceled()) {
                throw new InterruptedIOException("Operation cancelled by user.");
            }
            Path indexDir = indexWithData ? location : this.getRuntimeDirectory();
            this.repository = new CmsVersionedRepository(this.getId(), location, indexDir, this.cmsDriver, this.useLocks);
            IExmlResourceProvider resourceProvider = this.repository.getResourceProvider();
            if (!resourceProvider.exists()) {
                this.atomicCreateRepositoryStructure((IModelioProgress)monitor.newChild(30), location);
            } else {
                ICoreSession session = this.getProject().getSession();
                this.initializeDriver(this.cmsDriver, location, session, resourceProvider);
            }
            this.cmsDriver = this.repository.getDriver();
            RemovalRecorder.get(this.getProject()).connect(this);
            ok = true;
            CmsVersionedRepository cmsVersionedRepository = this.repository;
            return cmsVersionedRepository;
        }
        catch (CmsAuthenticationException e) {
            throw new FragmentAuthenticationException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
        catch (CmsDriverException e) {
            throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
        finally {
            if (!ok && this.cmsDriver != null) {
                this.cmsDriver.dispose();
                this.cmsDriver = null;
            }
        }
    }

    public final ICmsDriver getCmsDriver() {
        return this.cmsDriver;
    }

    public CmsVersionedRepository getCmsRepository() {
        return this.repository;
    }

    public IGModelFragmentMigrator getMigrator(MetamodelVersionDescriptor targetMetamodel) throws IOException {
        ChainedSvnFragmentMigrator chainedMigrator = new ChainedSvnFragmentMigrator(this.getProject(), this, (IExmlResourceProvider)this.newResourceProvider(), targetMetamodel);
        MigrationChain migrationChain = chainedMigrator.getMigrationChain();
        if (migrationChain.isNoopMigrationChain()) {
            MetamodelVersionDescriptor srcMetamodel = this.getRequiredMetamodelDescriptor();
            return new FragmentMigratorWithBackup((IGModelFragment)this, (IGModelFragmentMigrator)new SaveMmVersionMigrator(this.getProject(), this, srcMetamodel, targetMetamodel));
        }
        if (migrationChain.isSuccessful()) {
            return new FragmentMigratorWithBackup((IGModelFragment)this, (IGModelFragmentMigrator)chainedMigrator);
        }
        return null;
    }

    public Path getMmVersionPath() {
        return this.getDataDirectory().resolve("admin").resolve("mmversion.dat");
    }

    public AbstractExmlRepository getRepository() {
        return this.repository;
    }

    public MetamodelVersionDescriptor getRequiredMetamodelDescriptor() throws IOException {
        MetamodelVersionDescriptor ret = this.readMetamodelVersion();
        if (ret == null || ret.isEmpty()) {
            Log.warning((String)("No metamodel version file for '" + this.getId() + "' SVN fragment. Will assume Modelio 3.1 (9020) metamodel version."));
            return new MetamodelVersionDescriptor(new VersionedItem(StandardMetamodel.NAME, VersionHelper.convert((int)9020)));
        }
        return ret;
    }

    public CmsVersionedRepository instantiateRepository(ICoreSession session, boolean withLocks) throws FragmentAuthenticationException, IOException {
        SubProgress monitor = SubProgress.convert(null, (int)100);
        boolean indexWithData = Boolean.valueOf(this.getProperties().getValue(PROP_INDEX_WITH_DATA));
        Collection<IAuthData> authd = this.getAllAuthDatas();
        try {
            ICmsDriver aCmsDriver = SvnDriverFactory.getDriver(this.getDescriptor().getLocation().toString(), authd, this.getDataDirectory().toFile(), this.getProject(), withLocks);
            if (!aCmsDriver.isVersioned(this.getDataDirectory())) {
                aCmsDriver.checkout((IModelioProgress)monitor.newChild(50));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedIOException("Operation cancelled by user.");
            }
            Path indexDir = indexWithData ? this.getDataDirectory() : this.getRuntimeDirectory();
            CmsVersionedRepository repo = new CmsVersionedRepository(this.getId(), this.getDataDirectory(), indexDir, aCmsDriver, withLocks);
            IExmlResourceProvider resourceProvider = repo.getResourceProvider();
            this.initializeDriver(aCmsDriver, this.getDataDirectory(), session, resourceProvider);
            return repo;
        }
        catch (CmsAuthenticationException e) {
            throw new FragmentAuthenticationException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
        catch (CmsDriverException e) {
            throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    public void reconfigure(GProjectPartDescriptor fd, IModelioProgress aMonitor) throws IGPart.GPartException {
        boolean locationChanged;
        GProjectPartDescriptor currentDescriptor = this.getDescriptor();
        boolean bl = locationChanged = !Objects.equals(currentDescriptor.getLocation(), fd.getLocation());
        if (locationChanged && !this.handleSwitchRelocate(fd, aMonitor)) {
            String msg = MessageFormat.format("{0} SVN fragment URI changed from ''{1}'' to ''{2}'' without a ''relocate'' nor a ''switch'' property. \nA new checked out fragment will replace the ''{0}'' fragment.", this.getId(), this.getDescriptor().getLocation(), fd.getLocation());
            ProjectSvn.LOG.warning(msg);
        }
        if (!locationChanged) {
            boolean wasMount = this.getState().getValue() == IGPartState.GPartStateEnum.MOUNTED;
            SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)2);
            if (wasMount) {
                this.unmount((IModelioProgress)mon.newChild(1));
            }
            currentDescriptor.setDefinitionScope(fd.getDefinitionScope());
            this.setProperties(new GProperties(fd.getProperties()));
            this.tunnelAuth = this.loadTunnelAuth();
            this.useLocks = this.readUseLocks();
            if (wasMount) {
                mon.setWorkRemaining(1);
                this.mount((IModelioProgress)mon);
            }
        } else {
            super.reconfigure(fd, aMonitor);
        }
    }

    public void relocateRepository(URI newUri, IModelioProgress aMonitor) throws CmsDriverException {
        String newUriStr = newUri.toString();
        this.getCmsDriver().relocateRepository(aMonitor, newUriStr);
        this.getDescriptor().setLocation(newUri);
        this.getProperties().setProperty("relocate", newUriStr, DefinitionScope.LOCAL);
    }

    public void switchRepository(URI newUri, IModelioProgress aMonitor) throws CmsDriverException {
        String newUriStr = newUri.toString();
        this.getCmsDriver().switchWorkingCopy(aMonitor, newUriStr);
        this.getDescriptor().setLocation(newUri);
        this.getProperties().setProperty("switch", newUriStr, DefinitionScope.LOCAL);
    }

    public boolean useLocks() {
        return this.useLocks;
    }

    LocalExmlResourceProvider newResourceProvider() {
        return new LocalExmlResourceProvider(this.getDataDirectory(), this.getRuntimeDirectory(), this.getId());
    }

    protected void checkVersions() throws FragmentMigrationNeededException, IOException {
        RepositoryVersions repoVersion;
        MetamodelVersionDescriptor currentMm = this.getCurrentMmDescriptor();
        FragmentMigrationNeededException diag = null;
        try {
            super.checkVersions();
        }
        catch (FragmentMigrationNeededException e) {
            diag = e;
        }
        if (diag == null && (repoVersion = this.repository.getResourceProvider().readRepositoryVersion()).getRepositoryFormat() < 3) {
            diag = new FragmentMigrationNeededException((IGModelFragment)this, this.getCurrentMmDescriptor(), ProjectSvn.I18N.getMessage("GSvnFragment.MigrationNeeded.RepositoryFormatNeedMigration", new Object[]{this.getId(), repoVersion.getRepositoryFormat(), 3}));
        }
        if (diag != null) {
            this.checkRepositoryVersions(diag);
            IGModelFragmentMigrator migrator = this.getMigrator(currentMm);
            if (migrator != null) {
                throw diag;
            }
            throw new IOException(diag.getLocalizedMessage(), diag);
        }
    }

    protected Collection<MObject> doGetRoots() {
        SmMetamodel mm = this.getProjectMetamodel();
        Collection ret = this.repository.findByClass(mm.getMClass(AbstractProject.class), true);
        return ret;
    }

    protected IAccessManager doInitAccessManager() {
        BasicAccessManager ret = new BasicAccessManager();
        ret.setWriteable(this.getAccessRights().isEditable());
        return ret;
    }

    protected void doUmountPostProcess(IGProject project, IModelioProgress monitor) throws IOException {
        this.repository = null;
        if (this.cmsDriver != null) {
            this.cmsDriver.dispose();
            this.cmsDriver = null;
        }
    }

    protected MetamodelVersionDescriptor readMetamodelVersion() throws IOException {
        Path p = this.getMmVersionPath();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader in = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                return VersionHelper.convert((MetamodelVersionDescriptor)new MetamodelVersionDescriptor((Reader)in));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return null;
        }
    }

    private ICmsFilesGetter createFilesGetter(ICoreSession session, ExmlFileAccess exmlFileAccess) {
        IModel imodel = session.getModel();
        IBlobSupport blobSupport = session.getBlobSupport();
        return new FragmentCmsFilesGetter(imodel, exmlFileAccess, blobSupport);
    }

    private boolean handleSwitchRelocate(GProjectPartDescriptor fd, IModelioProgress aMonitor) {
        String newUriStr = fd.getLocation().toString();
        if (newUriStr.equals(fd.getProperties().getValue("switch"))) {
            try {
                this.getCmsDriver().switchWorkingCopy(aMonitor, newUriStr);
            }
            catch (CmsDriverException e) {
                this.setDown((Throwable)((Object)e));
            }
            return true;
        }
        if (fd.getLocation().toString().equals(fd.getProperties().getValue("relocate"))) {
            try {
                this.getCmsDriver().relocateRepository(aMonitor, newUriStr);
            }
            catch (CmsDriverException e) {
                this.setDown((Throwable)((Object)e));
            }
            return true;
        }
        return false;
    }

    private void initializeDriver(ICmsDriver driver, Path location, ICoreSession session, IExmlResourceProvider resourceProvider) throws IOException {
        resourceProvider.open();
        IExmlRepositoryGeometry geometry = resourceProvider.getGeometry();
        ExmlFileAccess exmlFileAccess = new ExmlFileAccess(location.toFile(), geometry);
        ICmsFilesGetter filesGetter = this.createFilesGetter(session, exmlFileAccess);
        driver.initialize(filesGetter);
    }

    private boolean readUseLocks() {
        String useLockStr = this.getProperties().getValue(PROP_USE_LOCKS);
        return useLockStr != null ? Boolean.valueOf(useLockStr) : true;
    }

    private void checkRepositoryVersions(FragmentMigrationNeededException e) throws IOException {
        RepositoryVersions repoVersion;
        IExmlResourceProvider remoteAccess = this.getRemoteExmlResourceProvider("HEAD");
        MetamodelVersionDescriptor neededMm = this.getRemoteRequiredMetamodelDescriptor(remoteAccess);
        MetamodelVersionDescriptor currentMm = this.getCurrentMmDescriptor();
        MmVersionComparator comparator = MmVersionComparator.withSource((MetamodelVersionDescriptor)neededMm).withTarget(currentMm);
        if (!comparator.isTargetCompatible(false)) {
            IGModelFragmentMigrator migrator = this.getMigrator(currentMm);
            if (migrator != null) {
                e.setRemoteMigrationNeeded();
            } else if (!comparator.withMissingSourcesRemoved().isTargetCompatible(true)) {
                e.setRemoteMigrationNeeded();
            }
        }
        if ((repoVersion = remoteAccess.readRepositoryVersion()).getRepositoryFormat() < 3) {
            e.setRemoteMigrationNeeded();
            e.addSuppressed((Throwable)new FragmentMigrationNeededException((IGModelFragment)this, this.getCurrentMmDescriptor(), ProjectSvn.I18N.getMessage("GSvnFragment.MigrationNeeded.RepositoryFormatNeedMigration", new Object[]{this.getId(), repoVersion.getRepositoryFormat(), 3})).setRemoteMigrationNeeded());
        }
    }

    private IExmlResourceProvider getRemoteExmlResourceProvider(String revisionOrBranch) throws IOException {
        ICmsDriver lowLevelDriver;
        if (this.repository != null) {
            lowLevelDriver = this.repository.getLowLevelDriver();
        } else {
            try {
                lowLevelDriver = SvnDriverFactory.getDriver(this.getDescriptor().getLocation().toString(), this.getAllAuthDatas(), this.getDataDirectory().toFile(), this.getProject(), this.useLocks);
            }
            catch (CmsDriverException e) {
                throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
        }
        return new RemoteAccessResourceProvider(lowLevelDriver, revisionOrBranch, this.getDataDirectory());
    }

    private MetamodelVersionDescriptor getRemoteRequiredMetamodelDescriptor(IExmlResourceProvider remoteAccess) throws IOException {
        IExmlResourceProvider.ExmlResource mmVerResource = remoteAccess.getRelativePathResource("admin/mmversion.dat");
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(mmVerResource.read(), StandardCharsets.UTF_8));){
                return VersionHelper.convert((MetamodelVersionDescriptor)new MetamodelVersionDescriptor((Reader)in));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            Log.warning((String)("No metamodel version file at '" + mmVerResource.getPublicLocation() + "'. Will assume Modelio 3.1 (9020) metamodel version."));
            return new MetamodelVersionDescriptor(new VersionedItem(StandardMetamodel.NAME, VersionHelper.convert((int)9020)));
        }
    }

    public boolean isRemoteMigrationNeeded() throws IOException {
        IExmlResourceProvider remoteAccess = this.getRemoteExmlResourceProvider("HEAD");
        MetamodelVersionDescriptor neededMm = this.getRemoteRequiredMetamodelDescriptor(remoteAccess);
        MetamodelVersionDescriptor currentMm = this.getCurrentMmDescriptor();
        MmVersionComparator comparator = MmVersionComparator.withSource((MetamodelVersionDescriptor)neededMm).withTarget(currentMm);
        if (!comparator.isTargetCompatible(false)) {
            return true;
        }
        RepositoryVersions repoVersion = remoteAccess.readRepositoryVersion();
        return repoVersion.getRepositoryFormat() < 3;
    }

    /*
     * Loose catch block
     */
    public IFragmentInfos getInformations() throws IOException {
        Path infosuri = this.getDataDirectory().resolve("manifest.properties");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                SvnFragmentInfos svnFragmentInfos;
                InputStreamReader in;
                InputStream is;
                block18: {
                    block17: {
                        is = Files.newInputStream(infosuri, new OpenOption[0]);
                        in = new InputStreamReader(is, StandardCharsets.UTF_8);
                        Properties p = new Properties();
                        p.load(in);
                        svnFragmentInfos = new SvnFragmentInfos(p.getProperty("name"), p.getProperty("description"), new Version(p.getProperty("version")), new Version(p.getProperty("modelioversion")));
                        if (in == null) break block17;
                        in.close();
                    }
                    if (is == null) break block18;
                    is.close();
                }
                return svnFragmentInfos;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            Log.warning((String)("No '" + String.valueOf(infosuri) + "' infos version file, use default values."));
            return new SvnFragmentInfos(this.getId(), "", new Version("0.0.0"), ModelioVersion.VERSION);
        }
    }

    private IAuthData loadTunnelAuth() {
        String scheme;
        GProperties props = this.getProperties();
        if (!props.keys().contains("tunnel.auth.scheme")) {
            return null;
        }
        UnknownAuthData auth = switch (scheme = props.getValue("tunnel.auth.scheme")) {
            case "AUTH_USER_PASSWORD" -> new UserPasswordAuthData();
            case "AUTH_SSH" -> new SshAuthData();
            case "AUTH_NONE" -> new NoneAuthData();
            default -> new UnknownAuthData(scheme);
        };
        String prefix = "tunnel.auth.data.";
        Iterator it = props.entries().iterator();
        while (it.hasNext()) {
            GProperties.Entry en = (GProperties.Entry)it.next();
            if (!en.getName().startsWith(prefix)) continue;
            auth.getData().put(en.getName().substring(prefix.length()), en.getValue());
            it.remove();
        }
        return auth;
    }

    private Collection<IAuthData> getAllAuthDatas() {
        if (this.tunnelAuth == null) {
            return Collections.singletonList(this.resolveAuthData());
        }
        return Arrays.asList(this.tunnelAuth, this.resolveAuthData());
    }

    private void atomicCreateRepositoryStructure(IModelioProgress monitor, Path location) throws CmsDriverException {
        Closeable cleanerOnFail = () -> {
            if (Files.exists(location, new LinkOption[0])) {
                FileUtils.delete((Path)location);
            }
        };
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseOnFail s = new CloseOnFail(cleanerOnFail);){
                this.repository.create((MMetamodel)this.getProjectMetamodel());
                Path mmVersionPath = this.getMmVersionPath();
                Files.createDirectories(mmVersionPath.getParent(), new FileAttribute[0]);
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (BufferedWriter out = Files.newBufferedWriter(mmVersionPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                    this.getCurrentMmDescriptor().write((Writer)out);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                ICoreSession session = this.getProject().getSession();
                this.initializeDriver(this.cmsDriver, location, session, this.repository.getResourceProvider());
                this.cmsDriver.createRepositoryStructure(monitor, (MMetamodel)this.getProjectMetamodel());
                s.success();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CmsDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    private void atomicSvnCheckout(IModelioProgress monitor) throws CmsDriverException {
        Closeable cleanerOnFail = () -> {
            Path location = this.getDataDirectory();
            if (Files.exists(location, new LinkOption[0])) {
                FileUtils.delete((Path)location);
            }
        };
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CloseOnFail s = new CloseOnFail(cleanerOnFail);){
                this.cmsDriver.checkout(monitor);
                s.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CmsDriverException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    public class SvnFragmentInfos
    implements IFragmentInfos {
        private String name;
        private String description;
        private Version version;
        private Version modelioVersion;

        public SvnFragmentInfos(String name, String description, Version version, Version modelioVersion) {
            this.name = name;
            this.description = description;
            this.version = version;
            this.modelioVersion = modelioVersion;
        }

        public long getRevision() throws CmsDriverException {
            ICmsDriver lCmsDriver = GSvnFragment.this.cmsDriver;
            if (lCmsDriver == null) {
                return -1L;
            }
            return lCmsDriver.getStatusDriver().getStatus(GSvnFragment.this.getDataDirectory().toFile(), false).getLastRevision();
        }

        public String getDescription() {
            return this.description;
        }

        public Version getModelioVersion() {
            return this.modelioVersion;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

