/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment.migration;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.fragment.migration.SvnMigrationHelper;
import com.modeliosoft.modelio.gproject.svn.fragment.migration.SvnRepositoryFormatMigrator;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.MigrationFailedException;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.migration.ChainedMofFragmentMigrator;
import org.modelio.gproject.migration.FileFlags;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.mm.AbstractMofRepositoryMigrator;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.model.spi.mm.IMigrationStepDescription;
import org.modelio.vcore.model.spi.mm.IMofRepositoryMigrator;
import org.modelio.vcore.model.spi.mm.IMofRepositoryMigratorProvider;
import org.modelio.vcore.model.spi.mm.IMofSession;
import org.modelio.vcore.model.spi.mm.MigrationChain;
import org.modelio.vcore.model.spi.mm.MigrationStepDescription;
import org.modelio.vcore.model.spi.mm.MigrationStepGroup;
import org.modelio.vcore.model.spi.mm.MofMigrationException;
import org.modelio.vcore.model.spi.mm.MofSession;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MetaclassNotFoundException;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

public class ChainedSvnFragmentMigrator
extends ChainedMofFragmentMigrator {
    private IExmlResourceProvider resourceProvider;
    private final GSvnFragment svnFragment;
    private final Path mmVersionPath;
    private RepositoryVersions localFormatVersion;
    private final MetamodelVersionDescriptor sourceMm;
    private final MetamodelVersionDescriptor targetMetamodelDesc;
    private Data data;

    public ChainedSvnFragmentMigrator(IGProject project, GSvnFragment svnFragment, IExmlResourceProvider resourceProvider, MetamodelVersionDescriptor targetMetamodelDesc) throws IOException {
        super(project, (IGModelFragment)svnFragment, sess -> svnFragment.instantiateRepository(sess, svnFragment.useLocks()));
        this.svnFragment = svnFragment;
        this.targetMetamodelDesc = targetMetamodelDesc;
        this.mmVersionPath = svnFragment.getMmVersionPath();
        this.resourceProvider = resourceProvider;
        this.localFormatVersion = this.resourceProvider.readRepositoryVersion();
        this.sourceMm = this.svnFragment.getRequiredMetamodelDescriptor();
    }

    protected void postMofMigration(Supplier<SubProgress> mon, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MofMigrationException {
    }

    @Deprecated
    private void __handleCmsNodeChanges(Supplier<SubProgress> monitorSupplier, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MetaclassNotFoundException {
    }

    private Collection<File> migrateRepositoryFormat(Supplier<SubProgress> progressSupplier, RepositoryVersions formatVersion) throws FragmentAuthenticationException, IOException, MofMigrationException {
        if (!this.isFormatMigrationNeeded(formatVersion)) {
            return Collections.emptyList();
        }
        int origFormat = formatVersion.getRepositoryFormat();
        int requiredFormat = 3;
        String taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.migrateFormat", new Object[]{this.svnFragment.getId(), origFormat, requiredFormat});
        SubProgress mon = SubProgress.convert((IModelioProgress)((IModelioProgress)progressSupplier.get()), (String)taskName, (int)3);
        mon.subTask(taskName);
        IMigrationReporter reporter = this.getMigrationReporter();
        reporter.getLogger().println(taskName);
        Throwable throwable = null;
        Object var9_10 = null;
        try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), 0), this.svnFragment, reporter);){
            SvnRepositoryFormatMigrator formatMigrator = new SvnRepositoryFormatMigrator(this.svnFragment.getDataDirectory(), (MMetamodel)helper.getTempSession().getMetamodel(), helper.getCmsDriver(), reporter, origFormat, requiredFormat);
            formatMigrator.execute((IModelioProgress)mon.newChild(2));
            return formatMigrator.getFilesToCommit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String computeUserMessage() {
        try {
            MigrationChain migrationChain = this.getMigrationChain();
            if (migrationChain.isSuccessful()) {
                GSvnFragment fragmentToMigrate = (GSvnFragment)this.getFragmentToMigrate();
                if (fragmentToMigrate.isRemoteMigrationNeeded()) {
                    return ProjectSvn.I18N.getMessage("GSvnFragment.MigrationNeeded.detail", new Object[]{this.svnFragment.getId()});
                }
                return ProjectSvn.I18N.getMessage("GSvnFragment.MigrationNeeded.local.detail", new Object[]{this.svnFragment.getId()});
            }
        }
        catch (IOException iOException) {}
        return super.computeUserMessage();
    }

    protected MigrationChain resolveMigrationChain(MetamodelVersionDescriptor fromMetamodel, MetamodelVersionDescriptor targetMetamodel, Collection<IMofRepositoryMigratorProvider> migrationProviders) {
        MigrationChain ret = super.resolveMigrationChain(fromMetamodel, targetMetamodel, migrationProviders);
        if (ret.isNoopMigrationChain() && this.isFormatMigrationNeeded(this.localFormatVersion)) {
            return ret.add(new MigrationStepGroup((IMofRepositoryMigrator)new RepoFormatMigrationNeededMigrator(fromMetamodel, fromMetamodel)));
        }
        return ret;
    }

    private boolean isFormatMigrationNeeded(RepositoryVersions repoVersion) {
        return repoVersion.getRepositoryFormat() < 3;
    }

    /*
     * WARNING - void declaration
     */
    private void migrateForLocallyModified(SubProgress mon, IStatusSnapshot initStatusSnap) throws FragmentAuthenticationException, MigrationFailedException, IOException, MofMigrationException {
        SvnMigrationHelper helper;
        IMigrationReporter reporter = this.getMigrationReporter();
        reporter.getLogger().println("The '" + this.svnFragment.getId() + "' model is already migrated on server, migrating local part of the model.");
        mon.setWorkRemaining(13);
        for (Map.Entry<File, ICmsStatus> entry : initStatusSnap.getAllFiles().entrySet()) {
            ICmsStatus status = entry.getValue();
            Path f = entry.getKey().toPath();
            if (status == null || !status.isVersioned() || status.isModified() || status.isConflicted() || !Files.isRegularFile(f, new LinkOption[0])) continue;
            reporter.getLogger().println("  - temporary delete of '" + String.valueOf(f) + "'.");
            Files.delete(f);
        }
        Throwable throwable = null;
        Iterator<Map.Entry<File, ICmsStatus>> iterator = null;
        try (OutputStream out = this.resourceProvider.getRepositoryVersionResource().bufferedWrite();){
            this.localFormatVersion.write(out);
        }
        catch (Throwable throwable2) {
            void var4_12;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var4_12;
        }
        Throwable throwable4 = null;
        iterator = null;
        try {
            helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), 0), this.svnFragment, reporter);
            try {
                helper.rebuildIndexes((IModelioProgress)mon.newChild(1));
            }
            finally {
                if (helper != null) {
                    helper.close();
                }
            }
        }
        catch (Throwable throwable5) {
            void var4_16;
            if (throwable4 == null) {
                Throwable throwable6 = throwable5;
            } else if (throwable4 != throwable5) {
                throwable4.addSuppressed(throwable5);
            }
            throw var4_16;
        }
        this.runMofMigrators((IModelioProgress)mon.newChild(8));
        this.migrateRepositoryFormat(mon.newChildSupplier(1), this.localFormatVersion);
        reporter.getLogger().println("'" + this.svnFragment.getId() + "' model rewritten.");
        try {
            Throwable throwable7 = null;
            iterator = null;
            try {
                helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), 0), this.data.previousSvnhelper);
                try {
                    this.data.previousSvnhelper = helper;
                    helper.writeMetamodelDescriptor(this.getFinalMergedMmDescriptor(this.getMigrationReporter()));
                    this.resourceProvider.getRepositoryVersionResource().delete();
                    reporter.getLogger().println("Restore non locally modified elements with SVN update ...");
                    helper.updateWorkingCopy((IModelioProgress)mon.newChild(1));
                }
                finally {
                    if (helper != null) {
                        helper.close();
                    }
                }
            }
            catch (Throwable throwable8) {
                void var4_20;
                if (throwable7 == null) {
                    Throwable throwable9 = throwable8;
                } else if (throwable7 != throwable8) {
                    throwable7.addSuppressed(throwable8);
                }
                throw var4_20;
            }
        }
        catch (CmsDriverException cmsDriverException) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), cmsDriverException);
        }
    }

    private void migrateForServer(SubProgress mon, RepositoryVersions serverFormatVersion) throws FragmentAuthenticationException, MigrationFailedException, IOException, MofMigrationException {
        this.runMofMigrators((IModelioProgress)mon.newChild(1));
        this.data.formatMigrated = this.migrateRepositoryFormat(mon.newChildSupplier(1), serverFormatVersion);
        mon.setWorkRemaining(3);
        Throwable throwable = null;
        Object var4_5 = null;
        try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), 0), this.data.previousSvnhelper);){
            this.data.previousSvnhelper = helper;
            helper.writeAdminFiles();
            helper.addFilesToCommit(this.data.formatMigrated);
            helper.writeMetamodelDescriptor(this.getFinalMergedMmDescriptor(this.getMigrationReporter()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doStart(IModelioProgress monitor) throws FragmentAuthenticationException, MigrationFailedException {
        String taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.migration", new Object[]{this.svnFragment.getId()});
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)taskName, (int)15);
        mon.subTask(taskName);
        try {
            this.data = new Data();
            Throwable throwable = null;
            Object var5_10 = null;
            try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), 0), this.svnFragment, this.getMigrationReporter());){
                ICmsDriver cmsDriver = helper.getCmsDriver();
                this.data.previousSvnhelper = helper;
                new FileFlags((IGModelFragment)this.svnFragment).putMigrationFlag("migrator", ((Object)((Object)this)).getClass().getName());
                helper.updateWorkingCopy((IModelioProgress)mon.newChild(1));
                try {
                    cmsDriver.revert((IModelioProgress)mon.newChild(1), Arrays.asList(helper.getRepositoryFormatVersionFile(), helper.getMetamodelDescriptorFile()));
                }
                catch (CmsDriverException e) {
                    this.getLogger().printStackTrace((Throwable)((Object)e));
                }
                helper.rebuildIndexes((IModelioProgress)mon.newChild(1));
                this.data.initStatusSnap = cmsDriver.getStatusDriver().getStatusSnapShot((IModelioProgress)mon.newChild(1), false);
                helper.checkLocalModelState((IModelioProgress)mon.newChild(1));
                this.data.serverFormatVersion = helper.getRepositoryFormatVersion();
                if (this.isFormatMigrationNeeded(this.data.serverFormatVersion)) {
                    this.getLogger().println("'" + this.svnFragment.getId() + "' " + this.data.serverFormatVersion.getRepositoryFormat() + " repository format not migrated on server.");
                }
                this.getLogger().printf("repository format on local dir: %d, to migrate=%b\n", new Object[]{this.localFormatVersion.getRepositoryFormat(), this.isFormatMigrationNeeded(this.localFormatVersion)});
                this.getLogger().printf("repository format on server: %d, to migrate=%b\n", new Object[]{this.data.serverFormatVersion.getRepositoryFormat(), this.isFormatMigrationNeeded(this.data.serverFormatVersion)});
                boolean bl = this.data.migratedOnServer = helper.checkAlreadyMigrated(mon.newChild(1)) && !this.isFormatMigrationNeeded(this.data.serverFormatVersion);
                if (!this.data.migratedOnServer) {
                    this.getLogger().println("'" + this.svnFragment.getId() + "' not migrated on server.");
                    helper.getCmsDriver().updateRepositoryStructure((IModelioProgress)mon.newChild(1), (MMetamodel)helper.getTempSession().getMetamodel());
                    helper.svnLockFiles((IModelioProgress)mon.newChild(1), helper.getFilesToLock(helper.getAllFiles(), this.data.initStatusSnap));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CmsDriverException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (MofMigrationException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (RuntimeException e) {
            this.getLogger().printStackTrace((Throwable)e);
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    private IMigrationReporter.IMigrationLogger getLogger() {
        return this.getMigrationReporter().getLogger();
    }

    protected void doClose() throws MigrationFailedException {
        this.data = null;
    }

    public void migrateModel(IModelioProgress monitor) throws MigrationFailedException, FragmentAuthenticationException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)15);
        try {
            if (!this.data.migratedOnServer) {
                this.migrateForServer(mon, this.data.serverFormatVersion);
            } else {
                this.migrateForLocallyModified(mon, this.data.initStatusSnap);
            }
            mon.setWorkRemaining(2);
            Throwable throwable = null;
            Object var4_8 = null;
            try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), -1), this.data.previousSvnhelper);){
                this.data.previousSvnhelper = helper;
                helper.rebuildIndexes((IModelioProgress)mon.newChild(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MofMigrationException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (RuntimeException e) {
            this.getLogger().printStackTrace((Throwable)e);
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    protected void doFinish(IModelioProgress monitor) throws MigrationFailedException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)3);
        super.doFinish((IModelioProgress)mon.newChild(1));
        if (!this.data.migratedOnServer) {
            try {
                Throwable throwable = null;
                Object var4_8 = null;
                try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1), 0), this.data.previousSvnhelper);){
                    this.data.previousSvnhelper = helper;
                    helper.writeAdminFiles();
                    helper.addFilesToCommit(this.data.formatMigrated);
                    helper.writeMetamodelDescriptor(this.getFinalMergedMmDescriptor(this.getMigrationReporter()));
                    helper.commit(this.data.initStatusSnap, (IModelioProgress)mon.newChild(1));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FragmentAuthenticationException e) {
                throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
            }
            catch (IOException e) {
                throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
            }
            catch (MofMigrationException e) {
                throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
            }
        }
    }

    protected List<IMigrationStepDescription> computeStepsDescription() {
        ArrayList<MigrationStepDescription> steps = super.computeStepsDescription();
        if (this.isFormatMigrationNeeded(this.localFormatVersion)) {
            steps = new ArrayList<MigrationStepDescription>(steps);
            steps.add(new MigrationStepDescription(ProjectSvn.I18N.getMessage("GSvnFragment.MigrationNeeded.RepositoryFormatNeedMigration", new Object[]{this.svnFragment.getId(), this.localFormatVersion, 3})));
        }
        return steps;
    }

    private static class AllowLocallyModifiedAccessManager
    implements IAccessManager {
        private final IStatusSnapshot statusSnap;

        public AllowLocallyModifiedAccessManager(IStatusSnapshot statusSnap) {
            this.statusSnap = statusSnap;
        }

        public void initStatus(SmObjectImpl obj, IModelLoader modelLoader) {
            if (obj.getMClass().isCmsNode()) {
                ICmsStatus stat = this.statusSnap.get(new MRef((MObject)obj));
                if (stat == null || stat.isSelfLocked() || stat.isConflicted() || stat.isToAdd() || stat.isModified()) {
                    modelLoader.setRStatus(obj, 4L, 512L, 0L);
                } else {
                    modelLoader.setRStatus(obj, 0L, 516L, 0L);
                }
            } else {
                modelLoader.setRStatus(obj, 0L, 512L, 4363686773760L);
            }
        }
    }

    private static class Data {
        boolean migratedOnServer;
        IStatusSnapshot initStatusSnap;
        RepositoryVersions serverFormatVersion;
        Collection<File> formatMigrated;
        SvnMigrationHelper previousSvnhelper;

        private Data() {
        }
    }

    private static final class RepoFormatMigrationNeededMigrator
    extends AbstractMofRepositoryMigrator {
        public RepoFormatMigrationNeededMigrator(MetamodelVersionDescriptor fromMetamodel, MetamodelVersionDescriptor targetMetamodel) {
            super(fromMetamodel, targetMetamodel);
        }
    }
}

