/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment.migration;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.fragment.migration.SvnMigrationHelper;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.MigrationFailedException;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.parts.IGModelFragmentMigrator;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.model.spi.mm.IMigrationStepDescription;
import org.modelio.vcore.model.spi.mm.IMofSession;
import org.modelio.vcore.model.spi.mm.MigrationStepDescription;
import org.modelio.vcore.model.spi.mm.MmVersionComparator;
import org.modelio.vcore.model.spi.mm.MofSession;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.session.impl.CoreSessionBuilder;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptor;

public class SaveMmVersionMigrator
implements IGModelFragmentMigrator,
IGModelFragmentMigrator.IMigrationProcess {
    private IGProject project;
    private GSvnFragment svnFragment;
    private IMigrationReporter reporter;
    private Data data;
    private List<IMigrationStepDescription> stepsDesc;

    public SaveMmVersionMigrator(IGProject project, GSvnFragment svnFragment, MetamodelVersionDescriptor srcMetamodel, MetamodelVersionDescriptor targetMetamodel) {
        this.project = project;
        this.svnFragment = svnFragment;
        this.stepsDesc = Collections.singletonList(new MigrationStepDescription(this.initStepsMessage(srcMetamodel, targetMetamodel)));
    }

    protected MofSession prepareMofSession(IModelioProgress monitor) throws FragmentAuthenticationException, IOException {
        CoreSession session = new CoreSessionBuilder().withMetamodel(this.project.getSession().getMetamodel()).forMetamodelMigration().build();
        boolean ok = false;
        try {
            CmsVersionedRepository toMigrate = this.svnFragment.instantiateRepository((ICoreSession)session, false);
            session.connectRepository((IRepository)toMigrate, (IAccessManager)new BasicAccessManager(), monitor);
            MofSession mofSession = new MofSession((ICoreSession)session, (IRepository)toMigrate, this.reporter);
            ok = true;
            MofSession mofSession2 = mofSession;
            return mofSession2;
        }
        finally {
            if (!ok) {
                session.close();
            }
        }
    }

    private String initStepsMessage(MetamodelVersionDescriptor srcMetamodel, MetamodelVersionDescriptor targetMetamodel) {
        MmVersionComparator vcomparator = MmVersionComparator.withSource((MetamodelVersionDescriptor)srcMetamodel).withTarget(targetMetamodel).withCommonRemoved();
        return ProjectSvn.I18N.getMessage("SaveMmVersionMigrator.detailMessage", new Object[]{this.svnFragment.getId(), vcomparator.getSource(), vcomparator.getTarget()});
    }

    public IGModelFragmentMigrator.IMigrationProcess start(IModelioProgress monitor, IMigrationReporter reporter) throws FragmentAuthenticationException, MigrationFailedException {
        this.reporter = reporter;
        String taskName = ProjectSvn.I18N.getMessage("RepositoryRegeneratorMigrator.mon.migration", new Object[]{this.svnFragment.getId()});
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)taskName, (int)5);
        mon.subTask(taskName);
        reporter.getLogger().println(taskName);
        reporter.getLogger().printf("Using '%s' migrator.\n", new Object[]{this.getClass().getName()});
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1)), this.svnFragment, reporter);){
                helper.getCmsDriver().cleanUpWorkingCopy((IModelioProgress)mon.newChild(1));
                helper.getCmsDriver().updateRepositoryStructure((IModelioProgress)mon.newChild(1), (MMetamodel)helper.getTempSession().getMetamodel());
                helper.getCmsDriver().updateAdmin((IModelioProgress)mon.newChild(1));
                this.data = new Data();
                this.data.migrationHelper = helper;
                this.data.serverMigrationNeeded = !helper.checkAlreadyMigrated(mon.newChild(1));
                return this;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            reporter.getLogger().printStackTrace((Throwable)e);
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (CmsDriverException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    public void migrateModel(IModelioProgress monitor) throws MigrationFailedException, FragmentAuthenticationException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1)), this.data.migrationHelper);){
                this.data.migrationHelper = helper;
                if (this.data.serverMigrationNeeded) {
                    this.reporter.getLogger().println("'" + this.svnFragment.getId() + "' not migrated on server.");
                    List<File> filesToLock = Collections.singletonList(helper.getMmVersionFile());
                    helper.svnLockFiles((IModelioProgress)mon.newChild(1), filesToLock);
                    this.reporter.getLogger().println("Got lock on '" + String.valueOf(helper.getMmVersionFile()) + "'.");
                    helper.writeAdminFiles();
                    MetamodelDescriptor finalMmDesc = this.svnFragment.getProject().getSession().getMetamodel().serialize();
                    helper.writeMetamodelDescriptor(finalMmDesc);
                } else {
                    this.reporter.getLogger().println("'" + this.svnFragment.getId() + "' model already migrated on server, nothing to do.");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            this.reporter.getLogger().printStackTrace((Throwable)e);
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (CmsDriverException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    public void finish(IModelioProgress monitor) throws MigrationFailedException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (SvnMigrationHelper helper = new SvnMigrationHelper((IMofSession)this.prepareMofSession((IModelioProgress)mon.newChild(1)), this.data.migrationHelper);){
                this.data.migrationHelper = helper;
                if (this.data.serverMigrationNeeded) {
                    helper.writeAdminFiles();
                    MetamodelDescriptor finalMmDesc = this.svnFragment.getProject().getSession().getMetamodel().serialize();
                    helper.writeMetamodelDescriptor(finalMmDesc);
                    helper.commit(null, (IModelioProgress)mon.newChild(1));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            this.reporter.getLogger().printStackTrace((Throwable)e);
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (FragmentAuthenticationException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    public void abort(IModelioProgress monitor) throws MigrationFailedException {
    }

    public void close() throws MigrationFailedException {
    }

    public String getRequiredUserActions() {
        return "";
    }

    public List<IMigrationStepDescription> getStepsDescription() {
        return this.stepsDesc;
    }

    private static class Data {
        boolean serverMigrationNeeded;
        SvnMigrationHelper migrationHelper;

        private Data() {
        }
    }
}

