/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment.migration;

import com.modeliosoft.modelio.cms.api.CmsUnlockException;
import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.api.OutdatedElementsException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.cms.driver.parse.CmsNodeStruct;
import com.modeliosoft.modelio.cms.driver.parse.StructureSnapshot;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.engine.SymbolService;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.SorterByName;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.modelio.gproject.MigrationFailedException;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.model.spi.mm.IMofSession;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptorWriter;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelFragmentDescriptor;
import org.modelio.vstore.exml.common.RepositoryVersions;

class SvnMigrationHelper
implements Closeable {
    private final ICmsDriver tempCmsDriver;
    private final Path mmVersionPath;
    private final IMigrationReporter reporter;
    private final GSvnFragment svnFragment;
    private final SmMetamodel targetMetamodel;
    private final MetamodelVersionDescriptor targetMmDesc;
    private final ICoreSession tempSession;
    private CmsVersionedRepository tempSvnRepository;
    private final Collection<File> toCommit;

    public SvnMigrationHelper(IMofSession mofSession, GSvnFragment svnFragment, IMigrationReporter reporter) {
        this.svnFragment = svnFragment;
        this.reporter = reporter;
        this.mmVersionPath = svnFragment.getMmVersionPath();
        this.targetMetamodel = svnFragment.getProject().getSession().getMetamodel();
        this.targetMmDesc = VersionHelper.getDescriptors((MMetamodel)this.targetMetamodel);
        this.tempSession = mofSession.getCoreSession();
        this.tempSvnRepository = (CmsVersionedRepository)mofSession.getTargetRepository();
        this.tempCmsDriver = this.tempSvnRepository.getDriver();
        this.toCommit = new ArrayList<File>();
    }

    public final boolean checkAlreadyMigrated(SubProgress mon) throws CmsDriverException, IOException {
        File versionFile = this.getMmVersionFile();
        if (!versionFile.isFile()) {
            this.getMigrationReporter().getLogger().println("No metamodel version file for " + this.svnFragment.getId() + " fragment.");
            return false;
        }
        ICmsStatus stat = this.tempCmsDriver.getStatusDriver().getStatus(versionFile, false);
        if (!stat.isVersioned()) {
            this.getMigrationReporter().getLogger().println("Metamodel version file for " + this.svnFragment.getId() + " fragment not versioned, previous migration probably interrupted.");
            return false;
        }
        if (stat.isToAdd()) {
            this.getMigrationReporter().getLogger().println("Metamodel version file for " + this.svnFragment.getId() + " fragment already scheduled for add, previous migration probably interrupted.");
            this.tempCmsDriver.revert((IModelioProgress)mon, Collections.singleton(versionFile));
            return false;
        }
        if (stat.isConflicted() || stat.isModified()) {
            this.getMigrationReporter().getLogger().println("Metamodel version file for " + this.svnFragment.getId() + " fragment locally modified, previous migration probably interrupted.");
            this.tempCmsDriver.revert((IModelioProgress)mon, Collections.singleton(versionFile));
        }
        MetamodelVersionDescriptor fragmentMetamodelDesc = this.svnFragment.getRequiredMetamodelDescriptor();
        this.getMigrationReporter().getLogger().printf("Metamodels:\n", new Object[0]);
        this.getMigrationReporter().getLogger().printf("  - on working copy: %s\n", new Object[]{fragmentMetamodelDesc});
        this.getMigrationReporter().getLogger().printf("  - target       : %s\n", new Object[]{this.targetMmDesc});
        return fragmentMetamodelDesc.isSame(this.targetMmDesc);
    }

    public String checkLocalModelState(IModelioProgress aMonitor) throws CmsDriverException {
        int hasConflicts = 0;
        int hasLocalModifs = 0;
        StringBuilder sb = new StringBuilder();
        String taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.checkModelState", new Object[]{this.svnFragment.getId()});
        aMonitor.subTask(taskName);
        this.getMigrationReporter().getLogger().println(taskName);
        IStatusSnapshot snap = this.tempCmsDriver.getStatusDriver().getStatusSnapShot(aMonitor, false);
        for (Map.Entry<File, ICmsStatus> r : snap.getAllFiles().entrySet()) {
            ICmsStatus status = r.getValue();
            if (status.isConflicted()) {
                ++hasConflicts;
                sb.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.checkModel.el.conflicted", new Object[]{r.getKey()}));
                sb.append('\n');
                continue;
            }
            if (!status.isModified() || status.isSelfLocked()) continue;
            ++hasLocalModifs;
            sb.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.checkModel.el.modified", new Object[]{r.getKey()}));
            sb.append('\n');
        }
        if (hasConflicts == 0 && hasLocalModifs == 0) {
            return "";
        }
        sb.insert(0, ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.checkModel.title", new Object[0]) + "\n\n");
        sb.append("\n\n");
        sb.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.checkModel.resume", new Object[0]));
        sb.append('\n');
        if (hasConflicts > 0) {
            sb.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.checkModel.resume.conflicts", new Object[]{hasConflicts}));
            sb.append('\n');
        }
        if (hasLocalModifs > 0) {
            sb.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.checkModel.resume.localModifs", new Object[]{hasLocalModifs}));
            sb.append('\n');
        }
        this.getMigrationReporter().getLogger().println(sb.toString());
        this.getMigrationReporter().getResultReporter().println(sb.toString());
        return sb.toString();
    }

    @Override
    public void close() {
        this.tempSession.close();
    }

    public void commit(IStatusSnapshot initialSnap, IModelioProgress aMonitor) throws MigrationFailedException {
        try {
            IMigrationReporter.IMigrationLogger logger = this.reporter.getLogger();
            SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)6);
            String msg = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.prepareCommit", new Object[]{this.svnFragment.getId()});
            mon.subTask(msg);
            logger.println(msg);
            HashSet<File> filesToCommit = new HashSet<File>(this.toCommit);
            HashSet<File> filesToRevert = new HashSet<File>();
            HashSet<File> filesToDelete = new HashSet<File>();
            ICmsDriver lcmsDriver = this.getCmsDriver();
            ICmsFilesGetter filesGetter = lcmsDriver.getFilesGetter();
            List<File> adminFiles = Arrays.asList(this.getMmVersionFile(), this.getRepositoryFormatVersionFile(), this.getMetamodelDescriptorFile());
            filesToCommit.addAll(adminFiles);
            for (File f : adminFiles) {
                ICmsStatus iCmsStatus = lcmsDriver.getStatusDriver().getStatus(f, false);
                if (iCmsStatus != null && iCmsStatus.isVersioned()) continue;
                lcmsDriver.addFile(f);
                logger.println("  + Adding '" + String.valueOf(f) + "' to version.");
            }
            mon.worked(1);
            if (initialSnap != null) {
                IStatusSnapshot newStatusSnap = lcmsDriver.getStatusDriver().getStatusSnapShot((IModelioProgress)mon.newChild(1), false);
                Iterator newStructSnapshot = lcmsDriver.getStructureSnapshot();
                for (Map.Entry<File, ICmsStatus> entry : newStatusSnap.getAllFiles().entrySet()) {
                    ICmsStatus newStatus = entry.getValue();
                    File f = entry.getKey();
                    boolean missing = false;
                    if (newStatus == null) {
                        missing = true;
                    } else if (newStatus.isModified() || newStatus.isToAdd()) {
                        filesToCommit.add(f);
                        filesToCommit.add(f.getParentFile());
                        logger.printf("  # Adding '%s' to commit (%s).\n", new Object[]{f, newStatus});
                    } else if (newStatus.isToDelete()) {
                        filesToCommit.add(f);
                        filesToDelete.add(f);
                        logger.printf("  # Adding '%s' removal to commit (%s).\n", new Object[]{f, newStatus});
                    } else if (newStatus.isSelfLocked()) {
                        ICmsStatus oldStatus = initialSnap.get(f);
                        if (oldStatus == null || !oldStatus.isSelfLocked()) {
                            logger.printf("  # Adding newly locked '%s' to commit (%s).\n", new Object[]{f, newStatus});
                            filesToCommit.add(f);
                        } else {
                            logger.printf("  . ignore '%s' already self locked before migration (%s).\n", new Object[]{f, newStatus});
                        }
                    } else if (newStatus.isConflicted()) {
                        logger.println("   . ignore conflicted '" + String.valueOf(f) + "' .");
                    } else if (!newStatus.isVersioned()) {
                        missing = true;
                    }
                    if (!missing) continue;
                    MRef ref = this.tempCmsDriver.getFilesGeometry().getObRef(f);
                    if (ref == null || this.isToBeAdded(ref, initialSnap, (StructureSnapshot)((Object)newStructSnapshot))) {
                        for (File f2 : filesGetter.getRelatedRefFiles(ref)) {
                            logger.println("  + Adding '" + String.valueOf(f2) + "' to version for '" + String.valueOf(ref) + "'.");
                            lcmsDriver.addFile(f2);
                            filesToCommit.add(f2);
                            filesToCommit.add(f2.getParentFile());
                        }
                        continue;
                    }
                    logger.println("   . ignore non versioned '" + String.valueOf(f) + "' .");
                }
                logger.println("  Computing files to be removed from version because of metaclass CMS node status loss:");
                for (Map.Entry<File, ICmsStatus> entry : initialSnap.getAll().entrySet()) {
                    MRef ref = (MRef)entry.getKey();
                    if (this.targetMetamodel.getMClass(ref.mc) != null) continue;
                    Collection<File> todel = filesGetter.getRelatedRefFiles(ref);
                    for (File f : todel) {
                        ICmsStatus cmsStatus = newStatusSnap.get(f);
                        if (cmsStatus != null) {
                            if (cmsStatus.isToAdd()) {
                                logger.printf("    - '%s'(%s) addition is to revert\n", new Object[]{f, ref});
                                filesToRevert.add(f);
                            } else if (cmsStatus.isVersioned() && !cmsStatus.isToDelete()) {
                                logger.printf("   - '%s'(%s) is to delete & remove from version\n", new Object[]{f, ref});
                                lcmsDriver.delete(f);
                                filesToCommit.add(f);
                            }
                        } else {
                            logger.printf("    - non versioned '%s' is to delete (%s)\n", new Object[]{f, ref});
                        }
                        filesToDelete.add(f);
                    }
                }
            }
            if (!filesToRevert.isEmpty()) {
                logger.printf(" Reverting %d files ...\n", new Object[]{filesToRevert.size()});
                lcmsDriver.revert((IModelioProgress)mon.newChild(1), filesToRevert);
            }
            if (!filesToDelete.isEmpty()) {
                logger.printf(" Deleting %d files ...\n", new Object[]{filesToDelete.size()});
                for (File f : SvnMigrationHelper.sortFilesToDelete(filesToDelete)) {
                    Files.deleteIfExists(f.toPath());
                }
            }
            this.deleteObsoleteDirectories(mon.newChild(2), filesToCommit);
            logger.println("\nCommitting " + filesToCommit.size() + " files to " + this.svnFragment.getId() + " repository...");
            for (File f : filesToCommit) {
                logger.println("    - " + String.valueOf(f));
            }
            mon.subTask(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.committing", new Object[]{this.svnFragment.getId(), filesToCommit.size()}));
            String commitComment = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.commitComment", new Object[]{this.svnFragment.getRequiredMetamodelDescriptor(), this.targetMmDesc});
            ICmsCommitResult commitres = lcmsDriver.commit((IModelioProgress)mon.newChild(2), filesToCommit, false, commitComment);
            this.reportCommitResult(commitres);
        }
        catch (CmsDriverException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (OutdatedElementsException e) {
            ProjectSvn.LOG.error(e);
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    public static MigrationFailedException convertException(String fragName, Throwable t) {
        try {
            throw t;
        }
        catch (CmsDriverException e) {
            return SvnMigrationHelper.convertException(fragName, e);
        }
        catch (IOException e) {
            return SvnMigrationHelper.convertException(fragName, e);
        }
        catch (OutdatedElementsException e) {
            ProjectSvn.LOG.error(e);
            return new MigrationFailedException(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.MigrationFailed.OutdatedElementsException", new Object[]{fragName, e.getLocalizedMessage()}), (Throwable)e);
        }
        catch (Throwable e) {
            return new MigrationFailedException(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.MigrationFailed", new Object[]{fragName, e.toString()}), e);
        }
    }

    public static MigrationFailedException convertException(String fragName, CmsDriverException e) {
        return new MigrationFailedException(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.MigrationFailed", new Object[]{fragName, e.getLocalizedMessage()}), (Throwable)((Object)e));
    }

    public static MigrationFailedException convertException(String fragName, IOException e) {
        return new MigrationFailedException(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.MigrationFailed", new Object[]{fragName, FileUtils.getLocalizedMessage((IOException)e)}), (Throwable)e);
    }

    public Collection<File> getAllFiles() throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        File modelDir = this.tempSvnRepository.getDriver().getFilesGeometry().getModelDirectory();
        Files.walkFileTree(modelDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toFile());
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    public ICmsDriver getCmsDriver() {
        return this.tempCmsDriver;
    }

    public Collection<File> getFilesToLock(Collection<File> allFiles, IStatusSnapshot initStatusSnap) {
        ArrayList<File> filesToLock = new ArrayList<File>(allFiles.size());
        for (File f : allFiles) {
            ICmsStatus stat = initStatusSnap.get(f);
            if (stat == null || !stat.isVersioned() || stat.isSelfLocked()) continue;
            filesToLock.add(f);
        }
        return filesToLock;
    }

    public File getMmVersionFile() {
        return this.mmVersionPath.toFile();
    }

    public ICoreSession getTempSession() {
        return this.tempSession;
    }

    public void rebuildIndexes(IModelioProgress aMonitor) throws MigrationFailedException {
        this.reporter.getLogger().println("Rebuilding '" + this.svnFragment.getId() + "' indexes...");
        try {
            this.tempSvnRepository.getMaintenance().rebuildIndexes(aMonitor);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    public final void svnLockFiles(IModelioProgress aMonitor, Collection<File> filesToLock) throws CmsDriverException, IOException {
        String lockComment = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.lockComment", new Object[]{this.svnFragment.getRequiredMetamodelDescriptor(), this.targetMmDesc});
        this.getMigrationReporter().getLogger().println("Getting " + filesToLock.size() + " locks on " + this.svnFragment.getId() + " ");
        ICmsLockResult lockRes = this.tempCmsDriver.lock(aMonitor, filesToLock, true, lockComment);
        String sb = this.compileLockFailures(lockRes);
        if (!sb.isEmpty()) {
            throw new CmsDriverException(sb.toString());
        }
        this.getMigrationReporter().getLogger().println(sb);
        this.getMigrationReporter().getResultReporter().println(sb);
        this.getMigrationReporter().getLogger().println("Got all locks on '" + this.svnFragment.getId() + "'.");
    }

    public void updateWorkingCopy(IModelioProgress aMonitor) throws CmsDriverException {
        String taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.updateModelFiles", new Object[]{this.svnFragment.getId()});
        aMonitor.subTask(taskName);
        IMigrationReporter.IMigrationLogger logger = this.getMigrationReporter().getLogger();
        logger.println(taskName);
        ICmsUpdateResult ur = this.tempCmsDriver.updateModel(aMonitor, Collections.emptyList(), null);
        if (ur.getIncompleteUpdateCause() != null) {
            throw new CmsDriverException(ur.getIncompleteUpdateCause().getLocalizedMessage(), ur.getIncompleteUpdateCause());
        }
        if (!ur.getConflictedBlobs().isEmpty()) {
            logger.println("WARN: The following blobs are now conflicted:");
            for (String blob : ur.getConflictedBlobs()) {
                logger.println("WARN:  - " + blob);
            }
        }
        if (!ur.getConflictedElements().isEmpty()) {
            logger.println("WARN: The following elements are now conflicted:");
            for (MRef ref : ur.getConflictedElements()) {
                logger.printf("WARN:  - %s in '%s'", new Object[]{ref, this.tempCmsDriver.getFilesGeometry().getExmlFile(ref)});
            }
        }
        if (!ur.getConflictedOtherFiles().isEmpty()) {
            logger.println("WARN: The following files are now conflicted:");
            for (File f : ur.getConflictedOtherFiles()) {
                logger.println("WARN:  - " + String.valueOf(f));
            }
        }
    }

    public void writeAdminFiles() throws MigrationFailedException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter out = Files.newBufferedWriter(this.mmVersionPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.targetMmDesc.write((Writer)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.tempSvnRepository.getMaintenance().writeFormatVersion();
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    protected File getRepositoryFormatVersionFile() {
        return this.svnFragment.getDataDirectory().resolve("admin/format_version.dat").toFile();
    }

    private String compileLockFailures(ICmsLockResult lockResult) {
        ArrayList<IRefResultEntry> lockFailures;
        Collection<MRef> lockedRefs;
        StringBuilder content = new StringBuilder();
        ICoreSession session = this.getTempSession();
        final SymbolService symbolService = new SymbolService(session.getModel());
        Collection<MRef> outdatedRefs = lockResult.getOutdatedElements();
        if (!outdatedRefs.isEmpty()) {
            content.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.SomebodyStillWorking.outdated", new Object[]{outdatedRefs.size()}));
            content.append('\n');
            for (MRef ref : new SorterByName(symbolService).getSortedRefsByName(outdatedRefs)) {
                content.append(" - ");
                content.append(symbolService.getFullName(ref));
                content.append('\n');
            }
            content.append('\n');
        }
        if (!(lockedRefs = lockResult.getAlreadyLockedElements()).isEmpty()) {
            content.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.SomebodyStillWorking.locked", new Object[]{lockedRefs.size()}));
            content.append('\n');
            for (MRef ref : new SorterByName(symbolService).getSortedRefsByName(lockedRefs)) {
                content.append(" - ");
                content.append(symbolService.getFullName(ref));
                content.append('\n');
            }
            content.append('\n');
        }
        if (!(lockFailures = new ArrayList<IRefResultEntry>(lockResult.getLockFailures())).isEmpty()) {
            content.append(ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.LockFailures", new Object[]{lockFailures.size()}));
            content.append('\n');
            Comparator<IRefResultEntry> c = new Comparator<IRefResultEntry>(){

                @Override
                public int compare(IRefResultEntry o1, IRefResultEntry o2) {
                    String n1 = symbolService.getFullName(o1.getRef());
                    String n2 = symbolService.getFullName(o2.getRef());
                    return n1.compareTo(n2);
                }
            };
            Collections.sort(lockFailures, c);
            for (IRefResultEntry entry : lockFailures) {
                content.append(" - ");
                content.append(symbolService.getFullName(entry.getRef()));
                content.append(" : ");
                content.append(entry.getMessage());
                content.append('\n');
            }
        }
        return content.toString();
    }

    private IMigrationReporter getMigrationReporter() {
        return this.reporter;
    }

    private boolean isToBeAdded(MRef ref, IStatusSnapshot initialSnap, StructureSnapshot newStructSnapshot) throws IOException {
        ICmsStatus oldS = initialSnap.get(ref);
        if (oldS != null && oldS.isVersioned()) {
            this.reporter.getLogger().println("     " + String.valueOf(ref) + " was versioned before but not anymore, adding back to version.");
            return true;
        }
        CmsNodeStruct nodeStruct = newStructSnapshot.getNode(ref);
        if (nodeStruct == null) {
            this.reporter.getLogger().println("   WARNING:" + String.valueOf(ref) + " not found in new structure snapshot.");
            return true;
        }
        MRef parentRef = nodeStruct.getParent();
        ICmsStatus parentStat = initialSnap.get(parentRef);
        if (parentStat == null) {
            this.reporter.getLogger().println("   WARNING:" + String.valueOf(parentRef) + " parent of " + String.valueOf(ref) + " not found in new structure snapshot, is it a root?");
            return true;
        }
        if (parentStat.isVersioned()) {
            this.reporter.getLogger().println("     adding " + String.valueOf(ref) + " to version because its parent " + String.valueOf(parentRef) + " is versioned.");
            return true;
        }
        this.reporter.getLogger().println("   Keeping '" + String.valueOf(ref) + "' unversioned because " + String.valueOf(parentRef) + " is not versioned either.");
        return false;
    }

    private void reportCommitResult(ICmsCommitResult commitres) {
        ICmsUnlockResult unlockResult = commitres.getUnlockResult();
        if (unlockResult != null && unlockResult.hasFailures()) {
            CmsUnlockException e2 = new CmsUnlockException(unlockResult);
            this.reporter.getLogger().printStackTrace((Throwable)e2);
            this.svnFragment.getProject().getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)((Object)this.svnFragment), (Throwable)e2));
        }
        if (commitres.isEmpty()) {
            this.reporter.getLogger().println("Migration of " + this.svnFragment.getId() + " committed to repository but no change.");
        } else {
            this.reporter.getLogger().println("Migration of " + this.svnFragment.getId() + " committed to repository to rev " + commitres.getRevision());
        }
    }

    public RepositoryVersions getRepositoryFormatVersion() throws IOException {
        return this.tempSvnRepository.getResourceProvider().readRepositoryVersion();
    }

    public void addFilesToCommit(Collection<File> files) {
        this.toCommit.addAll(files);
    }

    protected File getMetamodelDescriptorFile() {
        return this.svnFragment.getDataDirectory().resolve("admin/metamodel_descriptor.xml").toFile();
    }

    public void writeMetamodelDescriptor(MetamodelDescriptor metamodelDesc) throws IOException {
        this.tempSvnRepository.getMetamodelDescriptor().ifPresent(md -> {
            for (MetamodelFragmentDescriptor fd : md.getFragments().values()) {
                if (!fd.isFake()) continue;
                metamodelDesc.getFragments().putIfAbsent(fd.getName(), fd);
            }
        });
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = this.tempSvnRepository.getResourceProvider().getMetamodelDescriptorResource().bufferedWrite();){
            new MetamodelDescriptorWriter().write(metamodelDesc, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteObsoleteDirectories(SubProgress mon, Collection<File> filesToCommit) throws MigrationFailedException {
        Path modelDir = this.tempSvnRepository.getLowLevelDriver().getFilesGeometry().getModelDirectory().toPath();
        Collection allowedDirs = this.tempSvnRepository.getLowLevelDriver().getFilesGeometry().getInitialDirectories((MMetamodel)this.targetMetamodel);
        ArrayList<File> toDelete = new ArrayList<File>();
        ArrayList<File> toRemove = new ArrayList<File>();
        ArrayList<File> toRevert = new ArrayList<File>();
        try {
            List obsoleteDirs;
            Object ds;
            String taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.obsoleteDirs.check", new Object[]{this.svnFragment.getId()});
            mon.subTask(taskName);
            mon.setWorkRemaining(6);
            this.reporter.getLogger().println(taskName);
            Throwable throwable = null;
            Iterator<Object> iterator = null;
            try {
                ds = Files.list(modelDir);
                try {
                    obsoleteDirs = ds.filter(d -> !allowedDirs.contains(d.toFile())).collect(Collectors.toList());
                }
                finally {
                    if (ds != null) {
                        ds.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (obsoleteDirs.isEmpty()) {
                return;
            }
            mon.worked(1);
            for (Path obsoletePath : obsoleteDirs) {
                ds = null;
                Object var13_19 = null;
                try (Stream<Path> ds2 = Files.list(obsoletePath);){
                    String presentFiles = ds2.map(p -> String.format("    - %s , status=%s", p, this.getStatusString((Path)p))).collect(Collectors.joining("\n", "", ""));
                    if (!presentFiles.isEmpty()) {
                        this.reporter.getLogger().printf("  . The '%s' directory is not empty.:\n", new Object[]{obsoletePath});
                        this.reporter.getLogger().println(presentFiles);
                        continue;
                    }
                    File obsoleteDir = obsoletePath.toFile();
                    ICmsStatus stat = this.tempCmsDriver.getStatusDriver().getStatus(obsoleteDir, false);
                    if (stat.isToAdd()) {
                        this.reporter.getLogger().printf("  - '%s' directory in added state, to revert.\n", new Object[]{obsoletePath});
                        toRevert.add(obsoleteDir);
                        filesToCommit.remove(obsoleteDir);
                        continue;
                    }
                    if (stat.isConflicted()) {
                        this.reporter.getLogger().printf("  - '%s' directory in conflicted state, to revert then remove.\n", new Object[]{obsoletePath});
                        toRevert.add(obsoleteDir);
                        toRemove.add(obsoleteDir);
                        continue;
                    }
                    if (stat.isVersioned()) {
                        this.reporter.getLogger().printf("  - '%s' directory versioned, to remove.\n", new Object[]{obsoletePath});
                        toRemove.add(obsoleteDir);
                        continue;
                    }
                    this.reporter.getLogger().printf("  - '%s' directory not versioned, to delete from file system.\n", new Object[]{obsoletePath});
                    toDelete.add(obsoleteDir);
                    filesToCommit.remove(obsoleteDir);
                }
                catch (Throwable throwable3) {
                    if (ds == null) {
                        ds = throwable3;
                    } else if (ds != throwable3) {
                        ((Throwable)ds).addSuppressed(throwable3);
                    }
                    throw ds;
                }
            }
            mon.worked(1);
            if (!toRevert.isEmpty()) {
                taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.obsoleteDirs.revert", new Object[]{this.svnFragment.getId(), toRevert.size()});
                mon.subTask(taskName);
                this.reporter.getLogger().println(taskName);
                this.tempCmsDriver.revert((IModelioProgress)mon.newChild(1), toRevert);
            }
            if (!toRemove.isEmpty()) {
                mon.setWorkRemaining(3);
                taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.obsoleteDirs.remove", new Object[]{this.svnFragment.getId(), toRemove.size()});
                mon.subTask(taskName);
                this.reporter.getLogger().println(taskName);
                this.tempCmsDriver.delete((IModelioProgress)mon.newChild(1), toRemove);
                filesToCommit.addAll(toRemove);
            }
            if (!toDelete.isEmpty()) {
                taskName = ProjectSvn.I18N.getMessage("ChainedSvnFragmentMigrator.mon.obsoleteDirs.delete", new Object[]{this.svnFragment.getId(), toDelete.size()});
                mon.subTask(taskName);
                this.reporter.getLogger().println(taskName);
                for (File file : toDelete) {
                    try {
                        Files.deleteIfExists(file.toPath());
                    }
                    catch (IOException e) {
                        this.reporter.getLogger().printf("   - Couldn't delete '%s' directory: %s\n", new Object[]{file, FileUtils.getLocalizedMessage((IOException)e)});
                    }
                }
            }
        }
        catch (CmsDriverException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
        catch (IOException e) {
            throw SvnMigrationHelper.convertException(this.svnFragment.getId(), e);
        }
    }

    private String getStatusString(Path p) {
        try {
            return this.tempCmsDriver.getStatusDriver().getStatus(p.toFile(), false).toString();
        }
        catch (CmsDriverException e) {
            return e.getLocalizedMessage();
        }
    }

    private static List<File> sortFilesToDelete(Collection<File> filesToDelete) {
        ArrayList<File> sortedToDelete = new ArrayList<File>(filesToDelete);
        Collections.sort(sortedToDelete, (a, b) -> {
            boolean aIsDir = a.isDirectory();
            boolean bIsDir = b.isDirectory();
            if (aIsDir && !bIsDir) {
                return 1;
            }
            if (bIsDir && !aIsDir) {
                return -1;
            }
            int ret = a.toPath().getNameCount() - b.toPath().getNameCount();
            if (ret != 0) {
                return ret;
            }
            return b.compareTo((File)a);
        });
        return sortedToDelete;
    }

    public SvnMigrationHelper(IMofSession mofSession, SvnMigrationHelper other) {
        this.svnFragment = other.svnFragment;
        this.reporter = other.reporter;
        this.mmVersionPath = this.svnFragment.getMmVersionPath();
        this.targetMetamodel = this.svnFragment.getProject().getSession().getMetamodel();
        this.targetMmDesc = VersionHelper.getDescriptors((MMetamodel)this.targetMetamodel);
        this.tempSession = mofSession.getCoreSession();
        this.tempSvnRepository = (CmsVersionedRepository)mofSession.getTargetRepository();
        this.tempCmsDriver = this.tempSvnRepository.getDriver();
        this.toCommit = new ArrayList<File>(other.toCommit);
    }

    public Optional<MetamodelDescriptor> readMetamodelDescriptor() {
        return this.tempSvnRepository.getMetamodelDescriptor();
    }

    public boolean isMigratedOnServer() throws CmsDriverException, IOException {
        File versionFile = this.getMmVersionFile();
        ByteArrayOutputStream dst = new ByteArrayOutputStream();
        this.tempCmsDriver.getFileContent(versionFile, dst, "HEAD");
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(dst.toByteArray()), StandardCharsets.UTF_8);
        MetamodelVersionDescriptor fragmentMetamodelDesc = new MetamodelVersionDescriptor((Reader)reader);
        this.getMigrationReporter().getLogger().printf("Metamodels on server:\n", new Object[0]);
        this.getMigrationReporter().getLogger().printf("  - on repository: %s\n", new Object[]{fragmentMetamodelDesc});
        this.getMigrationReporter().getLogger().printf("  - target       : %s\n", new Object[]{this.targetMmDesc});
        return fragmentMetamodelDesc.isSame(this.targetMmDesc);
    }
}

