/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment.migration;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.resource.migration.RepositoryFormatMigrator;

public class SvnRepositoryFormatMigrator
extends RepositoryFormatMigrator {
    private final ICmsDriver driver;
    private final Collection<File> toCommit = new HashSet<File>();
    private Collection<File> filesToRevert = new HashSet<File>();

    public SvnRepositoryFormatMigrator(Path repositoryPath, MMetamodel metamodel, ICmsDriver driver, IMigrationReporter reporter, int sourceFormat, int targetFormat) throws IOException {
        super(repositoryPath, metamodel, reporter, sourceFormat, targetFormat);
        this.driver = driver;
    }

    public Collection<File> getFilesToCommit() {
        return this.toCommit;
    }

    protected void createNewDirectory(Path newDir) throws IOException {
        super.createNewDirectory(newDir);
        try {
            this.getLogger().printf("  Adding '%s' to version.\n", new Object[]{newDir});
            this.driver.addFile(newDir.toFile());
        }
        catch (CmsDriverException e) {
            throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
        this.toCommit.add(newDir.toFile());
    }

    protected boolean deleteDirectory(Path oldDir) throws IOException {
        ICmsStatus status;
        File oldFile;
        block10: {
            block9: {
                oldFile = oldDir.toFile();
                if (!oldFile.exists()) {
                    return false;
                }
                status = null;
                try {
                    status = this.driver.getStatusDriver().getStatus(oldFile, false);
                    if (super.deleteDirectory(oldDir)) break block9;
                    return false;
                }
                catch (CmsDriverException e) {
                    throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
                }
            }
            if (status != null) break block10;
            this.getLogger().printf("  '%s' was not versioned, nothing more to do.\n", new Object[]{oldDir, status});
            return true;
        }
        if (status.isVersioned()) {
            this.getLogger().printf("  Removing '%s' from version (svn status=%s).\n", new Object[]{oldDir, status});
            this.driver.delete(oldFile);
            this.toCommit.add(oldFile);
        } else if (status.isToAdd()) {
            this.getLogger().printf("  Reverting '%s' add to version (svn status=%s).\n", new Object[]{oldDir, status});
            this.driver.revert(null, Collections.singleton(oldFile));
        } else {
            this.getLogger().printf("  No SVN op needed for '%s' (svn status=%s).\n", new Object[]{oldDir, status});
        }
        return true;
    }

    protected void fileModified(Path modifiedFile) throws IOException {
        try {
            ICmsStatus status = this.driver.getStatusDriver().getStatus(modifiedFile.toFile(), false);
            if (this.willBeVersioned(status)) {
                SvnRepositoryFormatMigrator.assertFile(modifiedFile.toString());
                this.toCommit.add(modifiedFile.toFile());
            }
        }
        catch (CmsDriverException e) {
            throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    protected void moveFile(Path fromPath, Path targetPath) throws IOException {
        Path relFromPath = this.getRepositoryPath().relativize(fromPath);
        Path relTargetPath = this.getRepositoryPath().relativize(targetPath);
        this.getLogger().printf("  Moving \n\t'%s' \n\tto '%s'.\n", new Object[]{relFromPath, relTargetPath});
        try {
            File fromFile = fromPath.toFile();
            File targetFile = targetPath.toFile();
            ICmsStatus fromStatus = this.driver.getStatusDriver().getStatus(fromFile, false);
            ICmsStatus toStatus = this.driver.getStatusDriver().getStatus(targetFile, false);
            boolean targetExists = this.willBeVersioned(toStatus);
            boolean commitSrc = fromStatus != null && fromStatus.isVersioned();
            boolean commitTarget = this.willBeVersioned(fromStatus);
            boolean localExml = SvnRepositoryFormatMigrator.isLocalExmlFile(fromFile.getPath()) || SvnRepositoryFormatMigrator.isLocalExmlFile(targetFile.getPath());
            this.getLogger().printf("    '%s' status was: %s, %s.\n", new Object[]{relFromPath, fromStatus, commitSrc ? "to commit" : "don't commit"});
            this.getLogger().printf("     '%s' status was: %s, %s.\n", new Object[]{relTargetPath, toStatus, commitTarget ? "to commit" : "don't commit"});
            if (!targetExists && (commitSrc || commitTarget)) {
                if (localExml) {
                    if (commitSrc) {
                        this.getReporter().getResultReporter().printf("   Removing from version '%s' that should never have been versioned !\n", new Object[]{relFromPath});
                        this.getReporter().getLogger().printf("   Removing from version '%s' that should never have been versioned !\n", new Object[]{relFromPath});
                        Log.warning((String)"   Removing from version '%s' that should never have been versioned !\n", (Object[])new Object[]{relFromPath});
                        this.driver.delete(fromFile);
                        this.toCommit.add(fromFile);
                    }
                    if (targetExists) {
                        this.getReporter().getResultReporter().printf("   Removing from version '%s' that should never have been versioned !\n", new Object[]{relTargetPath});
                        this.getReporter().getLogger().printf("   Removing from version '%s' that should never have been versioned !\n", new Object[]{relTargetPath});
                        Log.warning((String)"   Removing from version '%s' that should never have been versioned !\n", (Object[])new Object[]{relTargetPath});
                        this.driver.delete(targetFile);
                        this.toCommit.add(targetFile);
                    }
                    super.moveFile(fromPath, targetPath);
                } else {
                    this.driver.moveFile(fromFile, targetFile, true);
                    if (commitSrc) {
                        SvnRepositoryFormatMigrator.assertFile(fromFile.toString());
                        this.toCommit.add(fromFile);
                    }
                    if (commitTarget) {
                        SvnRepositoryFormatMigrator.assertFile(targetFile.toString());
                        this.toCommit.add(targetFile);
                    }
                }
            } else {
                super.moveFile(fromPath, targetPath);
            }
            if (Files.exists(fromPath, new LinkOption[0])) {
                throw new FileSystemException(fromPath.toString(), null, "The file should be deleted.");
            }
            if (!Files.exists(targetPath, new LinkOption[0])) {
                throw new FileSystemException(targetPath.toString(), null, String.format("The '%s' file should have moved here.", fromPath));
            }
        }
        catch (CmsDriverException e) {
            throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    private boolean willBeVersioned(ICmsStatus svnStatus) {
        return svnStatus != null && (svnStatus.isVersioned() && !svnStatus.isToDelete() || svnStatus.isToAdd());
    }

    private static boolean assertFile(String f) {
        assert (!SvnRepositoryFormatMigrator.isLocalExmlFile(f)) : f;
        return true;
    }

    private static boolean isLocalExmlFile(String f) {
        return f.endsWith(".local.exml");
    }
}

