/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment.recorder;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;

public class FragmentRemovalHistory {
    private final Set<MRef> removals = new HashSet<MRef>(5);
    private final Path storageDir;
    private final CmsVersionedRepository repository;

    public FragmentRemovalHistory(CmsVersionedRepository repo, Path storageDir) {
        this.repository = repo;
        this.storageDir = storageDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean load(String expectedStamp) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = Files.newBufferedReader(this.getFilePath(), StandardCharsets.UTF_8);){
            String readStamp = r.readLine();
            if (!Objects.equals(expectedStamp, readStamp)) {
                Log.warning((String)"%s: Invalid stamp on '%s' repository: expected '%s', read '%s'", (Object[])new Object[]{this.getClass().getSimpleName(), this.getRepositoryName(), expectedStamp, readStamp});
                return false;
            }
            String l = r.readLine();
            while (true) {
                if (l == null) {
                    return true;
                }
                MRef k = new MRef(l);
                this.removals.add(k);
                l = r.readLine();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private String getRepositoryName() {
        return this.repository.getResourceProvider().getName();
    }

    private void rebuild(IModelioProgress aMonitor, String expectedStamp) throws CmsDriverException, IOException {
        SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)2);
        ICmsDriver cmsDriver = this.repository.getDriver();
        IStatusSnapshot statusSnapShot = cmsDriver.getStatusDriver().getStatusSnapShot((IModelioProgress)mon.newChild(1), false);
        mon.setWorkRemaining(statusSnapShot.getAll().size());
        for (Map.Entry<MRef, ICmsStatus> entry : statusSnapShot.getAll().entrySet()) {
            if (entry.getValue().isToDelete()) {
                this.removals.add(entry.getKey());
            }
            mon.worked(1);
        }
        this.save(expectedStamp);
    }

    public void save(String stamp) throws IOException {
        Path filePath = this.getFilePath();
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter w = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            w.write(stamp);
            w.newLine();
            for (MRef entry : this.removals) {
                w.write(entry.toString());
                w.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Path getFilePath() {
        return this.storageDir.resolve("detached.data");
    }

    public boolean contains(MRef ref) {
        return this.removals.contains(ref);
    }

    public void record(MRef deleted) {
        this.removals.add(deleted);
    }

    public boolean remove(MRef deleted) {
        return this.removals.remove(deleted);
    }

    public void open(IModelioProgress monitor, String expectedStamp) throws IOException {
        Path f = this.getFilePath();
        boolean ok = false;
        if (Files.isRegularFile(f, new LinkOption[0])) {
            try {
                ok = this.load(expectedStamp);
            }
            catch (IOException e) {
                Log.warning((Throwable)e);
            }
            if (!ok) {
                Log.warning((String)"Will rebuild the removal history");
            }
        }
        if (!ok) {
            try {
                this.rebuild(monitor, expectedStamp);
            }
            catch (CmsDriverException e) {
                throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
        }
    }
}

