/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.gproject.svn.fragment.recorder;

import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.repository.IHistoryHook;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.FragmentRemovalHistory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.modelio.gproject.core.IGProject;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class RemovalRecorder {
    private Map<CmsVersionedRepository, FragmentRemovalHistory> repositoryHooks = new HashMap<CmsVersionedRepository, FragmentRemovalHistory>();
    private static final Map<ICoreSession, RemovalRecorder> instances = new WeakHashMap<ICoreSession, RemovalRecorder>();

    public CmsVersionedRepository getInitialRepository(MRef ref) {
        for (Map.Entry<CmsVersionedRepository, FragmentRemovalHistory> entry : this.repositoryHooks.entrySet()) {
            if (!entry.getValue().contains(ref)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Map.Entry<CmsVersionedRepository, FragmentRemovalHistory> getInitialEntry(MRef ref) {
        for (Map.Entry<CmsVersionedRepository, FragmentRemovalHistory> entry : this.repositoryHooks.entrySet()) {
            if (!entry.getValue().contains(ref)) continue;
            return entry;
        }
        return null;
    }

    public void record(MRef deleted, CmsVersionedRepository parentRepository) {
        if (this.getInitialEntry(deleted) == null) {
            this.repositoryHooks.get((Object)parentRepository).record(deleted);
        }
    }

    public void connect(GSvnFragment fragment) throws IOException {
        CmsVersionedRepository repo = fragment.getCmsRepository();
        Path storageDir = fragment.getRuntimeDirectory().resolve("removalHistory");
        FragmentRemovalHistory h = new FragmentRemovalHistory(repo, storageDir);
        this.repositoryHooks.put(repo, h);
        repo.registerHistoryHook(new Hook(h, repo));
    }

    void disconnect(CmsVersionedRepository repo) {
        this.repositoryHooks.remove((Object)repo);
    }

    public static RemovalRecorder get(IGProject project) {
        return RemovalRecorder.get(project.getSession());
    }

    public static RemovalRecorder get(ICoreSession session) {
        RemovalRecorder i = instances.get(session);
        if (i == null) {
            i = new RemovalRecorder();
            instances.put(session, i);
        }
        return i;
    }

    public void removeRecords(Stream<MRef> deletedElements) {
        deletedElements.forEach(cmsNodeRef -> {
            Map.Entry<CmsVersionedRepository, FragmentRemovalHistory> entry = this.getInitialEntry((MRef)cmsNodeRef);
            if (entry != null) {
                entry.getValue().remove((MRef)cmsNodeRef);
            }
        });
    }

    private class Hook
    implements IHistoryHook {
        private FragmentRemovalHistory history;
        private CmsVersionedRepository repo;

        public Hook(FragmentRemovalHistory history, CmsVersionedRepository repo) {
            this.history = history;
            this.repo = repo;
        }

        @Override
        public void open(IModelioProgress monitor, String expectedStamp) throws IOException {
            this.history.open(monitor, expectedStamp);
        }

        @Override
        public void onSave(String stamp) throws IOException {
            this.history.save(stamp);
        }

        @Override
        public void onClose() {
            RemovalRecorder.this.disconnect(this.repo);
        }

        @Override
        public void onDetachObject(SmObjectImpl object, SmObjectImpl cmsNode) {
            if (object.hasAnyStatus(0x8000000000L)) {
                MRef deletedRef = new MRef((MObject)object);
                if (object.getMClass().isCmsNode()) {
                    this.history.record(deletedRef);
                }
            }
        }

        @Override
        public void onAttachObject(SmObjectImpl obj, SmObjectImpl cmsNode) {
            this.history.remove(new MRef((MObject)obj));
        }
    }
}

