/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.platform.expertises.core.expertise;

import com.modeliosoft.modelio.platform.expertises.core.cp.IConfigurationPoint;
import com.modeliosoft.modelio.platform.expertises.core.expertise.IExpertise;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractInjectableExpertise
implements IExpertise {
    private final String id;
    private String label;
    private String tooltip;
    private Image icon;
    private final Map<Class<? extends IConfigurationPoint>, IConfigurationPoint> configurationPoints = new HashMap<Class<? extends IConfigurationPoint>, IConfigurationPoint>();
    @Inject
    private IEclipseContext context;

    @Override
    public <T extends IConfigurationPoint> T getConfigurationPoint(Class<T> type) {
        return (T)this.configurationPoints.get(type);
    }

    public AbstractInjectableExpertise(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image image) {
        this.icon = image;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    protected <T extends IConfigurationPoint> void addConfigurationPoint(Class<T> type, Class<? extends T> impl) {
        IConfigurationPoint newInstance = (IConfigurationPoint)ContextInjectionFactory.make(impl, (IEclipseContext)this.context);
        newInstance.initializeProvider(this);
        this.configurationPoints.put(type, newInstance);
    }

    @PreDestroy
    protected void finalize() throws Throwable {
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
        super.finalize();
    }

    @Override
    public void activate() {
        for (IConfigurationPoint configurationPoint : this.configurationPoints.values()) {
            configurationPoint.activate();
        }
    }

    @Override
    public void deactivate() {
        for (IConfigurationPoint configurationPoint : this.configurationPoints.values()) {
            configurationPoint.deactivate();
        }
    }

    public abstract void initConfigurationPoints();

    @Override
    @PostConstruct
    public final void init() {
        this.initConfigurationPoints();
    }

    public boolean isReady() {
        return this.context != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + "]";
    }
}

