/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio;

import com.modeliosoft.modelio.utils.ProcessManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractModelioLauncherMojo
extends AbstractMojo {
    @Parameter
    private File jythonScriptFile;
    @Parameter
    private File workspaceDir;
    @Parameter
    private String projectName;
    @Parameter
    private File modelioDir;

    public void execute() throws MojoExecutionException {
        ProcessManager pm;
        String os_name = System.getProperty("os.name").toString();
        String[] command = new String[]{String.valueOf(this.modelioDir) + File.separator + "modelio.exe", "-workspace", this.workspaceDir.toString(), "-project", this.projectName, "-batch", this.jythonScriptFile.toString()};
        if (os_name.startsWith("Linux")) {
            command[0] = String.valueOf(this.modelioDir) + File.separator + "modelio.sh";
        }
        if ((pm = new ProcessManager(this.getLog())).execute(command, true) != 0) {
            throw new MojoExecutionException("Error during execution");
        }
    }

    protected File getJythonScriptFile() {
        return this.jythonScriptFile;
    }

    protected void setJythonScriptFile(File jythonScriptFile) {
        this.jythonScriptFile = jythonScriptFile;
    }

    protected File getModelioDir() {
        return this.modelioDir;
    }

    protected void setModelioDir(File modelioDir) {
        this.modelioDir = modelioDir;
    }

    protected File getWorkspaceDir() {
        return this.workspaceDir;
    }

    protected void setWorkspaceDir(File workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    protected String getProjectName() {
        return this.projectName;
    }

    protected void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected File saveTempFile(InputStream in) throws IOException {
        Path outputFile = Files.createTempFile("modelio-maven", ".py", new FileAttribute[0]);
        Files.copy(in, outputFile, new CopyOption[0]);
        return outputFile.toFile();
    }
}

