/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio;

import com.modeliosoft.modelio.moduleconf.ConfEditionService;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="module-configuration", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ConfGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="res/module.xml")
    private File moduleFile;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Updating content of " + String.valueOf(this.moduleFile)));
        Collection dependencies = this.mavenProject.getArtifacts().stream().filter(a -> !this.excludeDependency((Artifact)a)).collect(Collectors.toList());
        this.updateModuleConfFile(this.moduleFile, dependencies);
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    private void updateModuleConfFile(File moduleConfFile, Collection<Artifact> dependencies) throws MojoExecutionException {
        ConfEditionService service = new ConfEditionService(moduleConfFile.toPath(), dependencies);
        service.updateModuleFile();
    }

    private boolean excludeDependency(Artifact dependency) {
        String id = dependency.getArtifactId();
        return "provided".equals(dependency.getScope()) || id.startsWith("org.modelio.documentation") || id.startsWith("com.modeliosoft.modelio.documentation");
    }
}

