/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio;

import com.modeliosoft.modelio.moduleconf.ConfValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(defaultPhase=LifecyclePhase.VALIDATE, name="module-validation", requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ConfValidateMojo
extends AbstractMojo {
    @Parameter(defaultValue="res/module.xml")
    private File moduleFile;
    @Parameter(defaultValue="${project.basedir}/src/main/java/")
    private File sourceBasedir;
    @Parameter(defaultValue="${project.version}")
    private String version;
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        List<String> classpathElements = this.getClasspathElements();
        if (classpathElements.isEmpty()) {
            throw new MojoExecutionException("no element in classpath");
        }
        this.getLog().info((CharSequence)("Updating content of " + String.valueOf(this.moduleFile)));
        this.validateClassPath(classpathElements);
    }

    public String getVersion() {
        return this.version;
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    public File getSourceBasedir() {
        return this.sourceBasedir;
    }

    public void setSourceBasedir(File sourceBasedir) {
        this.sourceBasedir = sourceBasedir;
    }

    private void validateClassPath(List<String> classpathElements) throws MojoExecutionException {
        ConfValidation service = new ConfValidation(this.moduleFile.toPath(), this.sourceBasedir.toPath(), this.version, classpathElements);
        service.validate();
    }

    protected List<String> getClasspathElements() {
        ArrayList<String> paths = new ArrayList<String>();
        Set dependencies = this.project.getArtifacts();
        if (dependencies != null) {
            for (Artifact dependency : dependencies) {
                this.getLog().debug((CharSequence)String.format("Adding '%s-%s' artifact : %s", dependency.getArtifactId(), dependency.getVersion(), dependency.getFile().getPath()));
                paths.add(dependency.getFile().getPath());
            }
        }
        return paths;
    }
}

