/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio;

import com.modeliosoft.modelio.AbstractModelioLauncherMojo;
import com.modeliosoft.modelio.utils.ProcessManager;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.modelio.vbasic.files.FileUtils;

@Mojo(name="create-project")
public class ModelioProjectCreatorMojo
extends AbstractModelioLauncherMojo {
    @Parameter(defaultValue="Default")
    private String templateName;

    protected String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Creating Modelio Project");
        File projectFile = new File(this.getWorkspaceDir(), this.getProjectName());
        if (!projectFile.exists()) {
            try {
                File emptyJython = File.createTempFile("modelio-maven", ".py");
                String[] command = new String[]{String.valueOf(this.getModelioDir()) + File.separator + "modelio.exe", "-workspace", this.getWorkspaceDir().toString(), "-project", this.getProjectName(), "-script", emptyJython.toString(), "-template", this.getTemplateName()};
                ProcessManager pm = new ProcessManager(this.getLog());
                if (pm.execute(command, true) != 0) {
                    throw new MojoExecutionException("Error during execution");
                }
                emptyJython.delete();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error during execution: " + FileUtils.getLocalizedMessage((IOException)e), (Exception)e);
            }
        }
    }
}

