/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.moduleconf;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.modelio.gproject.data.module.JaxbModelPersistence;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2ExternDocumentType;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Module;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2MultiPathes;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2NoteType;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2PropertyDefinition;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2PropertyTableDefinition;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2TagType;
import org.modelio.gproject.data.module.jaxbv2.ObjectFactory;

public class ConfEditionService {
    private Path moduleFile;
    private HashSet<String> uids;
    private Collection<Artifact> dependencies;

    public ConfEditionService(Path moduleFile, Collection<Artifact> dependencies) {
        this.moduleFile = moduleFile;
        this.uids = new HashSet();
        this.dependencies = dependencies;
    }

    private static boolean isJarArtifact(Artifact a) {
        String type = a.getType();
        return type == null || type.isEmpty() || type.equals("jar");
    }

    public void updateModuleFile() throws MojoExecutionException {
        Jxbv2Module.Jxbv2Parameters parameters;
        Jxbv2Module.Jxbv2Profiles profiles;
        Jxbv2Module module = this.loadModule();
        if (module.getUid() == null) {
            module.setUid(this.getUUID());
        } else if (!this.isValid(module.getUid().toString())) {
            module.setUid(this.getUUID());
        }
        Jxbv2MultiPathes paths = module.getClassPath();
        if (paths != null) {
            block0: for (Object entry : new ArrayList(paths.getPathEntry())) {
                String string = entry.getPath();
                int idx = entry.getPath().lastIndexOf("-");
                String fileName = idx > 0 ? string.substring(0, idx) : ((idx = entry.getPath().lastIndexOf(".jar")) > 0 ? string.substring(0, idx) : string);
                String jarName = fileName.replace("lib/", "");
                for (Artifact realDependency : this.dependencies) {
                    if (!ConfEditionService.isJarArtifact(realDependency) || !realDependency.getArtifactId().equals(jarName)) continue;
                    paths.getPathEntry().remove(entry);
                    continue block0;
                }
            }
            ObjectFactory jxb2Factory = new ObjectFactory();
            for (Artifact artifact : this.dependencies) {
                if (!ConfEditionService.isJarArtifact(artifact)) continue;
                Jxbv2MultiPathes.Jxbv2PathEntry newEntry = jxb2Factory.createMultiPathesPathEntry();
                newEntry.setPath("lib/" + artifact.getFile().getName());
                paths.getPathEntry().add(newEntry);
            }
            HashSet entries = new HashSet();
            for (Jxbv2MultiPathes.Jxbv2PathEntry entry : new ArrayList(paths.getPathEntry())) {
                String path = entry.getPath();
                if (entries.contains(path)) {
                    paths.getPathEntry().remove(entry);
                    continue;
                }
                entries.add(path);
            }
        }
        if ((profiles = module.getProfiles()) != null) {
            for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile jxbv2Profile : profiles.getProfile()) {
                Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference.Jxbv2ExternDocumentTypes docTypes;
                Object note2;
                Object noteTypes;
                Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference.Jxbv2TagTypes tagTypes;
                if (jxbv2Profile.getUid() == null) {
                    jxbv2Profile.setUid(this.getUUID());
                } else if (!this.isValid(jxbv2Profile.getUid().toString())) {
                    jxbv2Profile.setUid(this.getUUID());
                }
                for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference stereotype : jxbv2Profile.getMetaclassReference()) {
                    if (stereotype.getUid() == null) {
                        stereotype.setUid(this.getUUID());
                    } else if (!this.isValid(stereotype.getUid().toString())) {
                        stereotype.setUid(this.getUUID());
                    }
                    tagTypes = stereotype.getTagTypes();
                    if (tagTypes != null) {
                        for (Jxbv2TagType tag2 : tagTypes.getTagType()) {
                            if (tag2.getUid() == null) {
                                tag2.setUid(this.getUUID());
                                continue;
                            }
                            if (this.isValid(tag2.getUid().toString())) continue;
                            tag2.setUid(this.getUUID());
                        }
                    }
                    if ((noteTypes = stereotype.getNoteTypes()) != null) {
                        Jxbv2TagType tag2;
                        tag2 = noteTypes.getNoteType().iterator();
                        while (tag2.hasNext()) {
                            note2 = (Jxbv2NoteType)tag2.next();
                            if (note2.getUid() == null) {
                                note2.setUid(this.getUUID());
                                continue;
                            }
                            if (this.isValid(note2.getUid().toString())) continue;
                            note2.setUid(this.getUUID());
                        }
                    }
                    if ((docTypes = stereotype.getExternDocumentTypes()) == null) continue;
                    for (Jxbv2ExternDocumentType doc : docTypes.getExternDocumentType()) {
                        if (doc.getUid() == null) {
                            doc.setUid(this.getUUID());
                            continue;
                        }
                        if (this.isValid(doc.getUid().toString())) continue;
                        doc.setUid(this.getUUID());
                    }
                }
                for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference stereotype : jxbv2Profile.getStereotype()) {
                    Jxbv2PropertyTableDefinition propertyTable;
                    if (stereotype.getUid() == null) {
                        stereotype.setUid(this.getUUID());
                    } else if (!this.isValid(stereotype.getUid().toString())) {
                        stereotype.setUid(this.getUUID());
                    }
                    tagTypes = stereotype.getTagTypes();
                    if (tagTypes != null) {
                        noteTypes = tagTypes.getTagType().iterator();
                        while (noteTypes.hasNext()) {
                            Jxbv2TagType tag = (Jxbv2TagType)noteTypes.next();
                            if (tag.getUid() == null) {
                                tag.setUid(this.getUUID());
                                continue;
                            }
                            if (this.isValid(tag.getUid().toString())) continue;
                            tag.setUid(this.getUUID());
                        }
                    }
                    if ((noteTypes = stereotype.getNoteTypes()) != null) {
                        for (Object note2 : noteTypes.getNoteType()) {
                            if (note2.getUid() == null) {
                                note2.setUid(this.getUUID());
                                continue;
                            }
                            if (this.isValid(note2.getUid().toString())) continue;
                            note2.setUid(this.getUUID());
                        }
                    }
                    if ((docTypes = stereotype.getExternDocumentTypes()) != null) {
                        note2 = docTypes.getExternDocumentType().iterator();
                        while (note2.hasNext()) {
                            Jxbv2ExternDocumentType doc;
                            doc = (Jxbv2ExternDocumentType)note2.next();
                            if (doc.getUid() == null) {
                                doc.setUid(this.getUUID());
                                continue;
                            }
                            if (this.isValid(doc.getUid().toString())) continue;
                            doc.setUid(this.getUUID());
                        }
                    }
                    if ((propertyTable = stereotype.getPropertyTable()) == null) continue;
                    if (propertyTable.getUid() == null) {
                        propertyTable.setUid(this.getUUID());
                    } else if (!this.isValid(propertyTable.getUid().toString())) {
                        propertyTable.setUid(this.getUUID());
                    }
                    for (Jxbv2PropertyDefinition propertyDefinition : propertyTable.getPropertyDefinition()) {
                        if (propertyDefinition.getUid() == null) {
                            propertyDefinition.setUid(this.getUUID());
                            continue;
                        }
                        if (this.isValid(propertyDefinition.getUid().toString())) continue;
                        propertyDefinition.setUid(this.getUUID());
                    }
                }
            }
        }
        if ((parameters = module.getParameters()) != null) {
            for (Jxbv2Module.Jxbv2Parameters.Jxbv2Parameter parameter : parameters.getParameter()) {
                if (parameter.getUid() == null) {
                    parameter.setUid(this.getUUID());
                } else if (!this.isValid(parameter.getUid().toString())) {
                    parameter.setUid(this.getUUID());
                }
                if ("Enum".equalsIgnoreCase(parameter.getType()) || parameter.getEnumeration() == null) continue;
                parameter.setType("Enum");
            }
        }
        this.saveModule(module);
    }

    public void addLibrary() throws MojoExecutionException {
        Jxbv2Module module = this.loadModule();
        this.saveModule(module);
    }

    private boolean isValid(String uid) {
        try {
            UUID.fromString(uid);
        }
        catch (Exception e) {
            return false;
        }
        if (this.uids.contains(uid)) {
            return false;
        }
        this.uids.add(uid);
        return true;
    }

    private String getUUID() {
        return UUID.randomUUID().toString();
    }

    private Jxbv2Module loadModule() throws MojoExecutionException {
        try {
            return JaxbModelPersistence.loadJaxbModel((Path)this.moduleFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getCause().getMessage());
        }
    }

    private void saveModule(Jxbv2Module module) throws MojoExecutionException {
        try {
            try (OutputStream outputStream = Files.newOutputStream(this.moduleFile, new OpenOption[0]);){
                String packageName = Jxbv2Module.class.getPackage().getName();
                JAXBContext jaxbContext = JAXBContext.newInstance((String)packageName);
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)module, outputStream);
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getCause().getMessage());
        }
    }
}

