/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.moduleconf;

import com.modeliosoft.modelio.AbstractModelioLauncherMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.modelio.gproject.data.module.JaxbModelPersistence;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Handler;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Module;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Tool;
import org.modelio.vbasic.files.FileUtils;

public class ConfValidation
extends AbstractModelioLauncherMojo {
    private Path moduleFile;
    private Path sourceBasedir;
    private String version;
    private List<String> classNames;

    public ConfValidation(Path moduleFile, Path sourceBasedir, String version, List<String> classpathElements) throws MojoExecutionException {
        this.moduleFile = moduleFile;
        this.sourceBasedir = sourceBasedir;
        this.version = version;
        this.classNames = new ArrayList<String>();
        for (String elementPath : classpathElements) {
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(elementPath));){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".class") && !entry.isDirectory()) {
                        StringBuilder className = new StringBuilder();
                        for (String part : entry.getName().split("/")) {
                            if (className.length() != 0) {
                                className.append(".");
                            }
                            className.append(part);
                            if (!part.endsWith(".class")) continue;
                            className.setLength(className.length() - ".class".length());
                        }
                        this.classNames.add(className.toString());
                    }
                    entry = zip.getNextEntry();
                }
                zip.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException(FileUtils.getLocalizedMessage((IOException)e), (Exception)e);
            }
        }
    }

    public void validate() throws MojoExecutionException {
        Jxbv2Module module = null;
        try {
            module = JaxbModelPersistence.loadJaxbModel((Path)this.moduleFile);
        }
        catch (FileSystemException e) {
            throw new MojoExecutionException(FileUtils.getLocalizedMessage((IOException)e), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
        if (!this.existingClass(module.getClazz())) {
            throw new MojoExecutionException("[module.xml][module]  The Class " + module.getClazz() + "  is missing.");
        }
        if (!ConfValidation.isVersion(this.version)) {
            throw new MojoExecutionException("[Version]  The Version of module mutch must follow this pattern *.*.** (exemple : 2.1.00)");
        }
        Jxbv2Module.Jxbv2Gui gui = module.getGui();
        if (gui != null) {
            Jxbv2Module.Jxbv2Gui.Jxbv2Views views;
            Jxbv2Module.Jxbv2Gui.Jxbv2Commands commands = gui.getCommands();
            if (commands != null) {
                Jxbv2Module.Jxbv2Gui.Jxbv2Diagrams diags;
                for (Object command : commands.getCommand()) {
                    Jxbv2Handler handler = command.getHandler();
                    if (handler == null || handler.getClazz() == null || this.existingClass(handler.getClazz())) continue;
                    throw new MojoExecutionException("[module.xml - Commande][" + command.getId() + "]  The Class " + handler.getClazz() + "  is missing.");
                }
                Jxbv2Module.Jxbv2Gui.Jxbv2Tools tools = gui.getTools();
                if (tools != null) {
                    for (Jxbv2Tool tool : tools.getTool()) {
                        Jxbv2Handler handler = tool.getHandler();
                        if (handler.getClazz() == null || this.existingClass(handler.getClazz())) continue;
                        throw new MojoExecutionException("[module.xml - Tool][" + tool.getId() + "]  The Class " + handler.getClazz() + "  is missing.");
                    }
                }
                if ((diags = gui.getDiagrams()) != null) {
                    for (Jxbv2Module.Jxbv2Gui.Jxbv2Diagrams.Jxbv2DiagramType dtype : diags.getDiagramType()) {
                        Jxbv2Handler diagHandler;
                        Jxbv2Module.Jxbv2Gui.Jxbv2Diagrams.Jxbv2DiagramType.Jxbv2Wizard wiz = dtype.getWizard();
                        if (wiz != null) {
                            Jxbv2Handler handler = wiz.getHandler();
                            if (handler == null) {
                                throw new MojoExecutionException("[module.xml - Wizard][" + wiz.getLabel() + "]  The handler is missing.");
                            }
                            if (handler.getClazz() != null && !this.existingClass(handler.getClazz())) {
                                throw new MojoExecutionException("[module.xml - Wizard][" + wiz.getLabel() + "]  The Class " + handler.getClazz() + "  is missing.");
                            }
                        }
                        if ((diagHandler = dtype.getHandler()) == null) {
                            throw new MojoExecutionException("[module.xml - Diagram Handler][" + dtype.getStereotype() + "]  Handler  is missing.");
                        }
                        if (diagHandler.getClazz() == null || this.existingClass(diagHandler.getClazz())) continue;
                        throw new MojoExecutionException("[module.xml - Diagram Handler][" + dtype.getStereotype() + "]  The Class " + diagHandler.getClazz() + "  is missing.");
                    }
                }
            }
            if ((views = gui.getViews()) != null) {
                for (Jxbv2Module.Jxbv2Gui.Jxbv2Views.Jxbv2PropertyPage prop : views.getPropertyPage()) {
                    if (this.existingClass(prop.getClazz())) continue;
                    throw new MojoExecutionException("[module.xml - Property Page][" + prop.getId() + "]  The Class " + prop.getClazz() + "  is missing.");
                }
            }
        }
        HashSet<String> names = new HashSet<String>();
        Jxbv2Module.Jxbv2Parameters parameters = module.getParameters();
        if (parameters != null) {
            for (Jxbv2Module.Jxbv2Parameters.Jxbv2Parameter parameter : parameters.getParameter()) {
                if ("Enum".equalsIgnoreCase(parameter.getType()) && parameter.getEnumeration() == null) {
                    throw new MojoExecutionException("[module.xml - Parameter][" + parameter.getId() + "]  has \"Enum\" type but does not define the Enumeration.");
                }
                if (names.add(parameter.getId())) continue;
                throw new MojoExecutionException("[module.xml - Parameter][" + parameter.getId() + "]  must be unique.");
            }
        }
    }

    private static boolean isVersion(String version) {
        Pattern p = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+");
        Matcher m = p.matcher(version);
        return m.matches();
    }

    private boolean existingClass(String clazz) {
        switch (clazz) {
            case "GenericElementCreationHandler": 
            case "GenericDiagramCreationHandler": 
            case "ElementCreate": 
            case "DiagramCreate": 
            case "AttachedBox": 
            case "Multilink": 
            case "Link": 
            case "Box": 
            case "StandardCustomizer": 
            case "GenericWizardContributor": 
            case "RunJyScript": 
            case "DocumentGenerate": 
            case "PatternApply": 
            case "MatrixCreate": {
                return true;
            }
        }
        String[] dirs = clazz.split("\\.");
        if (Files.exists(this.sourceBasedir, new LinkOption[0])) {
            Object path = this.sourceBasedir.toString();
            for (String dir : dirs) {
                path = (String)path + "/" + dir;
            }
            if (new File((String)path + ".java").exists()) {
                return true;
            }
        }
        return this.classNames.contains(clazz);
    }
}

