/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18nMessageService {
    private static final String FILE_NAME_MESSAGES = "res/message";
    private static I18nMessageService instance;
    private ResourceBundle messageResource;

    private I18nMessageService() {
        Locale locale = Locale.getDefault();
        this.messageResource = ResourceBundle.getBundle(FILE_NAME_MESSAGES, locale);
    }

    private static I18nMessageService getInstance() {
        if (null == instance) {
            instance = new I18nMessageService();
        }
        return instance;
    }

    private ResourceBundle getMessageResource() {
        return this.messageResource;
    }

    public static String getString(String key) {
        return I18nMessageService.getInstance().getMessageResource().getString(key);
    }

    public static String getString(String key, String ... params) {
        Object message = null;
        try {
            String value = I18nMessageService.getString(key);
            message = MessageFormat.format(value, params);
        }
        catch (MissingResourceException e) {
            message = "!" + key + "!";
        }
        return message;
    }
}

